<?php
/*
Plugin Name: Snap Shots&trade; Plugin
Version: 1.3
Plugin URI: http://ajaydsouza.com/wordpress/plugins/snap-preview-anywhere/
Description: Add <a href="http://www.snap.com/about/spa1A.php">Snap Shots</a> to your blog. Go to <a href="options-general.php?page=spa_options">Options &gt;&gt; Snap Shots</a> to configure.
Author: Ajay D'Souza
Author URI: http://ajaydsouza.com/
*/ 

if (!defined('ABSPATH')) die("Aren't you supposed to come here via WP-Admin?");

define('ALD_Snap_Shots_DIR', dirname(__FILE__));

/*********************************************************************
*				Main Function (Do not edit)							*
********************************************************************/
function ald_spa()
{
	$spa_settings = spa_read_options();
	
	if($spa_settings[key]=='')
	{
		$str = 'Please visit WP-Admin &gt; Options &gt; Snap Shots and enter the key. <a href="http://ajaydsouza.com/archives/2007/01/02/how-to-find-your-spa-key/">How to find your key</a>';
	}
	else
	{
		$str = '<script defer="defer" type="text/javascript" src="http://shots.snap.com/snap_shots.js?ap=';
		if ($spa_settings[alllinks]) {
			$str .= '1';
		} else {
			$str .= '0';
		}
		
		$str .= '&amp;si=';
		if ($spa_settings[locallinks]) {
			$str .= '1';
		} else {
			$str .= '0';
		}

		$str .= '&amp;key=' . $spa_settings[key];
		
		$str .= '&amp;sb=';
		if ($spa_settings[searchbox]) {
			$str .= '1';
		} else {
			$str .= '0';
		}

		$str .= '&amp;link_icon=';
		if ($spa_settings[link_icon]) {
			$str .= 'on';
		} else {
			$str .= 'off';
		}

		$str .= '&amp;oi=';
		if ($spa_settings[userpreview]) {
			$str .= '1';
		} else {
			$str .= '0';
		}

		$str .= '&amp;cl=';
		if ($spa_settings[customlogo]) {
			$str .= '1';
		} else {
			$str .= '0';
		}

		$str .= '&amp;po=';
		if ($spa_settings[previewshots]) {
			$str .= '1';
		} else {
			$str .= '0';
		}

		if ($spa_settings[theme]) $str .= '&amp;th='. $spa_settings[theme];

		if ($spa_settings[preview_trigger]) $str .= '&amp;preview_trigger='. $spa_settings[preview_trigger];

		$str .= '&amp;domain='. $spa_settings[url] . '"></script>';
	}
	
	return $str;
}

function spa_read_options() 
{
	if(!is_array(get_option('ald_spa_settings')))
	{
		$spa_settings = spa_default_options();
		update_option('ald_spa_settings', $spa_settings);
	}
	else
	{
		$spa_settings = get_option('ald_spa_settings');
	}
	return $spa_settings;
}

// Functions to echo the necessary code
add_action('wp_footer', 'ald_spa_display');
function ald_spa_display($force = false) {
	$spa_settings = spa_read_options();

	if ($force || $spa_settings['footer'])
	{
		echo ald_spa();
	}
}

// Add an action called echo_spa so that it can be called using do_action('echo_spa');
add_action('echo_spa', 'echo_spa_function');
function echo_spa_function() {
	$spa_settings = spa_read_options();
	if (!$spa_settings['footer'])
	{
		ald_spa_display(true);
	}
}


// Add an action called echo_spa so that it can be called using do_action('echo_spa_visitor');
add_action('echo_spa_visitor', 'echo_spa_visitor_function');
function echo_spa_visitor_function() {
	$spa_settings = spa_read_options();
	if ($spa_settings[userpreview]) {
?>

<iframe frameborder="no" scrolling="no" width="175" height="105"  src="http://spa.snap.com/badge/<?php echo $spa_settings[key]; ?>/"></iframe>

<?php 
	}
}

// This function adds an Options page in WP Admin
if (is_admin() || strstr($_SERVER['PHP_SELF'], 'wp-admin/')) {
	require_once(ALD_Snap_Shots_DIR . "/admin.inc.php");
}


?>