<?php
/*
Plugin Name: Picasa Photos
Plugin URI: http://www.sandaru1.com/2007/07/11/picasa-widget-updated/
Description: Pick photos from picasa album and display them randomly
Author: Sandaruwan Gunathilake
Version: 1.1
Author URI: http://www.sandaru1.com
*/

function widget_picasa_init() {
	
	if ( !function_exists('register_sidebar_widget') || !function_exists('register_widget_control') )
		return;

	function widget_picasa_control() {
		$options = $newoptions = get_option('widget_picasa');
		if ( $_POST['picasa-submit'] ) {
			$newoptions['user'] = strip_tags(stripslashes($_POST['picasa-user']));
			$newoptions['title'] = strip_tags(stripslashes($_POST['picasa-title']));
			$newoptions['delay'] = strip_tags(stripslashes($_POST['picasa-delay']));
			$newoptions['num'] = strip_tags(stripslashes($_POST['picasa-num']));
			$newoptions['size'] = strip_tags(stripslashes($_POST['picasa-size']));
		}
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option('widget_picasa', $options);
		}
	?>
<p style="text-align:left"><label for="picasa-title"><?php _e('Title:', 'widgets'); ?> <br/><input style="width: 250px;" id="picasa-title" name="picasa-title" value="<?php echo wp_specialchars($options['title'], true); ?>" type="text"></label></p>
<p style="text-align:left"><label for="picasa-user"><?php _e('Picasa Username:', 'widgets'); ?> <br/><input style="width: 250px;" id="picasa-title" name="picasa-user" value="<?php echo wp_specialchars($options['user'], true); ?>" type="text"></label></p>
<p style="text-align:left"><label for="picasa-num"><?php _e('Number of photos:', 'widgets'); ?> <br/><input style="width: 250px;" id="picasa-num" name="picasa-num" value="<?php echo wp_specialchars($options['num'], true); ?>" type="text"></label></p>
<p style="text-align:left"><label for="picasa-size"><?php _e('Image Size:', 'widgets'); ?> <br/><select style="width: 250px;" id="picasa-size" name="picasa-size"><option value="288" <?=($options['size']==288?'selected':'') ?> >288</option><option value="160" <?=($options['size']==160?'selected':'') ?> >160</option><option value="72" <?=($options['size']==72?'selected':'') ?> >72</option></select></label></p>
<p style="text-align:left"><label for="picasa-delay"><?php _e('RSS Download Delay(Days):', 'widgets'); ?> <br/><input style="width: 250px;" id="picasa-delay" name="picasa-delay" value="<?php echo wp_specialchars($options['delay'], true); ?>" type="text"></label><br/><label for="picasa-delay" style="font-size:10px"><?php _e('Last Download at ', 'widgets'); ?> <?php echo date("l dS \of F Y h:i:s A",$options['last']); ?></label></p>
				<input type="hidden" name="picasa-submit" id="delicious-submit" value="1" />
	<?php
	}
	
	function picasa_get_photo($option) {
		if ( file_exists(ABSPATH . WPINC . '/rss.php') )
			require_once(ABSPATH . WPINC . '/rss.php');
		else
			require_once(ABSPATH . WPINC . '/rss-functions.php');
		$delay = (is_numeric($option['delay'])?$option['delay']:1)*24*60*60;
		if ($option['last']=="") 
			$option['last'] = 0;
		if ($option['num']=="")
			$option['num'] = 1;
		$photo = array();
		if ((time() - $option['last'])>$delay) {
			$option['last']=time();
			$users=split(' ',$option['user']);
			foreach($users as $user) {
				$us = split("\(",$user);
				$user = $us[0];
				$album = str_replace(')','',$us[1]);
				$rss = fetch_rss("http://picasaweb.google.com/data/feed/base/user/".$user."?kind=album&alt=rss&hl=en_US&access=public");
				if (is_array($rss->items)) {
					foreach($rss->items as $item) {
						if ($album!="" && $album != $item['title'])
							continue;
						$rss2 = fetch_rss(str_replace("entry","feed",$item['guid'])."&kind=photo&alt=rss");
						if (!$rss2)
							continue;
						foreach($rss2->items as $item2) {
							preg_match('/.*src="(.*?)".*/',$item2['description'],$sub);
							$photos[]=array("photo" => $sub[1],"link" => $item2['link'],"title" => $item2['title']);
						}
					}
				}
			}
			if (count($photos)>0) {
				update_option('widget_picasa',$option);
				update_option('widget_picasa_photos',$photos);
			}
		}
		
		
		$photos = (array) get_option('widget_picasa_photos');

		for($i=0;$i<$option['num'];$i++) {
			$selected = $photos[rand(0,count($photos)-1)];
			
			$photo = $selected['photo'];
			if ($option['size']!=288) {
				$photo = str_replace('s288','s'.$option['size'],$photo);
			}
			
			$str.="<p style=\"text-align:center\"><a href=\"$selected[link]\"><img border=\"0\" src=\"$photo\" alt=\"$selected[title]\"/></a></p>";
		}
		return $str;
	}

	// This prints the widget
	function widget_picasa($args) {
		extract($args);
		$options = (array) get_option('widget_picasa');
		if ($options['title']=="") {
			$options['title'] = "Photos";
		}
		echo $before_widget . $before_title . $options['title'] . $after_title;
		if ($options['user']=="") {
			echo "Configure the widget first!";
		} else {
			echo picasa_get_photo($options);
		}
		echo $after_widget;
	}

	register_sidebar_widget(array('Picasa Photos', 'widgets'), 'widget_picasa');
	register_widget_control(array('Picasa Photos', 'widgets'), 'widget_picasa_control',300,300);
	
}

add_action('widgets_init', 'widget_picasa_init');

?>
