<?php
/*
Plugin Name: Category Page
Plugin URI: http://pixline.net/wordpress-plugins/category-page-plugin/
Description: Connect pages with one or more Category, and use them as introduction on category archives. 
Author: Pixline
Version: 0.4.2
Author URI: http://pixline.net/

Copyright (C) 2007 Paolo Tresso / Pixline (http://pixline.net/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


*/

$wpdb->page2cat	= $table_prefix . 'page2cat';
define("PAGE2CAT_VERSION","0.4.2");
define("PLUGIN_PATH",get_bloginfo('url')."/wp-content/plugins/page2cat/");

######################################################
# check version. this time we'll install a db table. #
######################################################

$version = get_option('pixline_page2cat_version');
if ($version != 4) {
	register_activation_hook(__FILE__, 'page2cat_install');
}

// DB installation. usually happen just one time.
function page2cat_install(){
global $wpdb;
	
	$query = "
	CREATE TABLE  `".$wpdb->prefix."page2cat` (
	 `rel_ID` BIGINT NOT NULL AUTO_INCREMENT ,
	 `page_ID` BIGINT NOT NULL ,
	 `cat_ID` BIGINT NOT NULL ,
	PRIMARY KEY (  `rel_ID` ) ,
	INDEX (  `page_ID` ,  `cat_ID` )
	);

	";
	if($wpdb->get_var("SHOW TABLES LIKE '".$wpdb->prefix."page2cat'") != $wpdb->prefix."page2cat") {
	require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
	dbDelta($query);
	update_option('pixline_page2cat_version', 3);
	}

update_option('p2c_use_img','no');
update_option('p2c_use_empty','no');
}

######################################
# setup management and option panels #
######################################


function page2cat_debug(){
	echo "<pre>";
	print_r($_POST);
	echo " ";
	print_r($_GET);
	echo "  ";
	print_r($_REQUEST);
	echo "  ";
	echo "</pre>";
exit();
}

// adds sidebox in page write/edit
function page2cat_init(){
		// these are in page2cat-sidebox.php
		add_action('dbx_page_sidebar', 'page2cat_add_sidebox');			 // add a sidebox when editing pages
		add_action('admin_head','page2cat_sidebox_styles');
}

// install management and options page
function page2cat_config_page() {
	if ( function_exists('add_submenu_page') && is_admin()):
	add_submenu_page('edit.php', __('Category Pages'), __('Category Pages'), 8, 'category-pages', 'page2cat_manage_page');
	endif;
	if( function_exists('add_options_page') && is_admin()):
	add_options_page('Category Pages options','Category Pages',8,'category-page-options','page2cat_options_page');
	endif;
}

// adds a panel under "manage » category pages"
// shows actual connections, and allow creations of new ones.
function page2cat_manage_page(){
global $wpdb, $wp_db_version, $vers;
$wpversion = $wp_db_version;

	$release = array(
		"5183"=>"2.2.1",
		"4773"=>"2.1.3"
		);

	if( isset($_POST['page2cat_action']) && $_POST['page2cat_action'] == 'new'):
		// we are creating something
		$pageid = $_POST['pageid'];
		foreach($pageid as $cat_id=>$page_id):
			if(trim($page_id) != ""):
			$sql = "INSERT INTO {$wpdb->page2cat} (rel_ID, page_ID, cat_ID) VALUES ('', '".$page_id."', '".$cat_id."');";
			$result = $wpdb->get_results($sql);
			endif;
		endforeach;
		echo('<div id="message" class="updated fade">
		<p><strong>New Category Page created succesfully.</strong></p></div>');
	endif;

/* maybe this isn't really used? */
	if( isset($_POST['page2cat_action']) && $_POST['page2cat_action'] == 'update'):
	// we are updating something
	$pageid = $_POST['pageid'];
	foreach($pageid as $cat_id=>$page_id):
		if(trim($page_id) != ""):
		$dati = array("page"=>$page_id,"cat"=>$cat_id);
	#	update_option("page2cat_".$cat_id,$dati);
		endif;
	endforeach;
	echo('<div id="message" class="updated fade"><p><strong>Category Pages updated.</strong></p></div>');
	endif;
/* end maybe */

	if( isset($_REQUEST['p2cdel']) && !isset($_REQUEST['p2c_confirm']) ):
	// we are deleting something

		$relid = $wpdb->escape($_REQUEST['p2cdel']);
		echo "<div class='wrap'><h2>Delete this Category &rsaquo; Page relation?</h2>";
		$opt = $wpdb->get_results("SELECT * FROM {$wpdb->page2cat} WHERE rel_ID = '".$relid."' LIMIT 1;");
		$catid = $opt[0]->cat_ID;
		$pageid = $opt[0]->page_ID;
		$catname = get_cat_name($catid);
		$page = get_page($pageid); 
		$title = $page->post_title;
		echo "<form name='p2c_confirm' method='post'>";
		echo "<p>You are going to delete the relationship between 
		Category <em>".$catname."</em> and Page <em>".$title."</em>. Confirm?</p>";
		echo '<p>
		<input type="hidden" name="p2cdel" value="'.$relid.'" />
		<input type="hidden" name="p2c_confirm" value="true" />
		<input type="reset" name="revert" value="Cancel" />
		<input type="submit" name="confirm" value="DELETE &raquo;" />
		</p></form>';
		echo "</div>";
	endif;


	// real delete...
	if( isset($_REQUEST['p2cdel']) && $_REQUEST['p2c_confirm'] == 'true'):
	$relid = $wpdb->escape($_REQUEST['p2cdel']);
	$myopts = $wpdb->get_results("DELETE FROM {$wpdb->page2cat} WHERE rel_ID = '".$relid."' LIMIT 1;");
	echo('<div id="message" class="updated fade"><p><strong>Binding deleted.</strong></p></div>');
	echo "<div class='wrap'><a href='edit.php?page=category-pages'>Back to Category Pages</a></div>";
	endif;

	// normal display: if we aren't dealing with some request, display tables
	$myopts = $wpdb->get_results("SELECT * FROM {$wpdb->page2cat};");
	$usedcats = array();
	$usedpages = array();


	if( !isset($_REQUEST['p2cdel'])):
		echo "<div class='wrap'><h2>Category Pages</h2>";

		if(count($myopts) != 0):
		echo "<h3>Already connected</h3>";
		echo "<div><p>In this page you can monitor your connections between Pages and Categories.</p>";

		// table #1: what categories and pages are already connected

		echo "<table class='widefat'>";
			echo "<thead>";
			echo "<tr>
			<td>Category <small>(categoryID)</small></td>
			<td>Page <small>(pageID)</small></td>
			<!-- td><small>(pageID)</small> <small>(catID)</small> <small>option name</small></td -->
			<td colspan='3'>&nbsp;</td>
			</tr>";
			echo "</thead><tbody>";
		foreach($myopts as $opt):
			$catid = $opt->cat_ID;
			$pageid = $opt->page_ID;
			$catname = get_cat_name($catid);
			$usedcats[] = $catid;
			$usedpages[] = $pageid;
			$page = get_page($pageid); 
			$title = $page->post_title;

		echo "<tr>
			<td>".$catname." <small>(#".$catid.")</small></td>
			<td>".$title." <small>(#".$pageid.")</small></td>
			<!-- td><small>(".$pageid.")</small> <small>(".$catid.")</small> <small>".$opt->option_name."</small></td -->
			<td><a href='".get_bloginfo('url')."/?cat=".$catid."' class='edit'> View Category Page </a></td>
			<td><a href='page.php?action=edit&post=".$pageid."' class='edit'> Edit Page </a></td>
			<td><a href='?page=category-pages&amp;p2cdel=".$opt->rel_ID."' class='delete'> Delete Connection </a></td>
			</tr>";
		endforeach;
		echo "</tbody>";
		echo "</table>";
		echo '<p class="submit">
		<input type="hidden" name="page2cat_action" value="new" />
		<input type="submit" name="update" value="Update Category Pages &raquo;" />
		</p>
		';
		echo "</div>";
		
		else:
		echo "<p>There's no connections available.</p>";
		endif;

		// others categories
		$excats = implode(',',$usedcats);
		$opt3 = get_option('p2c_use_empty');
		if($opt3 == "yes") $empty = false; elseif($opt3 == "no") $empty = true;

		$catdef = array('type' => 'post', 'child_of' => 0, 'orderby' => 'name', 'order' => 'ASC',
		'hide_empty' => $empty, 'include_last_update_time' => false, 'hierarchical' => true, 
		'exclude' => $excats, 'include' => '', 'number' => '', 'pad_counts' => true);
		$others = get_categories($catdef);
		$used = count($usedcats);
		$count = count($others);

		if( $count == 0):
		echo "<h3></h3>";
		echo "<p>Sorry, no other category, or only empty categories.<br/><small>Perhaps you'll like to 
		<a href='categories.php#addcat'>create a new category</a> or 
		<a href='options-general.php?page=category-page-options'>tweak plugin options</a>.</small></p>";	
		else:
#		echo "<h3>New connections</h3>";
		echo "<div><p>Those Categories don't have any page.. Would you like to choose one, or create a new one?</p>";
		echo "<form name='page2cat_manage' method='post'>
			<table class='widefat'>";
			echo "<thead>";
			echo "<tr>
			<td>Category <small>(items)</small></td>
			<td colspan='2'>Page</td>
			</tr>";
			echo "</thead><tbody>";

		$pages_already_used = implode(',',$usedpages);	
			foreach($others as $otro):
	// 		use db version and identify WP
			switch($vers):
				case ($vers >= 4773):
				$versioned_catid = $otro->cat_ID;
				$versioned_catname = $otro->cat_name;
				$versioned_count = $otro->category_count + $otro->posts_private;
				break;
				case ($vers >= 5183):
				default:
				$versioned_catid = $otro->term_id;
				$versioned_catname = $otro->name;
				$versioned_count = $otro->count;
				break;
			endswitch;

		$ddprefs = array('depth' => 0, 'child_of' => 0, 'selected' => 0, 
		'echo' => 0,'name' => 'pageid['.$versioned_catid.']', 
		'show_option_none' => ' &rsaquo; choose a page &rsaquo;');

			echo "<tr>
			<td>".$versioned_catname." <small>(".$versioned_count.")</small></td>
			<td>";
			if(wp_dropdown_pages($ddprefs))
				echo "".wp_dropdown_pages($ddprefs)."</td>";

			echo "<td><a href='page-new.php?p2c=".$versioned_catid."'>Create New</a></td>
			</tr>";
			endforeach;
			echo "</tbody>";
			echo "</table></div>";

			echo '<p class="submit">
			<input type="hidden" name="page2cat_action" value="new" />
			<input type="submit" name="update" value="Update Category Pages &raquo;" />
			</p>
			';

		echo "</form>";
		endif;
		echo "</div>";

		$dbstring = "";
		if(SHOW_DB_VERSION == true)
			$dbstring = "<small>DB Version: ".$wpversion.". So, this is WP ".$release[$wp_db_version]."</small>"; 
		echo "<div id='pixline-credits' class='wrap'>
		<strong><a href='http://pixline.net/wordpress-plugins/category-page-plugin/'>Category Page</a></strong> plugin v".PAGE2CAT_VERSION." &raquo; <small><a href='options-general.php?page=category-page-options'>Tweak plugin options</a> &rsaquo;
		<a href='http://pixline.net/wordpress-plugins/category-page-plugin/'>Check for updates and support</a></small>. ".$dbstring."
		</div>";	

	endif;
}

// adds styles in admin head
function page2cat_sidebox_styles(){
?>
<style type="text/css" media="screen">

#p2c-scroller{
	height:120px;
	overflow:auto;
	width:90%;
	margin:0% 5%;
}

#p2c-box p{
	margin:0px;
	padding:5px;
	font-size:80%;
}

ul#p2c-bind, ul#p2c-free,
ul#p2c-bind li, ul#p2c-free li{
	margin:0px;
	padding:0px;
	list-style-type:none;
}

ul#p2c-bind{
	font-size:90%;
	margin:1% 0%;
}


ul#p2c-free{
	font-size:80%;
	color:#333;
	margin:2%;
}

ul#p2c-free li{
	padding:2px 1px;
}

.p2c-count{
	color:#AAA;
}

.p2c-indent{
	padding-left:10px;
}

.p2c-used{
	color:#D66;
	text-decoration:line-through;
}

</style>
<?php
}

// adds sidebox in page editing
function page2cat_add_sidebox($post_ID){
	global $wpdb, $post_ID, $_REQUEST;
	if(isset($_REQUEST['p2c'])):
		echo "";
	endif;
	
	$mypage = $wpdb->get_results("SELECT * FROM {$wpdb->page2cat} WHERE page_ID = '".$post_ID."';",OBJECT);
?>
<fieldset id="p2c-select" class="dbx-box">
<h3 class="dbx-handle">Category Pages</h3>
<div class="dbx-content" id="p2c-box">
	<p>Use this page as <a href='edit.php?page=category-pages'>Category Page</a> for these categories.</p>
<?php
$usedcats = array();
if(count($mypage)>0):
	echo "<ul id='p2c-bind'>";
	foreach($mypage as $connection):
#		print_r($connection);
		echo "<li><input type='checkbox' checked='checked' value='".$connection->cat_ID."' name='p2c_bind[]' 
		id='p2c".$connection->cat_ID."' /> ".get_cat_name($connection->cat_ID)."</li>
		";
		$usedcats[] = $connection->cat_ID;
	endforeach;
	echo "</ul>";
endif;

$usate = implode(',',$usedcats);
	$opt3 = get_option('p2c_use_empty');
#	echo $opt3; exit();
	if($opt3 == "yes") $empty = false; elseif($opt3 == "no") $empty = true;

$catdef = array('type' => 'post', 'child_of' => 0, 'orderby' => 'name', 'order' => 'ASC', 'exclude' => $usate, 
				'hide_empty' => $empty, 'include_last_update_time' => false, 'hierarchical' => true, 'pad_counts' => true);

$others = get_categories($catdef);
echo "<div id='p2c-scroller'>";
echo "<ul id='p2c-free'>";
foreach($others as $cat):
#print_r($cat); exit();

$has_page = $wpdb->get_var("SELECT count(*) FROM {$wpdb->page2cat} WHERE cat_ID = '".$cat->cat_ID."'");
if($has_page == 0):
echo "<li><input type='checkbox' name='p2c_bind[]' id='p2c".$cat->cat_ID."' value='".$cat->cat_ID."'/> "
.get_cat_name($cat->cat_ID)." <span class='p2c-count'>(".$cat->category_count.")</span></li>
";
else:
echo "<li><input type='checkbox' disabled='disabled' name='p2c_bind[]' id='p2c".$cat->cat_ID."' value='".$cat->cat_ID."'/> <span class='p2c-used'>"
.get_cat_name($cat->cat_ID)." </span><span class='p2c-count'>(".$cat->category_count.")</span></li>
";
endif;
endforeach;
echo "</ul>";
echo "</div>";
?>
</div>
</fieldset>
<?php


}

// trigger page save/edit and make db relations
function page2cat_trigger_save($post_ID){
global $wpdb;

$values = $_POST['p2c_bind'];
$via = "DELETE FROM {$wpdb->page2cat} WHERE page_ID = '".$_POST['post_ID']."'";
$result = $wpdb->get_results($via);
if(count($values) > 0):
foreach($values as $key=>$cat){
	$sql = "INSERT INTO {$wpdb->page2cat} (rel_ID, page_ID, cat_ID) VALUES ('','".$_POST['post_ID']."','".$cat."')";
	$result = $wpdb->get_results($sql);
}
endif;
}

// trigger page deletion and free db relations
function page2cat_trigger_delete(){
	// yes, there's no trigger, actually....
}

// add real option page
function page2cat_options_page(){
global $wpdb, $styles;

$p2c_defaults = array("use_img_no"=>"","use_img_yes"=>"","css_styles"=>"", "use_empty_no"=>"", "use_empty_yes"=>"");

if(isset($_POST['page2cat_action'])):
$sane1 = strip_tags(htmlentities($_POST['p2c_use_img']));
update_option('p2c_use_img',$sane1);

$sane2 = strip_tags(htmlentities($_POST['p2c_styles']));
update_option('p2c_styles',$sane2);

$sane3 = strip_tags(htmlentities($_POST['p2c_use_empty']));
update_option('p2c_use_empty',$sane3);


echo('<div id="message" class="updated fade"><p><strong>Settings saved.</strong></p></div>');
endif;

$opt1 = get_option('p2c_use_img');
if($opt1 == 'no'){
	$p2c_defaults['use_img_no'] = ' selected="selected"';
}elseif($opt1 == 'yes'){
	$p2c_defaults['use_img_yes'] = ' selected="selected"';
}

$opt2 = get_option('p2c_styles');
if(trim($opt2) != "") $p2c_defaults['css_styles'] = $opt2; else $p2c_defaults['css_styles'] = $styles;

$opt3 = get_option('p2c_use_empty');
if($opt3 == 'no'){
	$p2c_defaults['use_empty_no'] = ' selected="selected"';
}elseif($opt3 == 'yes'){
	$p2c_defaults['use_empty_yes'] = ' selected="selected"';
}


	echo "<div class='wrap'>";
	echo "<form method='post' name='page2cat_options' accept-charset='utf-8'>";
	echo "<h2>Category Pages Options</h2>";

	echo "<p>Here you can tweak option for Category Pages, basically how to show them to users. CSS Styles provided are tested with default theme only, so you can either keep them as they are, or use the basic and enrich it at your pleasure.</p>";

	echo '
	<fieldset class="options" name="page2cat_img">

	<table class="editform optiontable">
	<legend>General options</legend>

	<tr>
	<td><p>Display empty categories?</p>
	</td>
	<td>
	<select name="p2c_use_empty">
	<option value="no"'.$p2c_defaults['use_empty_no'].' label=" No, thanks "> No, thanks </option>
	<option value="yes"'.$p2c_defaults['use_empty_yes'].' label=" Yes, please! "> Yes, please! </option>
	</select>
	</td>
	</tr>

	<tr>
	<td><p>Use attached image on pages as category image?
	<br/><small>(You can upload an image - 120 x 120px - to your page, and it will be shown)</small></p>
	</td>
	<td>
	<select name="p2c_use_img">
	<option value="no"'.$p2c_defaults['use_img_no'].' label=" No, thanks "> No, thanks </option>
	<option value="yes"'.$p2c_defaults['use_img_yes'].' label=" Yes, please! "> Yes, please! </option>
	<!-- option value="bg" disabled="disabled" label=" Yes, as background "> Yes, as background </option -->
	</select>
	</td>
	</tr>

	</table>
	</fieldset>
	';
/*
	echo '
	<fieldset class="options" name="page2cat_css">

	<table class="editform optiontable">
	<legend>CSS Styles</legend>
	<tr>
	<td><p>Use our default CSS styles for Category Page box?<br/>
	</p>
	</td>
	<td>
	<label for="p2c_styles">
	<select name="p2c_styles">
	<option value="no"'.$p2c_defaults['use_img_no'].' label=" No, thanks "> No, thanks </option>
	<option value="yes"'.$p2c_defaults['use_img_yes'].' label=" Yes, please! "> Yes, please! </option>
	</select>
	</td>
	</tr>
	</table>
*/	
	echo "<p><small>TIP: You can style your Category Page box or widget hacking <a href='".PLUGIN_PATH."p2c-style.css'>p2c-style.css</a>, in the plugin folder.</small></p>";
	
	echo '<p class="submit">
	<input type="hidden" name="page2cat_action" value="update" />
	<input type="submit" name="update" value="Update Options &raquo;" />
	</p>
	</fieldset>';
	
	echo '</form>';
	echo "</div>";
	echo "<div id='pixline-credits' class='wrap'>
	<strong><a href='http://pixline.net/wordpress-plugins/category-page-plugin/'>Category Page</a></strong> plugin v".PAGE2CAT_VERSION." &raquo; <small><a href='edit.php?page=category-pages'>Manage Category Pages</a> &rsaquo;
	<a href='http://pixline.net/wordpress-plugins/category-page-plugin/'>Check for updates and support</a></small>
	</div>";	
	
}

// template function for manual hacks and widgets :-)
function page2cat_output($cat, $style = 'inline', $useimg = 1){
global $wpdb;

	$useimg = get_option('p2c_use_img');
	$mypage = $wpdb->get_row("SELECT * FROM {$wpdb->page2cat} WHERE cat_ID = '".$cat."';",OBJECT);
#	print_r($mypage);
	$pageid = $mypage->page_ID;
	if($pageid != ""):
	
	switch($style):
	case 'widget':
	?>
	<div id="category-widget-header">
	<?php
	$pagina = "SELECT * FROM {$wpdb->posts} WHERE ID='".$pageid."' AND post_type = 'page';";
	$mine = $wpdb->get_results($pagina);
	if($mine[0]->post_title!=""){
			$query = "SELECT * FROM {$wpdb->posts} WHERE post_parent = {$pageid} 
				AND post_type = 'attachment' AND post_mime_type LIKE '%image%' LIMIT 1;";
				$attachment = $wpdb->get_results($query);
				if($attachment[0]->guid != ""  && $useimg == 'yes'){
					$fileurl = $attachment[0]->guid;
					list($width, $height, $type, $attr) = getimagesize($fileurl);					
					echo "<div id='category-widget-img'><a href=".get_permalink($post_ID)."><img 
					src='".$attachment[0]->guid."' ".$attr." 
					title='".$attachment[0]->post_title." [copertina]' ></a></div>";
				}
				if($useimg == 'yes') $divid = 'category-widget-data'; else $divid = 'category-widget-data-wide';
				?>
				<div id="<?php echo $divid; ?>">
					<!-- h2><?php echo $mine[0]->post_title; ?></h2 -->
					<p><?php echo wptexturize($mine[0]->post_content,1); ?></p>
				</div> 
		<div class="category-widget-cleaner"></div>
	</div>
	<?php
	}

	break;
	case 'inline':
	default:	
	?>
	<div id="category-page-header">
	<?php
	$pagina = "SELECT * FROM {$wpdb->posts} WHERE ID='".$pageid."' AND post_type = 'page';";
	$mine = $wpdb->get_results($pagina);
	if($mine[0]->post_title!=""){
			$query = "SELECT * FROM {$wpdb->posts} WHERE post_parent = {$pageid} 
				AND post_type = 'attachment' AND post_mime_type LIKE '%image%' LIMIT 1;";
				$attachment = $wpdb->get_results($query);
				if($attachment[0]->guid != "" && $useimg == 'yes'){
					$fileurl = $attachment[0]->guid;
					list($width, $height, $type, $attr) = getimagesize($fileurl);					
					echo "<div id='category-page-img'><a href=".get_permalink($post_ID)."><img 
					src='".$attachment[0]->guid."' ".$attr." 
					title='".$attachment[0]->post_title." [copertina]' ></a></div>";
				}
				if($useimg == 'yes') $divid = 'category-page-data'; else $divid = 'category-page-data-wide';
				?>
				<div id="<?php echo $divid; ?>">
					<h2><?php echo $mine[0]->post_title; ?></h2>
					<p><?php echo wptexturize($mine[0]->post_content,1); ?></p>
				</div> 
		<div class="category-page-cleaner"></div>
	</div>
	<?php
	}
	break;
	
	
	endswitch;
	
	?> 
	<?php
	else:
	echo '<h2 class="pagetitle">Archive for the &#8216;'.single_cat_title('',false).'&#8217; Category</h2>';	
	endif;
}

// frontend styles, if requested.
function page2cat_frontend_styles(){
echo "<link rel='stylesheet' type='text/css' media='screen, print' href='".PLUGIN_PATH."p2c-style.css'/>";
}

if(is_admin()):
#if(preg_match('|page-new.php|i', $_SERVER['REQUEST_URI']) || preg_match('|page.php|i', $_SERVER['REQUEST_URI'])){
	add_action('admin_menu', 'page2cat_init');
#}
	add_action('admin_menu', 'page2cat_config_page');
#	add_action('admin_menu', 'page2cat_debug');
	add_action('save_post','page2cat_trigger_save');
#	add_action('edit_post','page2cat_trigger_save');
#	add_action('delete_post','page2cat_trigger_delete');
endif;


add_action('wp_head','page2cat_frontend_styles');
?>
