<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */

/**
* Plugin Name: Instant Highlighter: virally MicroShare/MicroBookmark your posting across ALL Social Networks
* Plugin URI: http://roohit.com/site/buttons.php
* Description: Enables visitors to <strong>highlight</strong>, share, save, and <strong>promote your website in their social networks, blogs and friends</strong>. All highlights anyone makes on your page are automatically posted to  all of our <a href='http://roohit.com/site/urWidget.php'>MicroBloggers'</a> blogs and Social Networks pages; and to our own Home Page - instantly generating a gazillion links back to your posting. It's all Free, and no-one ever needs to "join" any site; nor download anything!
* Version: 1.6.6.16
* Author: The RoohIt Team
* Author URI: http://roohit.com
**/

/* 
* +--------------------------------------------------------------------------+
* | Copyright (c) 2006 RoohIt                   (email : support@roohit.com) |
* +--------------------------------------------------------------------------+
* | This program is free software; you can redistribute it and/or modify     |
* | it under the terms of the GNU General Public License as published by     |
* | the Free Software Foundation; either version 2 of the License, or        |
* | (at your option) any later version.                                      |
* |                                                                          |
* | This program is distributed in the hope that it will be useful,          |
* | but WITHOUT ANY WARRANTY; without even the implied warranty of           |
* | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            |
* | GNU General Public License for more details.                             |
* |                                                                          |
* | You should have received a copy of the GNU General Public License        |
* | along with this program; if not, write to the Free Software              |
* | Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA |
* +--------------------------------------------------------------------------+
*/

if (!defined('roohit_INIT')) 
	define('roohit_INIT', 1);
else 
	return;

$roohitpluginpath = WP_CONTENT_URL.'/plugins/'.plugin_basename(dirname(__FILE__)).'/';

$roohit_settings = array(	array('customization', '')
							, array('hoverBox', '1')
							, array('language', 'en')
							, array('style', '1')
						);

$roohit_languages = array('zh'=>'Chinese', 'da'=>'Danish', 'nl'=>'Dutch', 'en'=>'English', 'fi'=>'Finnish', 'fr'=>'French', 'de'=>'German', 'he'=>'Hebrew', 'it'=>'Italian', 'ja'=>'Japanese', 'ko'=>'Korean', 'no'=>'Norwegian', 'pl'=>'Polish', 'pt'=>'Portugese', 'ru'=>'Russian', 'es'=>'Spanish', 'sv'=>'Swedish');

$roohit_styles = array(
                      '1'  => array('img'=>'http://roohit.com/images/btns/hlBtnNEW.png'),
                      '2' => array('img'=>'http://roohit.com/images/btns/aSS.png'),
                      '3' => array('img'=>'http://roohit.com/images/btns/aSH.png'),
                      '4' => array('img'=>'http://roohit.com/images/btns/aSvH.png'),
                      '5' => array('img'=>'http://roohit.com/images/btns/aMB.png'),
                      '6' => array('img'=>'http://roohit.com/images/btns/aMS.png'),
                      '7' => array('img'=>'http://roohit.com/images/btns/aAB.png'),
                      '8' => array('img'=>'http://roohit.com/images/btns/aCSS.png'),

                      '9'  => array('img'=>'http://roohit.com/images/btns/2RH-3.png'),
                      '10'  => array('img'=>'http://roohit.com/images/btns/2RH-2.png'),
                      '11'  => array('img'=>'http://roohit.com/images/btns/2RH.png'),

                      '12'  => array('img'=>'http://roohit.com/images/btns/btn_MB.png'),
                      '13' => array('img'=>'http://roohit.com/images/btns/btn_CSC.png'),

                      '14'  => array('img'=>'http://roohit.com/images/btns/btn_HP.png'),
                      '15' => array('img'=>'http://roohit.com/images/btns/btn_SH.png'),
                      '16' => array('img'=>'http://roohit.com/images/btns/btn_BAT.png'),

                      '17'  => array('img'=>'http://roohit.com/images/btns/hlThisPage.png'),
                      '18' => array('img'=>'http://roohit.com/images/instHler.gif'),

                      '19'  => array('img'=>'http://roohit.com/site/images/button1.gif'),
                      '20'  => array('img'=>'http://roohit.com/site/images/hilight_button.gif'),

                      '21' => array('img'=>'http://roohit.com/images/pen2.gif'),
                      /* Add your own style here, like this:
                        , 'custom' => array('img'=>'http://example.com/button.gif') */
                    );


function roohit_init()
{
    global $roohit_settings;

    add_filter('the_content', 'roohit_tag');
    add_filter('admin_menu', 'roohit_admin_menu');

    add_option('roohit_hoverbox');
    add_option('roohit_style');
    add_option('roohit_language', 'en');

	add_action("plugins_loaded", "init_highlighter");

    if (!isset($style)) $style = get_option('roohit_style');
    if (strlen($style) == 0) $style = '1';
    $roohit_settings['style'] = $style;

    $language = get_option('roohit_language');
    $roohit_settings['language'] = $language;

    if (!isset($hoverBox)) $hoverBox = get_option('roohit_hoverbox');
    if (strlen($hoverBox) == 0) $hoverBox = 1;
    $roohit_settings['hoverBox'] = $hoverBox;

    $roohit_settings['customization'] = '';
    for ($i = 0; $i < count($advopts); $i++)
    {
        $opt = $advopts[$i];
        $val = get_option("roohit_$opt");
        if (isset($val) && strlen($val)) $roohit_settings['customization'] .= "var roohit_$opt = '$val';";
    }

}

function highlighter_widget() {
    if (!isset($style)) $style = get_option('roohit_style');
	echo roohit_get_img($style) ;

}

function init_highlighter(){
	register_sidebar_widget("Instant Highlighter", "highlighter_widget");
}


function roohit_tag($content)
{
    global $roohit_settings;

    $content .= "\n<!-- Roohit Button BEGIN -->\n";
        //$link  = get_permalink(); href="http://roohit.com/$link
        $content .= <<<EOF
<div class="roohit_container"><a class="roohitBtn" href="http://go.roohit.com" title="Use a Highlighter on this page">
EOF;
        $content .= roohit_get_button_img() . '</a>' ;
		if ($roohit_settings['hoverBox']== 0)
			$content .= '<script type="text/javascript">var showHover=false;</script>' ;
		else 
			$content .= '<script type="text/javascript">var showHover=true;</script>' ;
		// $content .= 'hoverBox value=' . '.' .$roohit_settings['hoverBox'] ;		//debugging statement
		$content .= '<script type="text/javascript" src="http://roohit.com/site/btn.js"></script>' ;
	$content .= "</div>\n<!-- Roohit Button END -->";
    return $content;
}

function roohit_get_button_img()
{
    global $roohit_settings;
    global $roohit_styles;

    $btnStyle = $roohit_settings['style'];

    //if (!isset($roohit_styles[$btnStyle])) $btnStyle = 'style1';		//original code corrected to below on 08/04/09
    if (!isset($roohit_styles[$btnStyle])) $btnStyle = '1';
    $btnRecord = $roohit_styles[$btnStyle];
    $btnUrl =  $btnRecord['img'];
         
    return <<<EOF
<img src="$btnUrl" border="0" alt="Use a Highlighter on this page" style="border:none;"/>
EOF;
}

function roohit_get_img($id)
{
    global $roohit_settings;
    global $roohit_styles;

    $btnStyle = $id;

    $btnRecord = $roohit_styles[$btnStyle];
    $btnUrl =  $btnRecord['img'];
         
    return <<<EOF
<img src="$btnUrl" border="0" alt="Use a Highlighter on this page" style="border:none;"/>
EOF;
}

function roohit_admin_menu()
{
    add_options_page('RoohIt Options', 'Roohit', 8, __FILE__, 'roohit_plugin_options_php4');
}

////////////////////// Begin /////////////
// Add settings link on plugin page
function roohit_settings_link($links) {
  $settings_link = '<A href="options-general.php?page=instant-web-highlighter/roohit.php">Settings</A>';
  array_unshift($links, $settings_link);
  return $links;
}

$plugin = plugin_basename(__FILE__);
add_filter("plugin_action_links_$plugin", 'roohit_settings_link' );
///////////// End //////////////

function roohit_plugin_options_php4() {
    global $roohit_styles;
    global $roohit_languages;
    global $roohit_settings;

?>
    <div class="wrap">
    <h2>RoohIt: Instant Web Highlighter</h2>

    <div align="center" id="message" class="updated fade"><p><a href="mailto:support@roohit.com?subject=WordPress plugin Feedback">Tell us</a> what you think of this plugin?</p></div>

    <form method="post" action="options.php">
    <?php wp_nonce_field('update-options'); ?>

    <h3>Highlighter Button Options</h3>
    <table class="form-table">
        <tr valign="top">
            <th scope="row"><?php _e("Button Appearance:", 'roohit_trans_domain' ); ?></th>
            <td>
                <table><tbody>
                    <?php                
						$currHoverSetting = get_option('roohit_hoverbox');
                        $curstyle = get_option('roohit_style');
							//echo "<div style:'backgound-color:#ff0000;'>$curstyle</div>" ;
							//echo "<div style:'backgound-color:#ff0000;'>[$currHoverSetting]</div>" ;

                        $i=1;
                        //foreach ($roohit_styles as $style => $info)
                        $numStyles = sizeof($roohit_styles) ;
                        for ($i=1; $i <= $numStyles; )
                        {
                            echo "<tr>";
                            for ($j=0; $j < 4; $j++)
                            {
                                $style = $i ;
                                if ($style > $numStyles)
                                    break ;
                                echo "<td". ($style == $curstyle ? " bgcolor='#ccffcc'":""). "> <input type=\"radio\" name=\"roohit_style\" value=\"$style\" id=\"roohit_style_$i\"". ($style == $curstyle ? "  checked=\"checked\"":"").  "/> ".roohit_get_img($style)."</td>" ;
                                $i++ ;
                            }
                            echo "</tr>" ;
                        }
                    ?>
                </tbody></table>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row"><?php _e("Hover Box:", 'roohit_trans_domain' ); ?></th>
            <td>
            	<input type="radio" name="roohit_hoverbox" value='1' id="roohit_hoverbox_1" <?php if ($currHoverSetting == '1') echo 'checked=\"checked\"' ?> /> <?php _e("Show (recommended)", 'roohit_trans_domain' ); ?>
            	<input type="radio" name="roohit_hoverbox" value='0' id="roohit_hoverbox_0" <?php if ($currHoverSetting == '0') echo 'checked=\"checked\"' ?> /> <?php _e("Hide", 'roohit_trans_domain' ); ?>
            </td>
        </tr>
    </table>

    <input type="hidden" name="action" value="update" />
    <input type="hidden" name="page_options" value="roohit_style,roohit_hoverbox,roohit_language,roohit_options"/>

    <p class="submit">
    <input type="submit" name="Submit" value="<?php _e('Save Changes') ?>" />
    </p>

    </form>

    <h2>Like this plugin?</h2>
    <p>Why not do any of the following:</p>
    <ul>
        <li>&nbsp;&nbsp;&nbsp;&nbsp;&bull; Write a blog posting <a href="http://roohit.com/site/blogThis.php">about it</a>, and link to it so other folks can find out about it.</li>
        <li>&nbsp;&nbsp;&nbsp;&nbsp;&bull; <a href="http://wordpress.org/extend/plugins/instant-web-highlighter/">Give it a good rating</a> on WordPress.org, so others will find it easily!</li>
        <li>&nbsp;&nbsp;&nbsp;&nbsp;&bull; <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=7137089">Donate a token of your appreciation</a>.</li>
    </ul>

    <h2>Need support?</h2>
    <p>If you have any problems or good ideas, please talk about them in the <a href="http://wordpress.org/tags/instant-web-highlighter">Support forums</a>.</p>
    
    <h2>About</h2>
    <p><em>Rooh</em> means <em>soul</em>. When you Rooh It you get to the soul of the page, as you individually determine it. </p>
    <p>The no-signup, no-download, highlighter was conceived and created by Rohit Chandra and has been maintained by <a href="http://roohit.com/">RoohIt</a> since the very beginning.</p>

    </div>

<?php
}
roohit_init();
?>
