<?php
/*
Plugin Name: WP Greet Box
Plugin URI: http://omninoggin.com/projects/wordpress-plugins/wp-greet-box-wordpress-plugin/
Description: Show a different message to your visitor depending on which site they are coming from.  For example, you can ask Digg visitors to Digg your post, Google visitors to subscribe to your RSS feed, and more!  Best of all, this plugin is compatible with various WordPress cache plugins.
Version: 5.0.1
Author: Thaya Kareeson
Author URI: http://omninoggin.com/
*/

/*
Copyright 2008-2009 Thaya Kareeson (email : thaya.kareeson@gmail.com)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

if (!class_exists('WPGreetBox')) {

  class WPGreetBox {

    var $homepage = 'http://omninoggin.com/wordpress-plugins/wp-greet-box-wordpress-plugin/';
    var $name = 'wp_greet_box';
    var $version = '5.0.1';
    var $visit_delta = null;

    function WPGreetBox() {
      // Version check
      global $wp_version;

      //global $wp_version, $pagenow;

      // pages where plugin needs translation
      //$local_pages=array('options-general.php');

      //if (in_array($pagenow, $local_pages) && $_GET['page'] == $this->name)
      //  $this->handle_load_domain();

      $this->handle_load_domain();

      if (version_compare($wp_version,"2.6","<"))
        exit(__('WP Greet Box requires WordPress 2.6 or newer. <a href="http://codex.wordpress.org/Upgrading_WordPress">Please update!</a>', $this->name));
    }

    // Localization support
    function handle_load_domain()  
    {
      // get current language
      $locale = get_locale();
 
      // locate translation file
      $mofile = $this->get_plugin_dir().'lang/'.$this->name.'-'.$locale.'.mo';
 
      // load translation
      load_textdomain($this->plugin_domain, $mofile);
    }
  
    function get_default_options() {
      return array(
        'version'               => $this->version,
        'before_greet'          => '<div class="greet_block">',
        'after_greet'           => '</div>',
        'before_icon'           => '<div class="greet_image">',
        'after_icon'            => '</div>',
        'before_text'           => '<div class="greet_text">',
        'after_text'            => '<div style="clear:both"></div></div>',
        'exclude_referrer'      => 'friendfeed.com'.chr(10).'google.com/reader',
        'can_close'             => 1,
        'regex_rules'           => 0,
        'show_post'             => 1,
        'show_page'             => 0,
        'allow_self_refer'      => 1,
        'position'              => 'before',
        'show_link'             => 1,
        'show_advanced_options' => 0,
        'show_related'          => 1,
        'show_related_excerpt'  => 1,
        'open_related'          => 0,
        'enable_css'            => 1,
        'enable_js'             => 1,
        'cache_compatible'      => 1,
        'related_limit'         => 5,
        'related_excerpt_len'   => 20,
        'related_position'      => 'after',
        'rss_link'              => get_bloginfo('rss_url'),
        'email_link'            => '',
        'message_default'       => array(
          'disable'         => 0,
          'icon'            => $this->get_plugin_url().'images/rss_icon.png',
          'icon_link'       => '[[rss-link]]',
          'show_till_close' => 1,
          'timeout'         => 14400,
          'text'            => 'Hello there! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
        ),
        'message_noscript'      => array(
          'disable'         => 0,
          'icon'            => $this->get_plugin_url().'images/rss_icon.png',
          'icon_link'       => '[[rss-link]]',
          'text'            => 'Hello there! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
        ),
        'messages'              => array(
          array(
            'referrer'        => 'del.icio.us, delicious.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/delicious_icon.png',
            'icon_link'       => 'http://delicious.com/save?jump=yes&url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello fellow <strong>Delicious</strong> user! Feel free to <a href="http://delicious.com/save?jump=yes&url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it!'
          ),
          array(
            'referrer'        => 'digg.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/digg_icon.png',
            'icon_link'       => 'http://digg.com/submit?url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello fellow <strong>Digger</strong>! If you like this article, please help me out by giving me some <a href="http://digg.com/submit?url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>digg love</strong></a>!'
          ),
          array(
            'referrer'        => 'google.*',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/google_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 1,
            'timeout'         => 1440,
            'text'            => 'Welcome <strong>Googler</strong>! If you find this page useful, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
          ),
          array(
            'referrer'        => 'stumbleupon.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/stumbleupon_icon.png',
            'icon_link'       => 'http://www.stumbleupon.com/submit?url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello fellow <strong>Stumbler</strong>! Don\'t forget to <a href="http://www.stumbleupon.com/submit?url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>give me a thumbs up</strong></a> and <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> if you like this page!'
          ),
          array(
            'referrer'        => 'technorati.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/technorati_icon.png',
            'icon_link'       => 'http://technorati.com/faves?add=[[escaped-permalink]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello fellow <strong>Technorati</strong> user! Don\'t forget to <a href="http://technorati.com/faves?add=[[escaped-permalink]]" rel="nofollow"><strong>favorite this blog</strong></a> if you like it!'
          ),
          array(
            'referrer'        => 'twitter.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/twitter_icon.png',
            'icon_link'       => 'http://twitthis.com/twit?url=[[escaped-permalink]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello fellow <strong>Twitter</strong> user! Don\'t forget to <a href="http://twitthis.com/twit?url=[[escaped-permalink]]" rel="nofollow"><strong>Twit this post</strong></a> if you like it, or <a href="http://twitter.com/" rel="nofollow"><strong>follow me</strong></a> on Twitter if you find me interesting.'
          ),
          array(
            'referrer'        => 'search.yahoo.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/yahoo_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 1,
            'timeout'         => 1440,
            'text'            => 'Welcome fellow <strong>Yahooligan</strong>! If you find this page useful, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
          ),
          array(
            'referrer'        => 'search.live.com, search.msn.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/live_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 1,
            'timeout'         => 1440,
            'text'            => 'Hello there <strong>Live</strong>-ly searcher! If you find this page useful, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
          ),
          array(
            'referrer'        => 'blinklist.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/blinklist_icon.png',
            'icon_link'       => 'http://blinklist.com/blink?u=[[escaped-permalink]]&t=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there fellow <strong>Blinklist</strong> user! Feel free to <strong><a href="http://blinklist.com/blink?u=[[escaped-permalink]]&t=[[title]]" rel="nofollow">bookmark this page</a></strong> for future reference if you like it!'
          ),
          array(
            'referrer'        => 'blogmarks.net',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/blogmarks_icon.png',
            'icon_link'       => 'http://blogmarks.net/my/new.php?mini=1&url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <stong>Blogmarks</strong> user! Feel free to <a href="http://blogmarks.net/my/new.php?mini=1&url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it!'
          ),
          array(
            'referrer'        => 'diigo.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/diigo_icon.png',
            'icon_link'       => 'http://secure.diigo.com/post?url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Diigo</strong> user! Feel free to <a href="http://secure.diigo.com/post?url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it!'
          ),
          array(
            'referrer'        => 'facebook.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/facebook_icon.png',
            'icon_link'       => 'http://www.facebook.com/share.php?u=[[escaped-permalink]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Facebook</strong> friend! If you like this article, please help spread the word by <a href="http://www.facebook.com/share.php?u=[[escaped-permalink]]" rel="nofollow"><strong>sharing this post</strong></a> with your friends.'
          ),
          array(
            'referrer'        => 'furl.net',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/furl_icon.png',
            'icon_link'       => 'http://www.furl.net/items/new?r=&v=1&c=&u=[[escaped-permalink]]&t=[[escaped-title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Furl</strong> user! Please feel free to <a href="http://www.furl.net/items/new?r=&v=1&c=&u=[[escaped-permalink]]&t=[[escaped-title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it.'
          ),
          array(
            'referrer'        => 'ma.gnolia.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/magnolia_icon.png',
            'icon_link'       => 'http://ma.gnolia.com/bookmarklet/add?url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Magnolia</strong> user! Please feel free to <a href="http://ma.gnolia.com/bookmarklet/add?url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it.'
          ),
          array(
            'referrer'        => 'mister-wong.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/mrwong_icon.png',
            'icon_link'       => 'http://www.mister-wong.com/index.php?action=addurl&bm_url=[[escaped-permalink]]&bm_description=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Mister Wong</strong> user! Please feel free to <a href="http://www.mister-wong.com/index.php?action=addurl&bm_url=[[escaped-permalink]]&bm_description=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it.'
          ),
          array(
            'referrer'        => 'myspace.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/myspace_icon.png',
            'icon_link'       => 'http://www.myspace.com/Modules/PostTo/Pages/?l=3&u=[[escaped-permalink]]&t=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there friend of <strong>MySpace</strong>! If you like this article, please help spread the word by <a href="http://www.myspace.com/Modules/PostTo/Pages/?l=3&u=[[escaped-permalink]]&t=[[title]]" rel="nofollow"><strong>sharing this post</strong></a> with your friends.'
          ),
          array(
            'referrer'        => 'newsvine.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/newsvine_icon.png',
            'icon_link'       => 'http://www.newsvine.com/_tools/seed?popoff=0&u=[[escaped-permalink]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Newsvine</strong> user! If you find this article useful, please remember to <a href="http://www.newsvine.com/_tools/seed?popoff=0&u=[[escaped-permalink]]" rel="nofollow"><strong>vote for this article</strong></a> on Newsvine.'
          ),
          array(
            'referrer'        => 'reddit.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/reddit_icon.png',
            'icon_link'       => 'http://www.reddit.com/submit?url=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there follow <strong>Reddit</strong> user! If you like this article, please remember to <a href="http://www.reddit.com/submit?url=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>vote for this article</strong></a> on Reddit.'
          ),
          array(
            'referrer'        => 'simpy.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/simpy_icon.png',
            'icon_link'       => 'http://www.simpy.com/simpy/LinkAdd.do?href=[[escaped-permalink]]&title=[[title]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Simpy</strong> user! Please feel free to <a href="http://www.simpy.com/simpy/LinkAdd.do?href=[[escaped-permalink]]&title=[[title]]" rel="nofollow"><strong>bookmark this page</strong></a> for future reference if you like it.'
          ),
          array(
            'referrer'        => 'example.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/favorite_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to the RSS feed</strong></a> for updates on this topic.'
          ),
          array(
            'referrer'        => 'netvibes.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/netvibes_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Netvibes</strong> user! If you find this article useful, then you should consider <a href="[[rss-link]]" rel="nofollow"><strong>subscribing to the RSS feed</strong></a> in your feed reader.'
          ),
          array(
            'referrer'        => 'youtube.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/youtube_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>YouTuber</strong>! If you like my videos, feel free to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a> for more of my video updates.'
          ),
          array(
            'referrer'        => 'flickr.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/flickr_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Flickr</strong> user! If you like my photo, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a> to receive regular photo updates.'
          ),
          array(
            'referrer'        => 'wordpress.org',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/wordpress_icon2.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>WordPress</strong> lover! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a> to receive regular WordPress updates.'
          ),
          array(
            'referrer'        => 'tumblr.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/tumblr_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>Tumblr</strong> user! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a> to receive regular updates.'
          ),
          array(
            'referrer'        => 'friendfeed.com',
            'disable'         => 1,
            'icon'            => $this->get_plugin_url().'images/friendfeed_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>FriendFeed</strong> user! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a>. Also feel free to <a href="http://friendfeed.com" rel="nofollow"><strong>follow me</strong></a> on FriendFeed.'
          ),
          array(
            'referrer'        => 'plurk.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/plurk_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there fellow <strong>Plurker</strong>! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a>. Also feel free to <a href="http://plurk.com" rel="nofollow"><strong>follow me</strong></a> on Plurk.'
          ),
          array(
            'referrer'        => 'linkedin.com',
            'disable'         => 0,
            'icon'            => $this->get_plugin_url().'images/linkedin_icon.png',
            'icon_link'       => '[[rss-link]]',
            'show_till_close' => 0,
            'timeout'         => 0,
            'text'            => 'Hello there <strong>LinkedIn</strong> user! If you are new here, you might want to <a href="[[rss-link]]" rel="nofollow"><strong>subscribe to my RSS feed</strong></a> for more updates on this topic or read more about me on the <a href="/about" rel="nofollow"><strong>about page</strong></a>.'
          )
        )
      );
    }
  
    function activate() {
      global $wpdb;
  
      $wpdb->hide_errors();
      $wpdb->query('ALTER TABLE '.$wpdb->posts.' ENGINE = MYISAM;');
      $wpdb->query('ALTER TABLE '.$wpdb->posts.' ADD FULLTEXT '.$this->name.'_post_related (post_title, post_content);');
      $wpdb->show_errors();
  
      $this->upgrade_options();
    }
  
    function need_upgrade() {
      $wpgb_options = get_option($this->name);
      if ( array_key_exists('version', $wpgb_options ) ) {
        $old_version_arr = split('\.', $wpgb_options['version']);
        $new_version_arr = split('\.', $this->version);
        for($i = 0; $i < 3; $i++)
        {
          if ( (int)$new_version_arr[$i] > (int)$old_version_arr[$i] ) {
            return true;
          }
          elseif ( (int)$new_version_arr[$i] < (int)$old_version_arr[$i] ) {
            return false;
          }
        }
        return false;
      }
      return true;
    }
  
    function check_version() {
      // check WP version
      global $wp_version;
      if (!empty($wp_version) && is_admin() && version_compare($wp_version,'2.6','<')) {
        _e('<div class="updated fade"><p>You are using WordPress version ', $this->name);
        echo $wp_version;
        _e('.  WP Greet Box recommends that you use WordPress 2.6 or newer.  <a href="http://codex.wordpress.org/Upgrading_WordPress">Please update!</a></p></div>', $this->name);
      }

      // check WP Greet Box version
      if ( $this->need_upgrade() ) {
        $this->upgrade_options();
        _e('<div class="updated fade"><p>WP Greet Box options have been upgraded.</p></div>', $this->name);
      }
    }

    function get_plugin_dir() {
      return trailingslashit(WP_CONTENT_DIR.'/plugins/'.plugin_basename(dirname(__FILE__)));
    }

    function get_plugin_url() {
      return trailingslashit(WP_CONTENT_URL.'/plugins/'.plugin_basename(dirname(__FILE__)));
    }

    function load_admin_scripts() {
      echo(
        '<link rel="stylesheet" href="'.$this->get_plugin_url().'css/wp-greet-box-admin.css" type="text/css"/>'.
        '<script type="text/javascript" src="'.$this->get_plugin_url().'js/jquery.livequery.js"></script>'
      );
  
      // Generate admin_onload.js for security reasons.
  ?>
  <script type='text/javascript'>
  <!--
  jQuery(document).ready(function($){
    // action link clicks
    $("a.wpgb_action").livequery("click", function(e){
      e.preventDefault();
      a = this;
      if ($(a).is(".confirm") && !confirm($(a).attr("prompt")))
      {
        return false;
      }
  
      var id     = $(a).attr("entry");
      var action = $(a).attr("action");
  
      if(action == "cancel_add"){
        $(a).html("Add new greeting message").attr("action", "get_add_form");
        $("#wpgb_add_" + id).slideUp("fast");
        $("#wpgb_add_bar_" + id).fadeTo("fast", 1);
      }
      else if(action == "cancel_edit"){
        $(a).html("Edit").attr("action", "get_edit_form");
        $("#wpgb_message_view_" + id).slideUp("fast");
        $("#wpgb_message_row_" + id).fadeTo("fast", 1);
      }
      else{
        $("#wpgb_loading_" + id).fadeIn("fast", function(){
          $("#wpgb_message_view_" + id).hide();
          $.ajax({
            type  : "POST",
            url   : "admin-ajax.php",
            data  : { action : "wpgb", _ajax_nonce: '<?php echo $this->get_nonce(); ?>', wpgb_action : action, wpgb_id : id },
            success  : function(resp){
              switch(action){
                case "activate":
                  $(a).html("Deactivate").attr("action", "deactivate");
                  $("#wpgb_message_" + id).removeClass("wpgb_message_inactive").addClass("wpgb_message_active");
                  $("#wpgb_message_" + id).appendTo($("#wpgb_messages_active"));
                  $("#wpgb_message_row_" + id).fadeTo("slow", 1);
                  $("a.wpgb_action[action='cancel_edit'][entry='" + id + "']").html("Edit").attr("action", "get_edit_form");
                  break;
                case "deactivate":
                  $(a).html("Activate").attr("action", "activate");
                  $("#wpgb_message_" + id).removeClass("wpgb_message_active").addClass("wpgb_message_inactive");
                  $("#wpgb_message_" + id).appendTo($("#wpgb_messages_inactive"));
                  $("#wpgb_message_row_" + id).fadeTo("slow", 1);
                  $("a.wpgb_action[action='cancel_edit'][entry='" + id + "']").html("Edit").attr("action", "get_edit_form");
                  break;
                case "delete":
                  $("#wpgb_message_" + id).fadeOut("slow").remove();
                  break;
                case "get_add_form":
                  $(a).html("Cancel").attr("action", "cancel_add");
                  $("#wpgb_add_" + id).slideUp("fast").remove();
                  $("#wpgb_add_bar_" + id).fadeTo("slow", 0.5).after(resp);
                  // bind submit button
                  $("#wpgb_add_form_" + id).submit(function(e){
                    e.preventDefault();
                    f = this;
                    $.ajax({
                      type    : "POST",
                      url     : "admin-ajax.php",
                      data    : $(f).serialize() + "&action=wpgb&_ajax_nonce=<?php echo $this->get_nonce(); ?>",
                      success : function(resp){
                        $("#wpgb_add_" + id).slideUp("fast");
                        $("#wpgb_add_bar_" + id).fadeTo("fast", 1).after(resp);
                        $(a).html("Add new greeting message").attr("action", "get_add_form");
                      },
                      error   : function(resp){
                        alert("Error:" + resp);
                      }
                    });
                  });
                  // bind form cancel button
                  $("#wpgb_add_form_" + id).find("input[class='wpgb_cancel']").click(function(e){
                    e.preventDefault();
                    $("#wpgb_add_" + id).slideUp("fast");
                    $("#wpgb_add_bar_" + id).fadeTo("fast", 1);
                    $(a).html("Add new greeting message").attr("action", "get_add_form");
                  });
                  break;
                case "get_edit_form":
                  $(a).html("Cancel").attr("action", "cancel_edit");
                  $("#wpgb_message_row_" + id).fadeTo("slow", 0.5);
                  $("#wpgb_message_view_" + id).html(resp).slideDown("fast");
                  // bind submit button
                  $("#wpgb_custom_message_form_" + id).submit(function(e){
                    e.preventDefault();
                    f = this;
                    $.ajax({
                      type    : "POST",
                      url     : "admin-ajax.php",
                      data    : $(f).serialize() + "&action=wpgb&_ajax_nonce=<?php echo $this->get_nonce(); ?>",
                      success : function(resp){
                        $("#wpgb_message_view_" + id).slideUp("fast");
                        $("#wpgb_message_row_" + id).html(resp).fadeTo("fast", 1);
                      },
                      error   : function(resp){
                        alert("Error:" + resp);
                      }
                    });
                  });
                  // bind form cancel button
                  $("#wpgb_custom_message_form_" + id).find("input[class='wpgb_cancel']").click(function(e){
                    e.preventDefault();
                    $("#wpgb_message_view_" + id).slideUp("fast");
                    $("#wpgb_message_row_" + id).fadeTo("fast", 1);
                    $(a).html("Edit").attr("action", "get_edit_form");
                  });
                  break;
                default:
                  break;
              }
              $("#wpgb_loading_" + id).fadeOut("fast");
            },
            error : function(resp){
              alert("Error:" + resp);
            }
          });
        });
      } // end else
    });
  });
  -->
  </script>
  <?php
    }
  
    function embed_scripts() {
      global $wpgb_shown;
      $wpgb_options = get_option($this->name);
      if ( $wpgb_shown ) {
        if ( $wpgb_options['cache_compatible'] && $wpgb_options['enable_js'] ) {
          echo($this->get_scripts_html());
        }
        else {
          echo($this->get_jquery_html());
        }
      }
    }
  
    function get_scripts_html() {
      return(
        '<script type="text/javascript" src="'.$this->get_plugin_url().'js/functions.js"></script>'.
        '<script type="text/javascript" src="'.$this->get_plugin_url().'js/onload.js"></script>'
      );
    }
  
    function get_jquery_html() {
      return(
        '<script type="text/javascript">'.
        'function wpgb_set_cookie(c_name,value,expiredays) {'.
          'var exdate = new Date();'.
          'exdate.setDate(exdate.getDate()+expiredays);'.
          'document.cookie=c_name+ "=" +escape(value)+";path="+"/"+'.
          '((expiredays==null) ? "" : ";expires="+exdate.toGMTString());'.
        '}'.
        'jQuery(document).ready(function($){'.
           'var ref = "default";'.
           'if(document.referrer){'.
             'ref = document.referrer;'.
             'm = ref.match(/^(http:\/\/[^\/]+)/i);'.
             'if(m){'.
               'ref = m[1].replace(".", "_");'.
             '}'.
           '}'.
           // bind close action
           '$("#greet_block_close").click(function(){'.
             'wpgb_set_cookie("wpgb_closed-"+ref,new Date(),365);'.
             '$("#greet_block").fadeOut("def");'.
           '});'.
           // bind search action (if any)
           '$("#greet_search_link").click(function(){'.
             'action = $(this).attr("action");'.
             'if(action == "show"){'.
               '$("#greet_search_results").slideDown();'.
               '$(this).attr("action","hide");'.
               '$("#greet_search_link_text_show").hide();'.
               '$("#greet_search_link_text_hide").show();'.
               '$("#greet_search_text_show").hide();'.
               '$("#greet_search_text_hide").show();'.
             '}'.
             'else if(action == "hide"){'.
               '$("#greet_search_results").slideUp("fast");'.
               '$(this).attr("action","show");'.
               '$("#greet_search_link_text_show").show();'.
               '$("#greet_search_link_text_hide").hide();'.
               '$("#greet_search_text_show").show();'.
               '$("#greet_search_text_hide").hide();'.
             '}'.
           '});'.
        '});'.
        '</script>'
      );
    }
  
    function embed_styles() {
      echo('<link rel="stylesheet" href="'.$this->get_plugin_url().'css/wp-greet-box.css" type="text/css" />');
    }
  
    function queue_styles() {
      $style = $this->get_plugin_url().'css/wp-greet-box.css'; 
      wp_register_style($this->name.'_style', $style); 
      wp_enqueue_style($this->name.'_style');
    }
  
    function queue_jquery() {
      wp_enqueue_script('jquery');
    }
  
    function display_default_row($type, $wrap=true) {
      $wpgb_options = get_option($this->name);
      if($type == "default"){
        $m = $wpgb_options['message_default'];
        $type = 'default';
      }
      else{
        $m = $wpgb_options['message_noscript'];
        $type = 'noscript';
      }
      if($m['disable']){
        $a_action = 'activate';
        $a_class = 'inactive';
        $a_text= __('Activate', $this->name);
      }
      else{
        $a_action = 'deactivate';
        $a_class = 'active';
        $a_text = __('Deactivate', $this->name);
      }
      if($wrap){
        echo(
        '<div id="wpgb_message_'.$type.'" class="wpgb_message_'.$a_class.'">'.
          '<div id="wpgb_message_row_'.$type.'" class="wpgb_message_row">'
        );
      }
      echo(
            '<div class="wpgb_column_referrer"><strong>'.strtoupper($type).'&nbsp;</strong></div>'.
            '<div class="wpgb_column_icon"><img src="'.$m['icon'].'" alt="WP Greet Box icon"/>&nbsp;</div>'.
            '<div class="wpgb_column_message">'.$m['text'].'&nbsp;</div>'.
            '<div class="wpgb_column_action">'.
              '<div id="wpgb_loading_'.$type.'" class="wpgb_loading"><img src="'.$this->get_plugin_url().'images/loading.gif" alt="loading..."/></div>'.
              '<a href="#" class="wpgb_action" entry="'.$type.'" action="get_edit_form">'.__('Edit', $this->name).'</a> | '.
              '<a href="#" class="wpgb_action" entry="'.$type.'" action="'.$a_action.'">'.$a_text.'</a>'.
            '</div>'.
            '<div class="clear"></div>'
      );
      if($wrap){
        echo(
          '</div>'.
          '<div id="wpgb_message_view_'.$type.'" class="wpgb_message_view" style="display:none"></div>'.
          '<div class="clear"></div>'.
        '</div>'
        );
      }
    }
  
    function display_message_row($id, $wrap=true) {
      $wpgb_options = get_option($this->name);
      if($wpgb_options['messages'][$id]['disable']){
        $a_action = 'activate';
        $a_class = 'inactive';
        $a_text= __('Activate', $this->name);
      }
      else{
        $a_action = 'deactivate';
        $a_class = 'active';
        $a_text = __('Deactivate', $this->name);
      }
      if($wrap){
        echo(
        '<div id="wpgb_message_'.$id.'" class="wpgb_message_'.$a_class.'">'.
          '<div id="wpgb_message_row_'.$id.'" class="wpgb_message_row">'
        );
      }
      echo(
            '<div class="wpgb_column_referrer">'.$wpgb_options['messages'][$id]['referrer'].'&nbsp;</div>'.
            '<div class="wpgb_column_icon"><img src="'.$wpgb_options['messages'][$id]['icon'].'" alt="WP Greet Box icon"/>&nbsp;</div>'.
            '<div class="wpgb_column_message">'.$wpgb_options['messages'][$id]['text'].'&nbsp;</div>'.
            '<div class="wpgb_column_action">'.
              '<div id="wpgb_loading_'.$id.'" class="wpgb_loading"><img src="'.$this->get_plugin_url().'images/loading.gif" alt="loading..."/></div>'.
              '<a href="#" class="wpgb_action" entry="'.$id.'" action="get_edit_form">'.__('Edit', $this->name).'</a> | '.
              '<a href="#" class="wpgb_action confirm" prompt="'.__('Are you sure you want to delete?', $this->name).'" entry="'.$id.'" action="delete">'.__('Delete', $this->name).'</a> | '.
              '<a href="#" class="wpgb_action" entry="'.$id.'" action="'.$a_action.'">'.$a_text.'</a>'.
            '</div>'.
            '<div class="clear"></div>'
      );
      if($wrap){
        echo(
          '</div>'.
          '<div id="wpgb_message_view_'.$id.'" class="wpgb_message_view" style="display:none"></div>'.
          '<div class="clear"></div>'.
        '</div>'
        );
      }
    }
  
    function admin_ajax_update_custom($id, $wpgb_message) {
      // convert "on" to 1 and "off" to 0 for checkbox fields
      // and set defaults for fields that are left blank
      if ( $wpgb_message['disable'] == 'off' )
        $wpgb_message['disable'] = 0;
      elseif ( $wpgb_message['disable'] == 'on' )
        $wpgb_message['disable'] = 1;
      if ( !$wpgb_message['timeout'] )
        $wpgb_message['timeout'] = 0;
  
      // Update options
      $wpgb_options = get_option($this->name);
      $wpgb_options['messages'][$id] = $wpgb_message;
      update_option($this->name, $wpgb_options );
    }
  
    function admin_ajax_update_default($type, $wpgb_message) {
      // convert "on" to 1 and "off" to 0 for checkbox fields
      // and set defaults for fields that are left blank
      if ( $wpgb_message['disable'] == 'off' )
        $wpgb_message['disable'] = 0;
      elseif ( $wpgb_message['disable'] == 'on' )
        $wpgb_message['disable'] = 1;
      if ( !$wpgb_message['timeout'] )
        $wpgb_message['timeout'] = 0;
  
      // Update options
      $wpgb_options = get_option($this->name);
      $wpgb_options['message_'.$type] = $wpgb_message;
      update_option($this->name, $wpgb_options );
    }
  
    function update_options_exclusion() {
      $wpgb_options_exclusion = stripslashes_deep($_POST['wpgb_options_exclusion']);
  
      // convert "on" to 1 and "off" to 0 for checkbox fields
      // and set defaults for fields that are left blank
      if ( isset($wpgb_options_exclusion['regex_rules']) )
        $wpgb_options_exclusion['regex_rules'] = 1;
      else
        $wpgb_options_exclusion['regex_rules'] = 0;
  
      // Update options
      $wpgb_options = get_option($this->name);
      foreach($wpgb_options_exclusion as $key => $value) {
        $wpgb_options[$key] = $value;
      }
      update_option($this->name, $wpgb_options);
    }
  
    function update_options_general() {
      $wpgb_options_general = stripslashes_deep($_POST['wpgb_options_general']);
  
      // convert "on" to 1 and "off" to 0 for checkbox fields
      // and set defaults for fields that are left blank
      if ( isset($wpgb_options_general['show_page']) )
        $wpgb_options_general['show_page'] = 1;
      else
        $wpgb_options_general['show_page'] = 0;
      if ( isset($wpgb_options_general['show_post']) )
        $wpgb_options_general['show_post'] = 1;
      else
        $wpgb_options_general['show_post'] = 0;
      if ( isset($wpgb_options_general['allow_self_refer']) )
        $wpgb_options_general['allow_self_refer'] = 1;
      else
        $wpgb_options_general['allow_self_refer'] = 0;
      if ( isset($wpgb_options_general['regex_rules']) )
        $wpgb_options_general['regex_rules'] = 1;
      else
        $wpgb_options_general['regex_rules'] = 0;
      if ( isset($wpgb_options_general['can_close']) )
        $wpgb_options_general['can_close'] = 1;
      else
        $wpgb_options_general['can_close'] = 0;
      if ( isset($wpgb_options_general['show_link']) && $wpgb_options_general['show_link'] == 'off' )
        $wpgb_options_general['show_link'] = 0;
      else
        $wpgb_options_general['show_link'] = 1;
      if ( isset($wpgb_options_general['show_related']) )
        $wpgb_options_general['show_related'] = 1;
      else
        $wpgb_options_general['show_related'] = 0;
      if ( isset($wpgb_options_general['show_related_excerpt']) )
        $wpgb_options_general['show_related_excerpt'] = 1;
      else
        $wpgb_options_general['show_related_excerpt'] = 0;
      if ( isset($wpgb_options_general['enable_css']) )
        $wpgb_options_general['enable_css'] = 1;
      else
        $wpgb_options_general['enable_css'] = 0;
      if ( isset($wpgb_options_general['enable_js']) )
        $wpgb_options_general['enable_js'] = 1;
      else
        $wpgb_options_general['enable_js'] = 0;
      if ( isset($wpgb_options_general['cache_compatible']) )
        $wpgb_options_general['cache_compatible'] = 1;
      else
        $wpgb_options_general['cache_compatible'] = 0;
      if ( !isset($wpgb_options_general['related_limit']) || $wpgb_options_general['related_limit'] == '' || !is_numeric($wpgb_options_general['related_limit']))
        $wpgb_options_general['related_limit'] = 5;
      if ( !isset($wpgb_options_general['related_excerpt_len']) || $wpgb_options_general['related_excerpt_len'] == '' || !is_numeric($wpgb_options_general['related_excerpt_len']))
        $wpgb_options_general['related_excerpt_len'] = 20;
  
      // set defaults if some fields that are left blank
      if ( !$wpgb_options_general['rss_link'] )
        $wpgb_options_general['rss_link'] = get_bloginfo('rss_url');
  
      // Update options
      $wpgb_options = get_option($this->name);
      foreach($wpgb_options_general as $key => $value) {
        $wpgb_options[$key] = $value;
      }
      update_option($this->name, $wpgb_options);
    }
  
    function admin_ajax_add($wpgb_message) {
      // convert "on" to 1 and "off" to 0 for checkbox fields
      // and set defaults for fields that are left blank
      if ( $wpgb_message['disable'] == 'off' )
        $wpgb_message['disable'] = 0;
      elseif ( $wpgb_message['disable'] == 'on' )
        $wpgb_message['disable'] = 1;
      if ( !$wpgb_message['timeout'] )
        $wpgb_message['timeout'] = 0;
  
      // Add to options
      $wpgb_options = get_option($this->name);
      $wpgb_options['messages'][] = $wpgb_message;
      update_option($this->name, $wpgb_options );
      return sizeof($wpgb_options['messages']) - 1;
    }
  
    function admin_ajax_delete($id) {
      $wpgb_options = get_option($this->name);
      // delete item but can't reindex yet
      unset($wpgb_options['messages'][$id]);
  
      // Update options
      update_option($this->name, $wpgb_options );
      return sizeof($wpgb_options['messages']) - 1;
    }
  
    function upgrade_options() {
      $wpgb_options = get_option($this->name);
      if ( !$wpgb_options ) {
        add_option($this->name, $this->get_default_options());
      }
      else {
        $default_options = $this->get_default_options();
  
        // upgrade regular options
        foreach($default_options as $option_name => $option_value) {
          if(!isset($wpgb_options[$option_name])) {
            $wpgb_options[$option_name] = $option_value;
          }
        }
  
        // upgrade default message options
        foreach($default_options['message_default'] as $key => $val) {
          if(!array_key_exists($key, $wpgb_options['message_default'])) {
            // add new option if it's missing
            $wpgb_options['message_default'][$key] = $val;
          }
        }
  
        // upgrade noscript message options
        foreach($default_options['message_noscript'] as $key => $val) {
          if(!array_key_exists($key, $wpgb_options['message_noscript'])) {
            // add new option if it's missing
            $wpgb_options['message_noscript'][$key] = $val;
          }
        }
  
        // upgrade message options
        $new_messages = $wpgb_options['messages'];
        // for each default message
        foreach($default_options['messages'] as $def_message) {
          $found = false;
          // for each current message
          foreach($wpgb_options['messages'] as $message_idx => $message) {
            if($message['referrer'] == $def_message['referrer']) {
              // found a matching message so check for any new message options
              foreach($def_message as $def_message_key => $def_message_val) {
                if(!array_key_exists($def_message_key, $message)) {
                  // add new message option if it's missing
                  $new_messages[$message_idx][$def_message_key] = $def_message_val;
                }
              }
              $found = true;
              break;
            }
          }
          if(!$found) {
            // did not find matching message, so add the default
            $new_messages[] = $def_message;
          }
        }
        $wpgb_options['messages'] = $new_messages;
        $wpgb_options['version'] = $this->version;
        update_option($this->name, $wpgb_options);
      }
    }
  
    function reset_options() {
      if ( !get_option($this->name) ) {
        add_option($this->name, $this->get_default_options());
      }
      else {
        update_option($this->name, $this->get_default_options());
      }
    }
  
    function valid_syntax($code) {
      return @eval('return true;'.$code);
    }
  
    function import_options() {
      if ( isset($_FILES['wpgb_options_import_file']) && !empty($_FILES['wpgb_options_import_file']['name']) ) {
        $wpgb_imported_options = join('', file($_FILES['wpgb_options_import_file']['tmp_name']));
        $code = '$wpgb_imported_options = '.$wpgb_imported_options.';';
        if ( $this->valid_syntax($code) ) {
          if ( eval($code) === null ) {
            update_option($this->name, $wpgb_imported_options);
            add_action('admin_notices', array($this, 'admin_notify_imported'));
          }
          else {
            add_action('admin_notices', array($this, 'admin_notify_import_failed'));
          }
        }
        else {
          add_action('admin_notices', array($this, 'admin_notify_import_failed_syntax'));
        }
      }
      else {
        add_action('admin_notices', array($this, 'admin_notify_import_failed_missing'));
      }
    }
  
    function export_options() {
      if ( !get_option($this->name) ) {
        add_option($this->name, $this->get_default_options());
      }
      $wpgb_options = get_option($this->name);
      $content = var_export($wpgb_options, true);
      header("Cache-Control: public");
      header("Content-Description: File Transfer");
      header("Content-disposition: attachment; filename=wpgb-options.txt");
      header("Content-Type: text/plain");
      header("Content-Transfer-Encoding: binary");
      header("Content-Length: ". mb_strlen($content, 'latin1'));
      echo $content;
      exit();
    }
  
    function get_nonce() {
      return wp_create_nonce($this->name);
    }
  
    function get_current_page_url() {
      $isHTTPS = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on");
      $port = (isset($_SERVER["SERVER_PORT"]) && ((!$isHTTPS && $_SERVER["SERVER_PORT"] != "80") || ($isHTTPS && $_SERVER["SERVER_PORT"] != "443")));
      $port = ($port) ? ':'.$_SERVER["SERVER_PORT"] : '';
      $url = ($isHTTPS ? 'https://' : 'http://').$_SERVER["SERVER_NAME"].$port.$_SERVER["REQUEST_URI"];
      return $url;
    }
  
    function get_icon_html($icon_file, $icon_link) {
      if ( $icon_link != '' )
        return '<a href="'.$icon_link.'" rel="nofollow"><img src="'.$icon_file.'" alt="WP Greet Box icon"/></a>';
      else
        return '<img src="'.$icon_file.'" alt="WP Greet Box icon"/>';
    }

    function get_message_html($message, $close) {
      $wpgb_options = get_option($this->name);

      $html = '';
      if ( strlen ( $message['icon'] ) > 0 ) {
        // do not show icon if there is no icon url
        $html .= $wpgb_options['before_icon'].$this->get_icon_html($message['icon'], $message['icon_link']).$wpgb_options['after_icon'];
      }
      if($close && $wpgb_options['can_close']) {
        $html .= '<div class="greet_block_close"><a id="greet_block_close" href="#">X</a></div>';
      }
      $html .= $message['text'];

      return $html;
    }

    function get_related_html($http_referrer) {
      $wpgb_options = get_option($this->name);

      $html = '';
      if($wpgb_options['show_related'] && $this->get_ref_info('isref', $http_referrer)) {
        $related_list = $this->get_ref_related($http_referrer, $wpgb_options['related_limit'], '<li><strong>', '</strong><br/>', '', '...</li>', false, $wpgb_options['show_related_excerpt'], $wpgb_options['related_excerpt_len']);
        if ( $related_list ) {
          if($wpgb_options['open_related']) {
            $shown_style = 'style="display:none"';
            $hidden_style = '';
          }
          else {
            $shown_style = '';
            $hidden_style = 'style="display:none"';
          }
          $html .= '<div style="clear:both"></div><div id="greet_search" class="greet_search_'.$wpgb_options['related_position'].'">';
          $html .= '<span id="greet_search_text_show" '.$shown_style.'>'.__('You were searching for', $this->name).'</span>';
          $html .= '<span id="greet_search_text_hide" '.$hidden_style.'>'.__('Posts relating to', $this->name).'</span> ';
          $html .= '"<u>'.$this->get_ref_info('terms', $http_referrer).'</u>". <a id="greet_search_link" action="show">';
          $html .= '<span id="greet_search_link_text_show" '.$shown_style.'>'.__('See posts relating to your search &#187;', $this->name).'</span>';
          $html .= '<span id="greet_search_link_text_hide" '.$hidden_style.'>'.__('&#171; Hide related posts', $this->name).'</span></a>';
          $html .= '<div id="greet_search_results" '.$hidden_style.'><ul>'.$related_list.'</ul></div></div>';
        }
      }

      return $html;
    }
  
    function get_greet_html($message, $http_referrer='', $page_url='', $page_title='', $close=true, $filter=true) {
      $wpgb_options = get_option($this->name);
      $html = $wpgb_options['before_greet'].$wpgb_options['before_text'];

      if($wpgb_options['related_position'] == 'before') {
        $html .= $this->get_related_html($http_referrer);
        $html .= $this->get_message_html($message, $close);
      }
      else {
        $html .= $this->get_message_html($message, $close);
        $html .= $this->get_related_html($http_referrer);
      }

      if($wpgb_options['show_link']) {
        $html .= '<div style="clear:both"></div><div class="greet_block_powered_by"><a href="http://omninoggin.com/projects/wordpress-plugins/wp-greet-box-wordpress-plugin/" title="WP Greet Box WordPress Plugin">'.__('Powered by WP Greet Box', $this->name).'</a></div>';
      }
      $html .= $wpgb_options['after_text'].$wpgb_options['after_greet'];
  
      // use default title and URL if none is passed
      if($page_url == '')
        $permalink_r = $this->get_current_page_url();
      else
        $permalink_r = $page_url;
      if($page_title == '')
        $title_r = wp_title('', false);
      else
        $title_r = $page_title;
  
      // replace tags
      $html = str_replace('[[rss-link]]', $wpgb_options['rss_link'], $html);
      $html = str_replace('[[email-link]]', $wpgb_options['email_link'], $html);
      $html = str_replace('[[permalink]]', $permalink_r, $html);
      $html = str_replace('[[escaped-permalink]]', rawurlencode($permalink_r), $html);
      $html = str_replace('[[title]]', $title_r, $html);
      $html = str_replace('[[escaped-title]]', rawurlencode($title_r), $html);
      if ( $filter ) {
        $html = apply_filters('greet_box_text', $html);
      }
      return $html;
    }
  
    function is_excluded($referrer) {
      $wpgb_options = get_option($this->name);
  
      if(!isset($wpgb_options['exclude_referrer']) || !strlen($wpgb_options['exclude_referrer'])) {
        return false;
      }
  
      $rules = split(chr(10), $wpgb_options['exclude_referrer']);
      foreach( $rules as $rule ) {
        if($wpgb_options['regex_rules']) {
          $rule = str_replace('/', '\\/', $rule);
          if(preg_match('/'.$rule.'/', $referrer)) {
            return true;
          }
        }
        else {
          if(strlen($rule) > 0 && stristr($referrer, $rule)) {
            return true;
          }
        }
      }
  
      return false;
    }
  
    function find_greet_html($http_referrer, $visit_delta, $closed=false, $page_url, $page_title) {
      $wpgb_options = get_option($this->name);
  
      $referrer_domain = $this->get_ref_domain($http_referrer, false);
      if(!$wpgb_options['allow_self_refer'] && strlen(trim($referrer_domain)) > 0 && stristr(get_option('siteurl'), $referrer_domain)) {
        return ''; // if self referral
      }
  
      if(!$this->is_excluded($http_referrer)) {
        // if not one of the excluded URLs
        if(strlen(trim($referrer_domain)) > 0){
          // if referrer is defined and is a regular URL
          foreach($wpgb_options['messages'] as $message){
            if(!$message['disable'] && strlen(trim($message['referrer'])) > 0 && strlen(trim($message['text'])) > 0){
              // if message referrer & text is defined and message is enabled
  
              // prepare regex for matching
              $referrer_regex = str_replace(' ', '', $message['referrer']);
              $referrer_regex = str_replace('.', '\\.', $referrer_regex);
              $referrer_regex = str_replace('/', '\\/', $referrer_regex);
              $referrer_regex = str_replace(',', '|', $referrer_regex);
              $referrer_regex = str_replace('*', '.*', $referrer_regex);
              $referrer_regex = '/'.$referrer_regex.'/';
  
              // compare regex
              if(preg_match($referrer_regex, $http_referrer)){
                if(($message['show_till_close'] && !$closed) || ($visit_delta < 0 || $visit_delta >= $message['timeout'])){
                  return $this->get_greet_html($message, $http_referrer, $page_url, $page_title, true);
                }
                // if matched but we don't need to display then return nothing
                return '';
              }
            }
          }
        }
  
        // if referrer not defined or no custom greeting messages match, display default
        if(!$wpgb_options['message_default']['disable'] && strlen(trim($wpgb_options['message_default']['text'])) > 0){
          if(($wpgb_options['message_default']['show_till_close'] && !$closed) || ($visit_delta < 0 || $visit_delta >= $wpgb_options['message_default']['timeout'])){
            return $this->get_greet_html($wpgb_options['message_default'], $http_referrer, $page_url, $page_title, true);
          }
        }
      }
      else{
        // if it is an excluded referrer then return nothing
        return '';
      }
    }
  
    function get_ref_delim($http_referrer) {
      $ref = $this->get_ref_domain($http_referrer);
      // Search engine match array
      // Used for fast delimiter lookup for single host search engines.
      // Non .com Google/MSN/Yahoo referrals are checked for after this array is checked
      $search_engines = array(
        'google.fr' => 'q',
        'google.com' => 'q',
        'search.yahoo.com' => 'p',
        'fr.search.yahoo.com' => 'p',
        'search.msn.com' => 'q',
        'search.live.com' => 'q',
        'rechercher.aliceadsl.fr' => 'qs',
        'vachercher.lycos.fr' => 'query',
        'search.lycos.com' => 'query',
        'alltheweb.com' => 'q',
        'search.aol.com' => 'query',
        'search.ke.voila.fr' => 'rdata',
        'recherche.club-internet.fr' => 'q',
        'ask.com' => 'q',
        'hotbot.com' => 'query',
        'overture.com' => 'Keywords',
        'search.netscape.com' => 'query',
        'search.looksmart.com' => 'qt',
        'search.earthlink.net' => 'q',
        'search.viewpoint.com' => 'k',
        'mamma.com' => 'query'
      );
    
      $delim = false;
    
      // Check to see if we have a host match in our lookup array
      if (isset($search_engines[$ref])) {
        $delim = $search_engines[$ref];
      }
      else {
      // Lets check for referrals for international TLDs and sites with strange formats    
        if (strpos($ref, 'google.') !== false && strpos($ref, 'reader') === false)
          $delim = 'q';
        elseif (strpos($ref, 'search.msn.') !== false)
          $delim = 'q';
        elseif (strpos($ref, '.search.yahoo.') !== false)
          $delim = 'q';
        elseif (strpos($ref, 'exalead.') !== false)
          $delim = 'q';
        elseif (strpos($ref, 'search.aol.') !== false)
          $delim = 'query';
        elseif (strpos($ref, '.ask.com') !== false)
          $delim = 'q';
        elseif (strpos($ref, 'recherche.aol.fr') !== false)
          $delim = (strpos($http_referrer, 'query')!==false)?'query':'q';
      }
    
      return $delim;
    }
    
    function get_ref_terms($http_referrer) {
      $terms       = null;
      $delimiter   = $this->get_ref_delim($http_referrer);
      if($delimiter) {
        $query_array = array();
        $query_terms = null;
    
        // Get raw query
        $query = explode($delimiter.'=', $http_referrer);
        $query = explode('&', $query[1]);
        $query = urldecode($query[0]);
    
        // Remove quotes, split into words, and format for HTML display
        $query = str_replace("'", '', $query);
        $query = str_replace('"', '', $query);
        $query_array = preg_split('/[\s,\+\.]+/',$query);
        $query_terms = implode(' ', $query_array);
        $terms = htmlspecialchars(urldecode($query_terms));
      }
    
      return $terms;
    }
    
    function get_ref_domain($http_referrer, $strip_www=true) {
      // Break out quickly so we don't waste CPU cycles on non referrals
      if (!isset($http_referrer) || ($http_referrer == '')) return false;
    
      $referer_info = parse_url($http_referrer);
      $referer = $referer_info['host'];
    
      if($strip_www && substr($referer, 0, 4) == 'www.') {
        // Remove www. if necessary
        $referer = substr($referer, 4);
      }
    
      return $referer;
    }
    
    function get_ref_related($http_referrer, $limit=5, $before_title='', $after_title='', $before_post='', $after_post='', $show_pass_post=false, $show_excerpt=false, $excerpt_len=20) {
      global $wpdb, $id;
    
      // Is this a supported search engine?
      if (!$this->get_ref_domain($http_referrer)) return false;
    
      $terms = $wpdb->escape($this->get_ref_terms($http_referrer));
    
      if ($terms) { 
        $time_difference = get_option('gmt_offset');
        $now = gmdate("Y-m-d H:i:s", (time()+($time_difference*3600)));
    
        // Primary SQL query
      
        $sql = 'SELECT ID, post_title, post_content,'
            . "MATCH (post_title, post_content) AGAINST ('".$terms."') AS score "
            . 'FROM '.$wpdb->posts.' WHERE '
            . "MATCH (post_title, post_content) AGAINST ('".$terms."') "
            . "AND post_date <= '".$now."' "
            . "AND (post_status IN ( 'publish',  'static' )) "
            . "AND post_type = 'post' ";
        if ($show_pass_post == false) {
          $sql .= "AND post_password = '' ";
        }
        $sql .= "ORDER BY score DESC LIMIT $limit";
        $results = $wpdb->get_results($sql);
        $output = '';
    
        if ($results) {
          foreach ($results as $result) {
            $title = stripslashes(apply_filters('the_title', $result->post_title));
            $permalink = get_permalink($result->ID);
            $post_content = strip_tags($result->post_content);
            $post_content = stripslashes($post_content);
            $output .= $before_title . '<a href="'. $permalink .'" rel="bookmark" title="'.__('Permanent Link to:') . $title . '">' . $title . '</a>' . $after_title;
            if ($show_excerpt) {
              $words=split(" ",$post_content); 
              $post_strip = join(" ", array_slice($words,0,$excerpt_len));
              $output .= $before_post . $post_strip . $after_post;
            }
          }
          return $output;
        } else {
          return False;
        }
      }
    }
    
    // Return true if the referer is a search engine
    function get_ref_info($what, $http_referrer) {
      // Is this a supported search engine?
      if (!$this->get_ref_domain($http_referrer)) return false;
      $terms = $this->get_ref_terms($http_referrer);
    
      if($terms) {
        if ($what == 'isref') { 
          return ($terms != ''?true:false);
        }
        if ($what == 'terms') {
          return $terms;
        }
      }
    } 
  
    function set_user_visit_delta() {
      # we have to set the cookie prior to the page rendering to avoid error messages (so this function is in send_headers hook)
      $full_ref = trim($_SERVER["HTTP_REFERER"]);
      $ref = 'default';
      if ( strlen($full_ref) > 0 && preg_match('/^http:\/\/[^\/]+/i', $full_ref, $matches) ) {
        $ref = str_replace('.', '_', $matches[0]);
      }
  
      if ( array_key_exists('wpgb_visit_last_php-'.$ref, $_COOKIE) ) {
        # if cookie already exsts then get the visit delta
        $visit_last = (int)$_COOKIE['wpgb_visit_last_php-'.$ref];
        $this->visit_delta = (int)round((time() - $visit_last)/60);
      }
      else {
        # if cookie doesn't exist, then create it
        $url = parse_url(get_option('home'));
        setcookie('wpgb_visit_last_php-'.$ref, time(), time() + 60 * 60 * 24 * 365, trailingslashit($url['path']));
        $this->visit_delta = -1;
      }
    }
  
    function get_user_closed($full_ref) {
      $ref = 'default';
      if ( strlen($full_ref) > 0 && preg_match('/^http:\/\/[^\/]+/i', $full_ref, $matches) ) {
        $ref = str_replace('.', '_', $matches[0]);
      }
  
      if ( array_key_exists('wpgb_closed-'.$ref, $_COOKIE) ) {
        # if cookie already exsts
        return true;
      }
      else {
        return false;
      }
    }
  
    function get_html() {
      $wpgb_options = get_option($this->name);
      $html = '<div id="greet_block">';
  
      if ( !$wpgb_options['cache_compatible'] ) {
        // get message right away
        $full_ref = trim($_SERVER["HTTP_REFERER"]);
        $closed = $this->get_user_closed($full_ref);
        $html .= $this->find_greet_html($full_ref, $this->visit_delta, $closed, get_permalink(), get_the_title());
      }
      elseif ( !$wpgb_options['message_noscript']['disable'] ) {
        $html .= '<noscript>';
        $html .= $this->get_greet_html($wpgb_options['message_noscript'], '', '', '', false, false);
        $html .= '</noscript>';
      }
      $html .= '</div>';
      return $html;
    }
  
    function display() {
      global $wpgb_shown;
      $wpgb_options = get_option($this->name);
      if(is_feed() || ($wpgb_options['show_page'] && is_page()) || ($wpgb_options['show_post'] && is_single())){
        return;
      }
      else{
        $wpgb_shown = true;
        echo $this->get_html();
      }
    }
  
    function filter_content($content) {
      global $wpgb_shown;
      $wpgb_options = get_option($this->name);
      if ( ((is_page() && $wpgb_options['show_page']) || (is_single() && $wpgb_options['show_post'])) ) {
        $wpgb_shown = true;
        if($wpgb_options['position'] == 'after') {
          return $content . $this->get_html();
        }
        else {
          return $this->get_html() . $content;
        }
      }
      else {
        return $content;
      }
    }
  
    function admin_ajax_request_handler() {
      check_ajax_referer($this->name);
      if(isset($_POST['wpgb_action'])){
        if(isset($_POST['wpgb_id'])){
          if ( strtolower($_POST['wpgb_action']) == 'activate' ) {
            $this->admin_ajax_activate($_POST['wpgb_id']);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'deactivate' ) {
            $this->admin_ajax_deactivate($_POST['wpgb_id']);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'delete' ) {
            $this->admin_ajax_delete($_POST['wpgb_id']);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'get_add_form' ) {
            $this->admin_ajax_get_add_form($_POST['wpgb_id']);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'get_edit_form' ) {
            if(is_numeric($_POST['wpgb_id'])){
              $this->admin_ajax_get_edit_form($_POST['wpgb_id']);
            }
            else{
              $this->admin_ajax_get_edit_form_default($_POST['wpgb_id']);
            }
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'update' ) {
            if(is_numeric($_POST['wpgb_id'])){
              $this->admin_ajax_update_custom($_POST['wpgb_id'], stripslashes_deep($_POST['wpgb_message']));
              $this->display_message_row($_POST['wpgb_id'], false);
            }
            else{
              $this->admin_ajax_update_default($_POST['wpgb_id'], stripslashes_deep($_POST['wpgb_message']));
              $this->display_default_row($_POST['wpgb_id'], false);
            }
          }
          else {
            echo 'Invalid wpgb_action.';
          }
        }
        else{
          if ( strtolower($_POST['wpgb_action']) == 'add' ) {
            $id = $this->admin_ajax_add(stripslashes_deep($_POST['wpgb_message']));
            $this->display_message_row($id, true);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'show_advanced_options' ) {
            $this->admin_ajax_enable_advanced_options(true);
          }
          elseif ( strtolower($_POST['wpgb_action']) == 'hide_advanced_options' ) {
            $this->admin_ajax_enable_advanced_options(false);
          }
          else {
            echo 'Invalid wpgb_action.';
          }
        }
        exit();
      }
    }
  
    function admin_notify($message, $error=false) {
      if ( !$error ) {
        echo '<div class="updated fade"><p>'.$message.'</p></div>';
      }
      else {
        echo '<div class="error"><p>'.$message.'</p></div>';
      }
    }
  
    function admin_notify_updated() {
      $this->admin_notify(__('WP Greet Box options updated.', $this->name));
    }
  
    function admin_notify_upgraded() {
      $this->admin_notify(__('WP Greet Box options upgraded.', $this->name));
    }
  
    function admin_notify_reset() {
      $this->admin_notify(__('WP Greet Box options have been reset.', $this->name));
    }
  
    function admin_notify_imported() {
      $this->admin_notify(__('WP Greet Box options imported.', $this->name));
    }
  
    function admin_notify_import_failed() {
      $this->admin_notify(__('WP Greet Box options import failed!', $this->name), true);
    }
  
    function admin_notify_import_failed_missing() {
      $this->admin_notify(__('Did not receive any file to be imported.  WP Greet Box options import failed!', $this->name), true);
    }
  
    function admin_notify_import_failed_syntax() {
      $this->admin_notify(__('Found syntax errors in file being imported.  WP Greet Box options import failed!', $this->name), true);
    }
  
    function admin_request_handler() {
      if ( isset($_POST['wpgb_options_general_submit']) ) {
        check_admin_referer($this->name);
        $this->update_options_general();
        add_action('admin_notices', array($this, 'admin_notify_updated'));
      }
      elseif ( isset($_POST['wpgb_options_exclusion_submit']) ) {
        check_admin_referer($this->name);
        $this->update_options_exclusion();
        add_action('admin_notices', array($this, 'admin_notify_updated'));
      }
      elseif ( isset($_POST['wpgb_options_upgrade']) ) {
        check_admin_referer($this->name);
        $this->upgrade_options();
        add_action('admin_notices', array($this, 'admin_notify_upgraded'));
      }
      elseif ( isset($_POST['wpgb_options_reset']) ) {
        check_admin_referer($this->name);
        $this->reset_options();
        add_action('admin_notices', array($this, 'admin_notify_reset'));
      }
      elseif ( isset($_POST['wpgb_options_import']) ) {
        check_admin_referer($this->name);
        $this->import_options();
      }
    }
  
    function public_request_handler() {
      if(isset($_GET['wpgb_public_action'])){
        if ( strtolower($_GET['wpgb_public_action']) == 'query' ) {
          echo $this->find_greet_html(urldecode($_GET['referrer']),$_GET['visit_delta'],$_GET['closed'],urldecode($_GET['url']),urldecode($_GET['title']));
        }
        exit();
      }
    }
  
    function admin_ajax_activate($id) {
      $wpgb_options = get_option($this->name);
      if($id == 'default'){
        $wpgb_options['message_default']['disable'] = 0;
      }
      elseif($id == 'noscript'){
        $wpgb_options['message_noscript']['disable'] = 0;
      }
      else{
        $wpgb_options['messages'][$id]['disable'] = 0;
      }
      update_option($this->name, $wpgb_options );
    }
  
    function admin_ajax_deactivate($id) {
      $wpgb_options = get_option($this->name);
      if($id == 'default'){
        $wpgb_options['message_default']['disable'] = 1;
      }
      elseif($id == 'noscript'){
        $wpgb_options['message_noscript']['disable'] = 1;
      }
      else{
        $wpgb_options['messages'][$id]['disable'] = 1;
      }
      update_option($this->name, $wpgb_options );
    }
  
    function admin_ajax_get_add_form($status) {
      $wpgb_options = get_option($this->name);
  
      $m = $wpgb_options['message_default'];

      if($status == 'active')
        $disable = 'off';
      else
        $disable = 'on';
  
      if($m['show_till_close'])
        $show_till_close_check = 'checked';
      else
        $show_till_close_check = '';
  
      echo(
        '<div id="wpgb_add_'.$status.'" class="wpgb_add_form">'.
          '<div id="wpgb_add_view_'.$status.'" class="wpgb_message_view" style="display:block">'.
            '<form id="wpgb_add_form_'.$status.'" action="index.php" method="post">'.
              'Referrer URL:<br/>'.
              '<input name="wpgb_message[referrer]" type="text" class="wpgb_focusable" value=""/><br/><br/>'.
              '<input name="wpgb_message[show_till_close]" type="checkbox" '.$show_till_close_check.'/> &nbsp;'.
              __('Continue to display greeting message until user first closes it (overrides visitor timeout if checked)', $this->name).'<br/><br/>'.
              __('Visitor Timeout (minutes)', $this->name).':<br/>'.
              '<input name="wpgb_message[timeout]" type="text" class="wpgb_focusable" value="'.attribute_escape($m['timeout']).'"/><br/><br/>'.
              __('Greeting Icon (optional)', $this->name).':'.
              '<input name="wpgb_message[icon]" type="text" class="wpgb_focusable wpgb_wide" value="'.attribute_escape($m['icon']).'"/><br/><br/>'.
              __('Greeting Icon Link (optional)', $this->name).':'.
              '<input name="wpgb_message[icon_link]" type="text" class="wpgb_focusable wpgb_wide" value="'.attribute_escape($m['icon_link']).'"/><br/><br/>'.
              __('Greeting message', $this->name).':'.
              '<textarea name="wpgb_message[text]" class="wpgb_focusable wpgb_wide" rows="4">'.attribute_escape($m['text']).'</textarea><br/><br/>'.
              '<input name="wpgb_message[disable]" type="hidden" value="'.$disable.'"/>'.
              '<p class="submit">'.
                '<input type="submit" class="wpgb_submit" entry="new" value="'.__('Add', $this->name).'" />'.
                '<input type="button" class="wpgb_cancel" entry="active" value="'.__('Cancel', $this->name).'" />'.
              '</p>'.
              '<input type="hidden" name="wpgb_action" value="add"/>'.
            '</form>'.
          '</div>'.
        '</div>'
      );
    }
  
    function admin_ajax_get_edit_form($id) {
      $wpgb_options = get_option($this->name);
  
      $m = $wpgb_options['messages'][$id];

      if($m['show_till_close'])
        $show_till_close_check = 'checked';
      else
        $show_till_close_check = '';
  
      echo(
        '<form id="wpgb_custom_message_form_'.$id.'" action="index.php" method="post">'.
          __('Referrer URL', $this->name).':<br/>'.
          '<input name="wpgb_message[referrer]" type="text" class="wpgb_focusable" value="'.attribute_escape($m['referrer']).'"/><br/><br/>'.
          '<input name="wpgb_message[show_till_close]" type="checkbox" '.$show_till_close_check.'/> &nbsp;'.
          __('Continue to display greeting message until user first closes it (overrides visitor timeout if checked)', $this->name).'<br/><br/>'.
          __('Visitor Timeout (minutes)', $this->name).':<br/>'.
          '<input name="wpgb_message[timeout]" type="text" class="wpgb_focusable" value="'.attribute_escape($m['timeout']).'"/><br/><br/>'.
          __('Greeting Icon (optional)', $this->name).':'.
          '<input name="wpgb_message[icon]" type="text" class="wpgb_focusable widefat" value="'.attribute_escape($m['icon']).'"/><br/><br/>'.
          __('Greeting Icon Link (optional)', $this->name).':'.
          '<input name="wpgb_message[icon_link]" type="text" class="wpgb_focusable widefat" value="'.attribute_escape($m['icon_link']).'"/><br/><br/>'.
          __('Greeting message', $this->name).':'.
          '<textarea name="wpgb_message[text]" class="wpgb_focusable widefat" rows="4">'.attribute_escape($m['text']).'</textarea><br/><br/>'.
          '<p class="submit">'.
            '<input type="submit" class="wpgb_submit" entry="'.$id.'" value="'.__('Save', $this->name).'" />'.
            '<input type="button" class="wpgb_cancel" entry="'.$id.'" value="'.__('Cancel', $this->name).'"/>'.
          '</p>'.
          '<input type="hidden" name="wpgb_id" value="'.$id.'"/>'.
          '<input type="hidden" name="wpgb_action" value="update"/>'.
        '</form>'
      );
    }
  
    function admin_ajax_get_edit_form_default($type) {
      $wpgb_options = get_option($this->name);
  
      if($type == "default"){
        $m = $wpgb_options['message_default'];
        $type = 'default';
  
        if($m['show_till_close'])
          $show_till_close_check = 'checked';
        else
          $show_till_close_check = '';
  
        $show_till_close = '<input name="wpgb_message[show_till_close]" type="checkbox" '.$show_till_close_check.'/> &nbsp;'.__('Continue to display greeting message until user first closes it (overrides visitor timeout if checked)', $this->name).'<br/><br/>';
  
        $visitor_timeout = __('Visitor Timeout (minutes)', $this->name).':<br/><input name="wpgb_message[timeout]" type="text" class="wpgb_focusable" value="'.attribute_escape($m['timeout']).'"/><br/><br/>';
      }
      else{
        $m = $wpgb_options['message_noscript'];
        $type = 'noscript';
        $show_till_close = '';
        $visitor_timeout = '';
      }
  
      if ( $m['disable'] )
        $checkmark = 'checked';
      else
        $checkmark = '';
  
      echo(
        '<form id="wpgb_custom_message_form_'.$type.'" action="index.php" method="post">'.
          $show_till_close.
          $visitor_timeout.
          __('Greeting Icon (optional)', $this->name).':'.
          '<input name="wpgb_message[icon]" type="text" class="wpgb_focusable widefat" value="'.attribute_escape($m['icon']).'"/><br/><br/>'.
          __('Greeting Icon Link (optional)', $this->name).':'.
          '<input name="wpgb_message[icon_link]" type="text" class="wpgb_focusable widefat" value="'.attribute_escape($m['icon_link']).'"/><br/><br/>'.
          __('Greeting message', $this->name).':'.
          '<textarea name="wpgb_message[text]" class="wpgb_focusable widefat" rows="4">'.attribute_escape($m['text']).'</textarea><br/><br/>'.
          '<p class="submit">'.
            '<input type="submit" class="wpgb_submit" entry="'.$type.'" value="'.__('Save', $this->name).'"/>'.
            '<input type="button" class="wpgb_cancel" entry="'.$type.'" value="'.__('Cancel', $this->name).'"/>'.
          '</p>'.
          '<input type="hidden" name="wpgb_id" value="'.$type.'"/>'.
          '<input type="hidden" name="wpgb_action" value="update"/>'.
        '</form>'
      );
    }
  
    function admin_ajax_enable_advanced_options($enable) {
      $wpgb_options = get_option($this->name);
      if($enable == true){
        $wpgb_options['show_advanced_options'] = 1;
      }
      else{
        $wpgb_options['show_advanced_options'] = 0;
      }
      update_option($this->name, $wpgb_options );
    }
  
    function admin_menu() {
      $options_page = add_options_page('WP Greet Box', 'WP Greet Box', 'manage_options', $this->name, array($this, 'admin_page'));
      add_action('admin_head-'.$options_page, array($this, 'load_admin_scripts'));
      add_action('admin_head-'.$options_page, array($this, 'admin_request_handler'));
    }
  
    function admin_page() {
      // reindex here when we get the chance to reload page
      $wpgb_options = get_option($this->name);
      $wpgb_options['messages'] = array_values($wpgb_options['messages']);
      update_option($this->name, $wpgb_options );
  
      echo(
        '<div class="wrap">'.
          '<h2>'.__('WP Greet Box Options', $this->name).'</h2>'.
          '<div>'.
            '<a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'">'.__('Greeting Messages', $this->name).'</a>&nbsp;|&nbsp;'.
            '<a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'&wpgb-page=exclude'.'">'.__('Exclusion Rules', $this->name).'</a>&nbsp;|&nbsp;'.
            '<a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'&wpgb-page=generic'.'">'.__('General Configuration', $this->name).'</a>&nbsp;|&nbsp;'.
            '<a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'&wpgb-page=import-export'.'">'.__('Import/Export', $this->name).'</a>&nbsp;|&nbsp;'.
            '<a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'&wpgb-page=documentation'.'">'.__('Documentation', $this->name).'</a>'.
          '</div>'
       );

       if(isset($_GET['wpgb-page'])) {
         if($_GET['wpgb-page'] == 'documentation') {
           require_once('documentation.php');
         }
         elseif($_GET['wpgb-page'] == 'exclude') {
           require_once('options-exclude.php');
         }
         elseif($_GET['wpgb-page'] == 'generic') {
           require_once('options-generic.php');
         }
         elseif($_GET['wpgb-page'] == 'import-export') {
           require_once('options-import-export.php');
         }
       }
       else {
         require_once('options-custom.php');
       }
       echo(
         '</div>'
       );
    } // function admin_page()

  } // class WPGreetBox

} // if !class_exists

$wpgb_shown = false;

if (class_exists('WPGreetBox')) {
  $wp_greet_box = new WPGreetBox();
  
  add_action('admin_menu', array($wp_greet_box, 'admin_menu'));
  add_action('admin_notices', array($wp_greet_box, 'check_version'));
  add_action('init', array($wp_greet_box, 'public_request_handler'));
  add_action('send_headers', array($wp_greet_box, 'set_user_visit_delta'));
  add_action('wp_ajax_wpgb', array($wp_greet_box, 'admin_ajax_request_handler'));
  add_action('wp_footer', array($wp_greet_box, 'embed_scripts'));
  add_action('wp_print_scripts', array($wp_greet_box, 'queue_jquery'));
  
  $wpgb_options = get_option($wp_greet_box->name);

  if ( $wpgb_options['enable_css'] ) {
    if ( function_exists('wp_enqueue_style') && function_exists('wp_register_style') ) {
      // WP 2.6
      add_action('init', array($wp_greet_box, 'queue_styles'));
    }
    else {
      // before WP 2.6
      add_action('wp_head', array($wp_greet_box, 'embed_styles'));
    }
  }
  
  add_filter('the_content', array($wp_greet_box, 'filter_content'));

  register_activation_hook(__FILE__, array($wp_greet_box, 'activate'));
}

// function used for manually insertion
function wp_greet_box() {
  global $wp_greet_box;
  if ( $wp_greet_box )
    $wp_greet_box->display();
}

// require scripts needed for running WP Greet Box calls directly
if (!defined( 'ABSPATH' )) {
  $root = dirname(dirname(dirname(dirname(__FILE__))));
  if (file_exists($root.DIRECTORY_SEPARATOR.'wp-load.php')) {
    // WP 2.6
    require_once($root.DIRECTORY_SEPARATOR.'wp-load.php');
  } else {
    // Before 2.6
    require_once($root.DIRECTORY_SEPARATOR.'wp-config.php');
  }
  require_once( $root.DIRECTORY_SEPARATOR.'wp-includes'.DIRECTORY_SEPARATOR.'wp-db.php' );
}

if ( isset($_POST['wpgb_options_export']) ) {
  $wp_greet_box->export_options();
}

require("omninoggin-posts.php");
?>
