<fieldset class="wpgb_fieldset wpgb_fieldset_alt">
  <h2>Installation</h2>
  <ol>
    <li>Upload the plugin to your plugins folder: 'wp-content/plugins/'</li>
    <li>Activate the 'WP Greet Box' plugin from the Plugins admin panel.</li>
    <li>(optional) Go to the Options -&gt; WP Greet Box admin panel to make any customizations.</li>
    <li>Test this out by googling one of your articles and click through to your site from google. You should see the greeting message custimized for a google visitor.</li>
  </ol>
  <h2>Tips on Customizing Messages</h2>
  <ol>
    <li>
      <p>Multiple referrer URLs can be defined for each greeting message using the following simple syntax.</p>
      <dl>
        <dt>Asterisk (*) can serve as a wild card for URLs</dt>
        <dd>For example, the referrer URL "google.*" will match any variations of google (google.com, google.fr, etc.).</dd>
        <dt>Comma (,) can serve as a list operator</dt>
        <dd>For example, the referrer URL "delicious, del.icio.us" will match either delicious.com or del.icio.us.</dd>
      </dl>
    </li>
    <li>
      <p>The following special tags are available for use in greeting messages and icon link fields.</p>
      <dl>
        <dt>[[rss-link]]</dt>
        <dd>The url of your rss feed.  You can set this in the "General Advanced Options" section.</dd>
        <dt>[[email-link]]</dt>
        <dd>The url for subscribing via email.  You can set this in the "General Advanced Options" section.</dd>
        <dt>[[permalink]]</dt>
        <dd>The current page's url.</dd>
        <dt>[[escaped-permalink]]</dt>
        <dd>The escaped version of the current page's url.</dd>
        <dt>[[title]]</dt>
        <dd>The current page's title.</dd>
        <dt>[[escaped-title]]</dt>
        <dd>The escaped version of the current page's title.</dd>
      </dl>
    </li>
    <li>
      <p>To customize the css property of the greet box, modify<br/>
        <strong><?php echo $this->get_plugin_dir().'css/wp-greet-box.css' ?></strong>.
      </p>
    </li>
    <li>
      <p><strong>Continue to display greeting message until user first closes it</strong>, when checked will cause the greeting message to keep displaying on every visit until the user clicks close for the first time.  After that, the greeting message will not show up for that user anymore.  This setting overrides "Visitor Timeout" setting below.<br/>
      </p>
    </li>
    <li>
      <p><strong>Visitor timeout</strong> is the number of minutes since the visitor's last visit until the plugin forgets the visitor.  For sites like digg.com you would want to set this setting to something small like "0", because you would want the digg.com visitor to always see the request to be dugg on every visit.  For sites like google.com you might want to set it to something higher like "1440" (1 day) because you probably do not want to nag the google visitor that much.  play around with the values to see what suits you best.<br/>
      </p>
    </li>
  </ol>
  <h2>Tips on Setting Exclusion Rules</h2>
  <ol>
    <li>
      <p>Rules are line delimited.  To not show greeting messages to visitors from friendfeed or google reader, use the following rule:</p>
      <dl>
        <dt>friendfeed.com</dt>
        <dt>google.com/reader</dt>
      </dl>
    </li>
    <li>
      <p>When regular expressions is enabled, each line will be used as a regular expression.  The same rules above in regular expressions will look like:</p>
      <dl>
        <dt>friendfeed\.com</dt>
        <dt>google\.com/reader</dt>
      </dl>
    </li>
    <li>
      <p>For regular expression usage, refer to <a href="http://www.zytrax.com/tech/web/regex.htm">user guide</a> and <a href="http://www.regular-expressions.info/reference.html">reference</a>.
    </li>
  </ol>
  <h2>Manual Greeting Message Insertion</h2>
  <p>To manually position your greeting message, you will have to:</p>
  <ol>
    <li>Disable automatic insertion on posts and pages.</li>
    <li>Copy the following code to your desired location in any of the theme files.</li>
      <dl>
        &lt;?php if(function_exists('wp_greet_box')){wp_greet_box();} ?&gt;
      </dl>
    </li>
  </ol>
  <h2>Have More Questions?</h2>
  <p>You may visit the <a href="http://omninoggin.com/projects/wordpress-plugins/wp-greet-box-wordpress-plugin/">WP Greet Box plugin page</a> to post any questions, bugs, comments, or feedback.</p>
</fieldset>
