<?php
/*
Plugin Name: SOLVEMEDIA
Plugin URI: http://www.solvemedia.com/
Description: Integrates Solve Media's anti-spam solutions with wordpress
Version: 1.0.5
Author: Ilia Fishbein
Email: support@solvemedia.com
Author URI: http://www.solvemedia.com/
Created: 2009-Jun-23 10:42 (EDT)

Copyright (c) 2010 by Solve Media

$Id: solvemedia.php,v 1.3 2010/09/24 19:28:13 ilia Exp $
*/

/* This code is based on code from,
 * and copied, modified and distributed with permission in accordance with its terms:

    Copyright (c) 2008 reCAPTCHA -- http://recaptcha.net
    AUTHORS:
      Mike Crawford
      Ben Maurer
      Jorge Peña

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/



// Plugin was initially created by Ben Maurer and Mike Crawford
// Permissions/2.5 transition help from Jeremy Clarke @ http://globalvoicesonline.org

// WORDPRESS MU DETECTION

// WordPress MU settings - DON'T EDIT
//    0 - Regular WordPress installation
//    1 - WordPress MU Forced Activated
//    2 - WordPress MU Optional Activation

$wpmu = 0;

if (basename(dirname(__FILE__)) == "mu-plugins") // forced activated
   $wpmu = 1;
else if (basename(dirname(__FILE__)) == "plugins" && function_exists('is_site_admin')) // optionally activated
   $wpmu = 2;

if ($wpmu == 1)
   $adcopy_opt = get_site_option('adcopy'); // get the options from the database
else
   $adcopy_opt = get_option('adcopy'); // get the options from the database

// END WORDPRESS MU DETECTION

if ($wpmu == 1)
   require_once(dirname(__FILE__) . '/solvemedia/solvemedialib.php');
else
   require_once(dirname(__FILE__) . '/solvemedialib.php');

if (file_exists(WP_PLUGIN_DIR . '/contact-form-7/includes/shortcodes.php'))
    require_once(WP_PLUGIN_DIR . '/contact-form-7/includes/shortcodes.php');
if (file_exists(WP_PLUGIN_DIR . '/contact-form-7/includes/taggenerator.php'))
    require_once(WP_PLUGIN_DIR . '/contact-form-7/includes/taggenerator.php');

// doesn't need to be secret, just shouldn't be used by any other code.
define ("ADCOPY_WP_HASH_SALT", "2bfaec807a2401880a33b18956663057");

/* =============================================================================
   CSS - This links the pages to the stylesheet to be properly styled
   ============================================================================= */

function re_css() {
   global $adcopy_opt, $wpmu, $wp_version;

   if (!defined('WP_CONTENT_URL'))
      define('WP_CONTENT_URL', get_option('siteurl') . '/wp-content');

   $path = WP_CONTENT_URL . '/plugins/solvemedia/solvemedia.css';

   if ($wpmu == 1)
		$path = WP_CONTENT_URL . '/mu-plugins/solvemedia/solvemedia.css';

   echo '<link rel="stylesheet" type="text/css" href="' . $path . '" />';
   if ($wp_version[0] > 2) {
       echo '<style>#adcopy-puzzle-image img {width: 100%; height: 100%}</style>';
   }
}

function registration_css() {
   global $adcopy_opt;

   if ($adcopy_opt['re_registration']) {
        $width = 358;
        echo <<<REGISTRATION
            <style type="text/css">
                #login {
                    width: {$width}px !important;
                }

                #login a {
                    text-align: center;
                }

                #nav {
                    text-align: center;
                }

                form .submit {
                    margin-top: 10px;
                }
            </style>
REGISTRATION;
   }
}

add_action('wp_head', 're_css'); // include the stylesheet in typical pages to style hidden emails
add_action('admin_head', 're_css'); // include stylesheet to style options page
add_action('login_head', 'registration_css'); // include the login div styling, embedded

/* =============================================================================
   End CSS
   ============================================================================= */

// If the plugin is deactivated, delete the preferences
function delete_preferences() {
   global $wpmu;

   if ($wpmu != 1)
       delete_option('adcopy');
}

register_deactivation_hook(__FILE__, 'delete_preferences');

/* =============================================================================
   solvemedia on Registration Form - Thanks to Ben C.'s recapture plugin
   ============================================================================= */


// Display the solvemedia on the registration form or in a Contact Form 7 form
function display_adcopy($errors) { // Arguement can either be array of errors from WordPress or array with keys type and name from contact form 7
    global $adcopy_opt, $wpmu;

    if (($adcopy_opt['re_registration'] && $errors['type'] != 'solvemedia') || ($adcopy_opt['re_contact_form_7'] && $errors['type'] == 'solvemedia')) {
        $theme = $errors['type'] == 'solvemedia' ? $adcopy_opt['re_theme_cf7'] : $adcopy_opt['re_theme_reg'];
        $format = <<<OPTIONS
            <script type='text/javascript'>
                var ACPuzzleOptions = { theme : '$theme', lang : '{$adcopy_opt['re_lang']}', tabindex : {$adcopy_opt['re_tabindex']} };
            </script>
OPTIONS;

        $use_ssl =  (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on");

        if ($wpmu == 1) {
            $error = $errors->get_error_message('captcha');
?>
            <label for="verification">Verification:</label>
<?php
            $html = $error ? '<p class="error">'.$error.'</p>' : '';
            $html = $html . $format . adcopy_wp_get_html($_GET['rerror'], $use_ssl);
        }
        else {
            $html = $format . adcopy_wp_get_html($_GET['rerror'], $use_ssl);
            if ($errors['type'] == 'solvemedia')
                $html = '<span><span class="wpcf7-form-control-wrap solvemedia"></span>'.$html.'</span>';
            else
		$html = '<hr style="clear: both; margin-bottom: 1.5em; border: 0; border-top: 1px solid #999; height: 1px;" />'.$html;
        }
    }
    if ($adcopy_opt['re_contact_form_7'] && $errors['type'] == 'solvemedia')
        return $html;
    echo $html;
}

// Hook the display_adcopy function into WordPress
if ($wpmu != 1)
   add_action('register_form', 'display_adcopy');
else
   add_action('signup_extra_fields', 'display_adcopy');

// Check the captcha
function check_adcopy($result, $tag='') {
    global $adcopy_opt, $errors, $wpcf7_contact_form;

    if ($tag != '') //Contact form 7
        $calling_form = 1;
    elseif (version_compare(get_bloginfo('version'), '2.5' ) < 0) //Registration form on WordPress older than 2.5
        $calling_form = 2;
    else //Registration form on WordPress 2.5 or newer
        $calling_form = 3;

    if ($_POST['adcopy_challenge']) {
        if (empty($_POST['adcopy_response'])) {
            switch ($calling_form) {
                case 1:
                    $result['valid'] = false;
                    $result['reason']['solvemedia'] = $adcopy_opt['error_blank_cf7'];
                    break;
                case 2:
                    $errors['blank_captcha'] = $adcopy_opt['error_blank'];
                    break;
                case 3:
                    $result->add('blank_captcha', $adcopy_opt['error_blank']);
                    break;
            }
        }
        else {
            $response2 = solvemedia_check_answer($adcopy_opt['privkey'],
	                                     $_SERVER['REMOTE_ADDR'],
                                             $_POST['adcopy_challenge'],
                                             $_POST['adcopy_response'],
                                             $adcopy_opt['hashkey']);
            if (!$response2->is_valid) {
                switch ($calling_form) {
                    case 1:
                        $result['valid'] = false;
                        $result['reason']['solvemedia'] = $adcopy_opt['error_incorrect_cf7'];
                        break;
                    case 2:
                        $errors['captcha_wrong'] = $adcopy_opt['error_incorrect'];
                        break;
                    case 3:
                        $result->add('captcha_wrong', $adcopy_opt['error_incorrect']);
                        break;
                }
            }
        }
    }
    if ($calling_form != 2)
        return $result;
}

if (function_exists('wpcf7_add_shortcode') && $adcopy_opt['re_contact_form_7'])
    wpcf7_add_shortcode('solvemedia', 'display_adcopy', true);

// Register JQuery reloading on successful AJAX submit
function adcopy_enqueue_scripts()
{
    global $wpmu;
    if ($wpmu !=1)
        wp_enqueue_script( 'puzzle_reload', WP_CONTENT_URL . '/plugins/solvemedia/puzzle_reload.js', array( 'jquery', 'jquery-form' ));
    else
        wp_enqueue_script( 'puzzle_reload', WP_CONTENT_URL . '/mu-plugins/solvemedia/puzzle_reload.js', array( 'jquery', 'jquery-form' ));
}

add_action( 'init', 'adcopy_enqueue_scripts' );
add_filter( 'wpcf7_validate_solvemedia', 'check_adcopy', 10, 2 );


// Check the solvemedia on WordPress MU
function check_adcopy_wpmu($result) {
    global $_POST, $adcopy_opt;

    // must make a check here, otherwise the wp-admin/user-new.php script will keep trying to call
    // this function despite not having called do_action('signup_extra_fields'), so the adcopy
    // field was never shown. this way it won't validate if it's called in the admin interface
    if (!is_admin()) {
        // It's blogname in 2.6, blog_id prior to that
        if (isset($_POST['blog_id']) || isset($_POST['blogname']))
      	    return $result;

        // no text entered
        if (empty($_POST['adcopy_response']) || $_POST['adcopy_response'] == '') {
            $result['errors']->add('blank_captcha', $adcopy_opt['error_blank']);
            return $result;
        }

        $response = solvemedia_check_answer($adcopy_opt['privkey'],
                                        $_SERVER['REMOTE_ADDR'],
                                        $_POST['adcopy_challenge'],
                                        $_POST['adcopy_response'],
                                        $adcopy_opt['hashkey']);

        // incorrect CAPTCHA
        if (!$response->is_valid)
      	    if ($response->error == 'wrong answer') {
                $result['errors']->add('captcha_wrong', $adcopy_opt['error_incorrect']);
                echo "<div class=\"error\">". $adcopy_opt['error_incorrect'] . "</div>";
            }
        }

    return $result;
}

if ($adcopy_opt['re_registration']) {
    if ($wpmu == 1)
        add_filter('wpmu_validate_user_signup', 'check_adcopy_wpmu');

    elseif ($wpmu == 0)
        add_filter('registration_errors', 'check_adcopy');
}
/* =============================================================================
   End solvemedia on Registration Form
   ============================================================================= */

/* =============================================================================
   solvemedia Plugin Default Options
   ============================================================================= */

$option_defaults = array (
    'pubkey'              => '', // the public key for solvemedia
    'privkey'             => '', // the private key for solvemedia
    'hashkey'             => '', // the hash key for solvemedia
    're_bypass'           => '', // whether to sometimes skip solvemedias for registered users
    're_bypasslevel'      => '', // who doesn't have to do the solvemedia (should be a valid WordPress capability slug)
    're_theme'            => 'red', // the default theme for solvemedia on the comment post
    're_theme_reg'        => 'red', // the default theme for solvemedia on the registration form
    're_theme_cf7'        => 'red', // the default theme for solvemedia on a Contact Form 7 form
    're_lang'             => 'en', // the default language for solvemedia
    're_tabindex'         => '5', // the default tabindex for solvemedia
    're_comments'         => '1', // whether or not to show solvemedia on the comment post
    're_registration'     => '1', // whether or not to show solvemedia on the registration page
    're_contact_form_7'   => '1', // whether or not to show solvemedia on the comment post
    're_xhtml'            => '0', // whether or not to be XHTML 1.0 Strict compliant
    'mh_replace_link'     => '', // name the link something else
    'mh_replace_title'    => '', // title of the link
    'error_blank'         => "<strong>ERROR</strong>: Please fill in the solvemedia form.", // the message to display when the user enters no CAPTCHA response
    'error_incorrect'     => '<strong>ERROR</strong>: That solvemedia response was incorrect.', // the message to display when the user enters the incorrect CAPTCHA response
    'error_blank_cf7'     => "ERROR: Please fill in the solvemedia form.", // the message to display when the user enters no CAPTCHA response when used in Contact Form 7 form
    'error_incorrect_cf7' => 'ERROR: That solvemedia response was incorrect.', // the message to display when the user enters the incorrect CAPTCHA response when used in Contact Form 7 form
);

// install the defaults
if ($wpmu != 1)
    add_option('adcopy', $option_defaults, 'solvemedia Default Options', 'yes');

/* =============================================================================
   End solvemedia Plugin Default Options
   ============================================================================= */


/* =============================================================================
   solvemedia - The solvemedia comment spam protection section
   ============================================================================= */
function adcopy_wp_hash_comment($id)
{
    global $adcopy_opt;

    if (function_exists('wp_hash'))
        return wp_hash(ADCOPY_WP_HASH_SALT . $id);
    else
        return md5(ADCOPY_WP_HASH_SALT . $adcopy_opt['privkey'] . $id);
}

function adcopy_wp_get_html ($adcopy_error, $use_ssl=false) {
    global $adcopy_opt;

    return solvemedia_get_html($adcopy_opt['pubkey'], $adcopy_error, $use_ssl, $adcopy_opt['re_xhtml']);
}

/**
 *  Embeds the solvemedia widget into the comment form.
 *
 */
function adcopy_comment_form() {
    global $user_ID, $adcopy_opt;

    // set the minimum capability needed to skip the captcha if there is one
    if ($adcopy_opt['re_bypass'] && $adcopy_opt['re_bypasslevel'])
        $needed_capability = $adcopy_opt['re_bypasslevel'];

    // skip the solvemedia display if the minimum capability is met
    if (($needed_capability && current_user_can($needed_capability)) || !$adcopy_opt['re_comments'])
        return;
    else {
        // Did the user fail to match the CAPTCHA? If so, let them know
        if ($_GET['rerror'] == 'incorrect-solution' || $_GET['rerror'] == 'wronganswer')
            echo "<p class=\"adcopy-error\">" . $adcopy_opt['error_incorrect'] . "</p>";

        //modify the comment form for the solvemedia widget
        $adcopy_js_opts = <<<OPTS
            <script type='text/javascript'>
                var ACPuzzleOptions = { theme : '{$adcopy_opt['re_theme']}', tabindex : {$adcopy_opt['re_tabindex']} };
            </script>
OPTS;

        $comment_string = <<<COMMENT_FORM
            <div id="adcopy-submit-btn-area"><br /></div>
            <script type='text/javascript'>
                var sub = document.getElementById('submit');
                if (sub.parentNode != 'undefined' && sub.parentNode.tagName.toLowerCase() == 'p')
                    sub = sub.parentNode;
                sub.parentNode.removeChild(sub);
                document.getElementById('adcopy-submit-btn-area').appendChild (sub);
                document.getElementById('submit').tabIndex = 6;
                if ( typeof _adcopy_wordpress_savedcomment != 'undefined') {
                    document.getElementById('comment').value = _adcopy_wordpress_savedcomment;
                }
            </script>
COMMENT_FORM;

        if ($adcopy_opt['re_xhtml']) {
            $comment_string .= <<<COMMENT_FORM
                <noscript>
                    <style type='text/css'>#submit {display:none;}</style>
                    <input name="submit" type="submit" id="submit-alt" tabindex="6" value="Submit Comment"/>
                </noscript>
COMMENT_FORM;
        }

	$use_ssl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on");

        echo $adcopy_js_opts . adcopy_wp_get_html($_GET['rerror'], $use_ssl) . $comment_string;
    }
}

add_action('comment_form', 'adcopy_comment_form');

$adcopy_saved_error = '';

/**
 * Checks if the solvemedia guess was correct and sets an error session variable if not
 * @param array $comment_data
 * @return array $comment_data
 */
function adcopy_wp_check_comment($comment_data) {
    global $user_ID, $adcopy_opt, $adcopy_saved_error;

    // set the minimum capability needed to skip the captcha if there is one
    if ($adcopy_opt['re_bypass'] && $adcopy_opt['re_bypasslevel'])
        $needed_capability = $adcopy_opt['re_bypasslevel'];

    // skip the filtering if the minimum capability is met
    if (($needed_capability && current_user_can($needed_capability)) || !$adcopy_opt['re_comments'])
        return $comment_data;

    if ( $comment_data['comment_type'] == '' ) { // Do not check trackbacks/pingbacks
        $challenge = $_POST['adcopy_challenge'];
        $response = $_POST['adcopy_response'];
        $adcopy_response = solvemedia_check_answer ($adcopy_opt ['privkey'],
                                                $_SERVER['REMOTE_ADDR'],
                                                $challenge,
                                                $response,
                                                $adcopy_opt['hashkey'] );
        if ($adcopy_response->is_valid)
            return $comment_data;
        else {
            $adcopy_saved_error = $adcopy_response->error;
            add_filter('pre_comment_approved', create_function('$a', 'return \'spam\';'));
            return $comment_data;
        }
    }
    return $comment_data;
}

/*
 * If the solvemedia guess was incorrect from adcopy_wp_check_comment, then redirect back to the comment form
 * @param string $location
 * @param OBJECT $comment
 * @return string $location
 */
function adcopy_wp_relative_redirect($location, $comment) {
    global $adcopy_saved_error;
    if($adcopy_saved_error != '') {
        //replace the '#comment-' chars on the end of $location with '#commentform'.
        $location = substr($location, 0,strrpos($location, '#')) .
                    ((strrpos($location, "?") === false) ? "?" : "&") .
                    'rcommentid=' . $comment->comment_ID .
                    '&rerror=' . $adcopy_saved_error .
                    '&rchash=' . adcopy_wp_hash_comment ($comment->comment_ID) .
                    '#commentform';
    }
    return $location;
}

/*
 * If the solvemedia guess was incorrect from adcopy_wp_check_comment, then insert their saved comment text
 * back in the comment form.
 * @param boolean $approved
 * @return boolean $approved
 */
function adcopy_wp_saved_comment() {
    if (!is_single() && !is_page())
        return;

    if ($_GET['rcommentid'] && $_GET['rchash'] == adcopy_wp_hash_comment ($_GET['rcommentid'])) {
        $comment = get_comment($_GET['rcommentid']);

        $com = preg_replace('/([\\/\(\)\+\;\'\"])/e','\'%\'.dechex(ord(\'$1\'))', $comment->comment_content);
        $com = preg_replace('/\\r\\n/m', '\\\n', $com);

        echo <<<SAVED_COMMENT
        <script type='text/javascript'>
            var _adcopy_wordpress_savedcomment =  '$com';
            _adcopy_wordpress_savedcomment = unescape(_adcopy_wordpress_savedcomment);
        </script>
SAVED_COMMENT;

       wp_delete_comment($comment->comment_ID);
   }
}

function adcopy_wp_blog_domain () {
    $uri = parse_url(get_settings('siteurl'));
    return $uri['host'];
}

add_filter('wp_head', 'adcopy_wp_saved_comment',0);
add_filter('preprocess_comment', 'adcopy_wp_check_comment',0);
add_filter('comment_post_redirect', 'adcopy_wp_relative_redirect',0,2);

function adcopy_wp_add_options_to_admin() {
    global $wpmu;

    if ($wpmu == 1 && is_site_admin()) {
        add_submenu_page('wpmu-admin.php', 'Solve Media', 'Solve Media', 'manage_options', __FILE__, 'adcopy_wp_options_subpanel');
        add_options_page('Solve Media', 'Solve Media', 'manage_options', __FILE__, 'adcopy_wp_options_subpanel');
    }
    else if ($wpmu != 1) {
        add_options_page('Solve Media', 'Solve Media', 'manage_options', __FILE__, 'adcopy_wp_options_subpanel');
    }
}

function adcopy_wp_options_subpanel() {
    global $wpmu;
    // Default values for the options array
    $optionarray_def = array(
        'pubkey'              => '',
        'privkey'             => '',
        'hashkey'             => '',
        're_bypasslevel'      => '3',
        're_theme'            => 'red',
        're_theme_reg'        => 'red',
        're_theme_cf7'        => 'red',
        're_lang'             => 'en',
        're_tabindex'         => '5',
        're_comments'         => '1',
        're_registration'     => '1',
        're_contact_form_7'   => '1',
        're_xhtml'            => '0',
        'error_blank'         => '<strong>ERROR</strong>: Please fill in the Solve Media puzzle form.',
        'error_incorrect'     => '<strong>ERROR</strong>: That Solve Media puzzle response was incorrect.',
        'error_blank_cf7'     => "ERROR: Please fill in the Solve Media puzzle form.",
        'error_incorrect_cf7' => 'ERROR: That Solve Media puzzle response was incorrect.',
    );

    if ($wpmu != 1)
        add_option('adcopy', $optionarray_def, 'solvemedia Options');

	/* Check form submission and update options if no error occurred */
    if (isset($_POST['submit'])) {
        $pattern = '/<.*?>/';
        $substitue = '';
        $optionarray_update = array (
            'pubkey'              => trim($_POST['adcopy_opt_pubkey']),
            'privkey'             => trim($_POST['adcopy_opt_privkey']),
            'hashkey'             => trim($_POST['adcopy_opt_hashkey']),
            're_bypass'           => $_POST['re_bypass'],
            're_bypasslevel'      => $_POST['re_bypasslevel'],
            're_theme'            => $_POST['re_theme'],
            're_theme_reg'        => $_POST['re_theme_reg'],
            're_theme_cf7'        => $_POST['re_theme_cf7'],
            're_lang'             => $_POST['re_lang'],
            're_tabindex'         => $_POST['re_tabindex'],
            're_comments'         => $_POST['re_comments'],
            're_registration'     => $_POST['re_registration'],
            're_contact_form_7'   => $_POST['re_contact_form_7'],
            're_xhtml'            => $_POST['re_xhtml'],
            'error_blank'         => $_POST['error_blank'],
            'error_incorrect'     => $_POST['error_incorrect'],
            'error_blank_cf7'     => preg_replace($pattern,$substitute,$_POST['error_blank']),
            'error_incorrect_cf7' => preg_replace($pattern,$substitute,$_POST['error_incorrect']),
        );
        // save updated options
        if ($wpmu == 1)
            update_site_option('adcopy', $optionarray_update);
        else
            update_option('adcopy', $optionarray_update);
    }

    /* Get options */
    if ($wpmu == 1)
        $optionarray_def = get_site_option('adcopy');
    else
        $optionarray_def = get_option('adcopy');

/* =============================================================================
   solvemedia Admin Page and Functions
   ============================================================================= */

/*
 * Display an HTML <select> listing the capability options for disabling security
 * for registered users.
 * @param string $select_name slug to use in <select> id and name
 * @param string $checked_value selected value for dropdown, slug form.
 * @return NULL
 */

function adcopy_dropdown_capabilities($select_name, $checked_value="") {
    // define choices: Display text => permission slug
    $capability_choices = array (
        'All registered users' => 'read',
        'Edit posts' => 'edit_posts',
        'Publish Posts' => 'publish_posts',
        'Moderate Comments' => 'moderate_comments',
        'Administer site' => 'level_10'
    );
    // print the <select> and loop through <options>
    echo '<select name="' . $select_name . '" id="' . $select_name . '">' . "\n";
    foreach ($capability_choices as $text => $capability) {
        $checked = $capability == $checked_value ? ' selected="selected" ' : '';
        echo '\t <option value="' . $capability . '"' . $checked . ">$text</option> \n";
    }
    echo "</select> \n";
} // end solvemedia_dropdown_capabilities()
?>

<!-- ############################## BEGIN: ADMIN OPTIONS ################### -->
<div class="wrap">
	<h2>Solve Media Options</h2>
	<h3>About Solve Media</h3>
	<p>Solve Media's puzzles offer a free, accessible service that helps block spam on your blog.</p>

	<p>For details, visit the <a href="http://www.solvemedia.com/">Solve Media website</a>.</p>
	<p><strong>NOTE</strong>: If you are using some form of Cache plugin you will probably need to flush/clear your cache for changes to take effect.</p>

	<form name="form1" method="post" action="<?php echo $_SERVER['REDIRECT_SCRIPT_URI'] . '?page=' . plugin_basename(__FILE__); ?>&updated=true">
		<div class="submit">
			<input type="submit" name="submit" value="<?php _e('Update Options') ?> &raquo;" />
		</div>

	<!-- ****************** Operands ****************** -->
		<table class="form-table">
			<tr valign="top">
			<th scope="row">Solve Media Keys</th>
				<td>
					Solve Media requires an API key, consisting of a "public", "private", and "hash" key. You can sign up for a <a href="<?php echo solvemedia_get_signup_url (adcopy_wp_blog_domain (), 'wordpress');?>" target="0">free Solve Media API key set</a>.
					<br />
					<p class="re-keys">
						<!-- solvemedia public key -->
						<label class="which-key" for="adcopy_opt_pubkey">Public Key:</label>
						<input name="adcopy_opt_pubkey" id="adcopy_opt_pubkey" size="40" value="<?php  echo $optionarray_def['pubkey']; ?>" />
						<br />
						<!-- solvemedia private key -->
						<label class="which-key" for="adcopy_opt_privkey">Private Key:</label>
						<input name="adcopy_opt_privkey" id="adcopy_opt_privkey" size="40" value="<?php  echo $optionarray_def['privkey']; ?>" />
						<br />
						<!-- solvemedia hash key -->
						<label class="which-key" for="adcopy_opt_hashkey">Hash Key:</label>
						<input name="adcopy_opt_hashkey" id="adcopy_opt_hashkey" size="40" value="<?php  echo $optionarray_def['hashkey']; ?>" />
					</p>
				</td>
			</tr>
			<tr valign="top">
			<th scope="row">Comment Options</th>
				<td>
					<!-- Show solvemedia on the comment post -->
					<big><input type="checkbox" name="re_comments" id="re_comments" value="1" <?php if($optionarray_def['re_comments'] == true){echo 'checked="checked"';} ?> /> <label for="re_comments">Enable Solve Media puzzles for comments.</label></big>
					<br />
					<!-- Don't show solvemedia to admins -->
					<div class="theme-select">
						<input type="checkbox" id="re_bypass" name="re_bypass" <?php if($optionarray_def['re_bypass'] == true){echo 'checked="checked"';} ?>/>
						<label name="re_bypass" for="re_bypass">Hide Solve Media puzzles for <strong>registered</strong> users who can:</label>
						<?php adcopy_dropdown_capabilities('re_bypasslevel', $optionarray_def['re_bypasslevel']); // <select> of capabilities ?>
					</div>

					<!-- The theme selection -->
					<div class="theme-select">
						<label for="re_theme">Theme:</label>
						<select name="re_theme" id="re_theme">
							<option value="white" <?php if($optionarray_def['re_theme'] == 'white'){echo 'selected="selected"';} ?>>White</option>
							<option value="red" <?php if($optionarray_def['re_theme'] == 'red'){echo 'selected="selected"';} ?>>Red</option>
							<option value="black" <?php if($optionarray_def['re_theme'] == 'black'){echo 'selected="selected"';} ?>>Black</option>
							<option value="purple" <?php if($optionarray_def['re_theme'] == 'purple'){echo 'selected="selected"';} ?>>Purple</option>
						</select>
					</div>
					<!-- Tab Index -->
					<label for="re_tabindex">Tab Index (<em>e.g. WP: <strong>5</strong>, WPMU: <strong>3</strong></em>):</label>
					<input name="re_tabindex" id="re_tabindex" size="5" value="<?php  echo $optionarray_def['re_tabindex']; ?>" />
					<br />
					<?php global $wpmu; if ($wpmu == 1 || $wpmu == 0) { ?>
				</td>
			</tr>
			<tr valign="top">
			<th scope="row">Registration Options</th>
				<td>
					<!-- Show solvemedia on the registration page -->
					<big><input type="checkbox" name="re_registration" id="re_registration" value="1" <?php if($optionarray_def['re_registration'] == true){echo 'checked="checked"';} ?> /> <label for="re_registration">Enable Solve Media puzzles on registration form.</label></big>
					<br />
					<!-- The theme selection -->
					<div class="theme-select">
						<label for="re_theme_reg">Theme:</label>
						<select name="re_theme_reg" id="re_theme_reg">
							<option value="white" <?php if($optionarray_def['re_theme_reg'] == 'white'){echo 'selected="selected"';} ?>>White</option>
							<option value="red" <?php if($optionarray_def['re_theme_reg'] == 'red'){echo 'selected="selected"';} ?>>Red</option>
							<option value="black" <?php if($optionarray_def['re_theme_reg'] == 'black'){echo 'selected="selected"';} ?>>Black</option>
							<option value="purple" <?php if($optionarray_def['re_theme_reg'] == 'purple'){echo 'selected="selected"';} ?>>Purple</option>
						</select>
					</div>
				</td>
			</tr>
			<tr valign="top">
			<th scope="row">Contact Form 7 Options</th>
				<td>
					<!-- Show solvemedia on a Contact Form 7 contact form -->
					<big><input type="checkbox" name="re_contact_form_7" id="re_contact_form_7" value="1" <?php if($optionarray_def['re_contact_form_7'] == true){echo 'checked="checked"';} ?> /> <label for="re_contact_form_7">Enable Solve Media puzzles on Contact Form 7 forms.</label></big>
					<br />
					<!-- The theme selection -->
					<div class="theme-select">
						<label for="re_theme_cf7">Theme:</label>
						<select name="re_theme_cf7" id="re_theme_cf7">
							<option value="white" <?php if($optionarray_def['re_theme_cf7'] == 'white'){echo 'selected="selected"';} ?>>White</option>
							<option value="red" <?php if($optionarray_def['re_theme_cf7'] == 'red'){echo 'selected="selected"';} ?>>Red</option>
							<option value="black" <?php if($optionarray_def['re_theme_cf7'] == 'black'){echo 'selected="selected"';} ?>>Black</option>
							<option value="purple" <?php if($optionarray_def['re_theme_cf7'] == 'purple'){echo 'selected="selected"';} ?>>Purple</option>
						</select>
					</div>
					<?php } ?>
				</td>
			</tr>
			<tr valign="top">
			<th scope="row">Error Messages</th>
				<td>
					<p>The following are the messages to display when the user does not enter a CAPTCHA response or enters the incorrect CAPTCHA response.</p>
					<!-- Error Messages -->
					<p class="re-keys">
						<!-- Blank -->
						<label class="which-key" for="error_blank">No response entered:</label>
						<input name="error_blank" id="error_blank" size="80" value="<?php echo $optionarray_def['error_blank']; ?>" />
						<br />
						<!-- Incorrect -->
						<label class="which-key" for="error_incorrect">Incorrect response entered:</label>
						<input name="error_incorrect" id="error_incorrect" size="80" value="<?php echo $optionarray_def['error_incorrect']; ?>" />
					</p>
				</td>
			</tr>
			<tr valign="top">
			<th scope="row">General Settings</th>
				<td>
					<!-- The language selection -->
					<div class="lang-select">
						<label for="re_lang">Language:</label>
						<select name="re_lang" id="re_lang">
							<option value="en" <?php if($optionarray_def['re_lang'] == 'en'){echo 'selected="selected"';} ?>>English</option>
							<option value="de" <?php if($optionarray_def['re_lang'] == 'de'){echo 'selected="selected"';} ?>>German</option>
							<option value="fr" <?php if($optionarray_def['re_lang'] == 'fr'){echo 'selected="selected"';} ?>>French</option>
							<option value="es" <?php if($optionarray_def['re_lang'] == 'es'){echo 'selected="selected"';} ?>>Spanish</option>
							<option value="it" <?php if($optionarray_def['re_lang'] == 'it'){echo 'selected="selected"';} ?>>Italian</option>
							<option value="yi" <?php if($optionarray_def['re_lang'] == 'yi'){echo 'selected="selected"';} ?>>Yiddish</option>
						</select>
				    	</div>
				    	<!-- Whether or not to be XHTML 1.0 Strict compliant -->
					<input type="checkbox" name="re_xhtml" id="re_xhtml" value="1" <?php if($optionarray_def['re_xhtml'] == true){echo 'checked="checked"';} ?> /> <label for="re_xhtml">Be XHTML 1.0 Strict compliant. <strong>Note</strong>: Bad for users who don't have Javascript enabled in their browser (Majority do).</label>
					<br />
				</td>
			</tr>
		</table>
		<div class="submit">
			<input type="submit" name="submit" value="<?php _e('Update Options') ?> &raquo;" />
		</div>

	</form>
		<p class="copyright">&copy; Copyright 2010&nbsp;&nbsp;<a href="http://www.solvemedia.com">Solve Media, Inc.</a>, etal.</p>
</div> <!-- [wrap] -->
<!-- ############################## END: ADMIN OPTIONS ##################### -->

<?php
}

/* =============================================================================
   Apply the admin menu
============================================================================= */

add_action('admin_menu', 'adcopy_wp_add_options_to_admin');

if ( !($adcopy_opt ['pubkey'] && $adcopy_opt['privkey'] ) && !isset($_POST['submit']) ) {
    function adcopy_warning() {
        global $wpmu;

        $path = plugin_basename(__FILE__);
        echo <<<API_KEY_WARNING
            <div id='adcopy-warning' class='updated fade-ff0000'><p><strong>The Solve Media plugin is not active.</strong> You must <a href='options-general.php?page=$path'>enter your Solve Media API keys</a> for it to work</p></div>
            <style type='text/css'>
                #adminmenu { margin-bottom: 5em; }
            </style>
API_KEY_WARNING;
    }

    if (($wpmu == 1 && is_site_admin()) || $wpmu != 1)
        add_action('admin_footer', 'adcopy_warning');

    return;
}



/* =============================================================================
   End Apply the admin menu
============================================================================= */

/* =============================================================================
   Tag generator for Contact Form 7
============================================================================= */

/* Tag generator */
if (function_exists(wpcf7_add_tag_generator))
    add_action( 'admin_init', 'wpcf7_add_tag_generator_solvemedia', 15 );

function wpcf7_add_tag_generator_solvemedia() {
    wpcf7_add_tag_generator( 'solvemedia', __( 'Solve Media Puzzle', 'wpcf7' ),
                             'wpcf7-tg-pane-solvemedia', 'wpcf7_tg_pane_solvemedia' );
}

function wpcf7_tg_pane_solvemedia() {
    $type = 'solvemedia';
?>
<div id="wpcf7-tg-pane-<?php echo $type; ?>" class="hidden">
	<form action="">
		<table>
			<tr><td><?php echo esc_html( __( 'Name', 'wpcf7' ) ); ?><br /><input type="text" name="name" class="tg-name oneline" /></td><td></td></tr>
		</table>
		<div class="tg-tag"><?php echo esc_html( __( "Copy this code and paste it into the form left.", 'wpcf7' ) ); ?><br /><input type="text" name="<?php echo $type; ?>" class="tag" readonly="readonly" onfocus="this.select()" /></div>
	</form>
</div>
<?php
}

/* =============================================================================
   End of Tag generator for Contact Form 7
============================================================================= */
?>
