<?php

/*
Plugin Name: Kontera ContentLink
Plugin URI: http://www.kontera.com
Description: This plugin will add your Kontera JavaScript code to your blog
Version: 1.0 
Author: Kontera
Author URI: http://www.kontera.com

////////////////////////////////
Kontera Plug-In License Agreement
////////////////////////////////

This Kontera Plug-In License Agreement (“Agreement’) is a legal agreement between you (“Publisher”) and Kontera
Technologies, Inc. (“Kontera”). YOU MUST READ AND AGREE TO THE TERMS OF THIS AGREEMENT
BEFORE YOU CAN IMPLEMENT AND BEGIN USING THE KONTERA PLUG-IN. BY USING, REPRODUCING
OR MODIFYING THE KONTERA PLUG-IN IN ANY WAY, YOU HEREBY AGREE TO THE TERMS AND
CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE WITH THE TERMS AND CONDITIONS OF
THIS AGREEMENT, THEN YOU SHOULD NOT USE, REPRODUCE, MODIFY THE KONTERA PLUG-IN IN
ANY WAY.
1. Definitions.
1.1. “Kontera Plug-In” means the plug-in that facilitates Publisher’s implementation of tags on the Publisher
Webpages.
1.2. “Publisher Web Pages” means all of the web pages in the domain(s) owned or controlled by Publisher.
2. Kontera Plug-In License.
2.1. Grant. Subject to the terms and conditions of this Agreement, Kontera grants to Publisher a nonsublicensable,
non-exclusive, non-transferable license to use, reproduce and modify the Kontera Plug-In but
solely on the Publisher Web Pages.
2.2. Restrictions and Ownership. Publisher shall not: (i) use the Kontera Plug-In for the purposes of developing a
product that will be owned by a third party or that would compete with Kontera’s products or services;
(ii) sublicense, rent, lend, lease, permit third party access to, or use of, the Kontera Plug-In; (iii) copy,
distribute, reproduce, sell, use or allow access to the Kontera Plug-In, except as explicitly permitted under this
Agreement; or (iv) remove, obscure, or alter Kontera’s copyright notice, trademarks, or other proprietary rights
notices affixed to or contained within the Kontera Plug-In. As between the parties, except for the explicit
license granted herein, Kontera, or its licensors, shall retain all right, title and interest in and to the Kontera
Plug-In. This is license, not a sale, so title to the Kontera Plug-In shall not pass to Publisher under any
circumstances. Kontera does not grant to Publisher any license, express or implied, under the intellectual
property of Kontera or its licensors except as expressly stated in this Agreement.
3. Confidentiality. “Confidential Information” means any information disclosed by Kontera to Publisher, either
directly or indirectly in writing, orally or by inspection of tangible objects which is either (i) designated or marked
as “Confidential” at the time of disclosure, or (ii) disclosed under circumstances reasonably indicating that such
information is confidential. Without limiting the foregoing, the Kontera Plug-In, all information relating to the
Kontera Plug-In, and the terms and conditions of this Agreement shall be deemed the Confidential Information of
Kontera. During the term of this Agreement and for three (3) years following the expiration or termination of this
Agreement, (A) Publisher agrees that it shall not use any Confidential Information other than as expressly permitted
under the terms of this Agreement or as expressly authorized in writing by Kontera, (B) Publisher shall use the same
degree of care to protect Confidential Information as it uses to protect its own most highly confidential information,
but in no circumstances less than reasonable care, and (C) Publisher shall not disclose Confidential Information to
any person or entity other than its officers, employees and consultants who need access to such Confidential
Information in order to effect the intent of this Agreement and who have entered into written confidentiality
agreements with it consistent with this Section 3.
4. Term and Termination. Unless earlier terminated as set forth herein, this Agreement is effective from the Effective
Date through the first anniversary of the Effective Date. After such time, this Agreement will automatically renew
for successive twelve (12) month terms unless either party notifies the other party that such party will not renew the
Agreement within thirty (30) days of the end of the then-current term. Either party may terminate this Agreement for
any reason or for no reason at any time upon thirty (30) days notice to the other party. The following sections will
survive any expiration or termination of this Agreement: 2.2, 3, 4, 5, 6 and 7.
5. Disclaimer of Warranties. THE KONTERA PLUG IN IS PROVIDED “AS IS” AND WITHOUT
REPRESENTATIONS, WARRANTIES OR CONDITIONS, WHETHER EXPRESS, IMPLIED, STATUTORY
OR OUT OF A COURSE OF DEALING OR USAGE OF TRADE, INCLUDING BUT NOT LIMITED TO
IMPLIED WARRANTIES OR CONDITIONS OF MERCHANTABILITY, MERCHANTABLE QUALITY,
-2-
FITNESS FOR ANY PARTICULAR PURPOSE OR USE, NONINFRINGEMENT, QUALITY,
PRODUCTIVENESS OR CAPACITY, AND ALL SUCH WARRANTIES ARE HEREBY DISCLAIMED.
KONTERA, ITS SUPPLIERS, LICENSORS, AND PARTNERS DO NOT WARRANT THAT THE FUNCTIONS
OF THE KONTERA PLUG-IN WILL BE CORRECT, UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS
WILL BE CORRECTED, OR THAT THE KONTERA PLUG-IN IS FREE OF VIRUSES OR OTHER HARMFUL
COMPONENTS. KONTERA MAKES NO GUARANTEE REGARDING THE NUMBER, QUALITY, OR
CONTENT OF ANY ADVERTISEMENTS OR THE TIMING OF DELIVERY OF SUCH ADVERTISEMENTS
FOLLOWING USE OF THE KONTERA PLUG-IN. THE FOREGOING DISCLAIMER OF WARRANTY IS A
FUNDAMENTAL PART OF THE BASIS OF KONTERA’S BARGAIN HEREUNDER, AND THAT KONTERA
WOULD NOT ENTER INTO THIS AGREEMENT ABSENT SUCH DISCLAIMER.
6. Limitation of Liability. KONTERA SHALL NOT BE LIABLE FOR ANY CONSEQUENTIAL, INCIDENTAL,
INDIRECT, PUNITIVE, SPECIAL OR OTHER SIMILAR DAMAGES NOR FOR ANY LOSS OF PROFITS,
LOSS OF REVENUES, LOSS OF SAVINGS, LOSS OF CLIENTELE, LOSS OF USE OR LOSS OR
CORRUPTION OF DATA, WHETHER UNDER TORT, CONTRACT OR OTHER THEORIES OF RECOVERY,
EVEN IF SUCH PARTY WAS OR SHOULD HAVE BEEN AWARE OR WAS ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES, AND IN NO EVENT WILL EITHER PARTY’S LIABILITY ARISING
OUT OF THIS AGREEMENT FROM ANY CAUSE OF ACTION WHATSOEVER WILL EXCEED THE
AGGREGATE AMOUNTS ACTUALLY PAID UNDER THIS AGREEMENT BY KONTERA TO PUBLISHER
DURING THE THREE (3) MONTHS PRIOR TO THE DATE THE CAUSE OF ACTION AROSE.
7. Miscellaneous. This Agreement is the entire agreement between the parties on the subject matter hereof. No
amendment or modification hereof will be valid or binding upon the parties unless made in writing and signed by the
duly authorized representatives of both parties. The relationship of the parties hereunder is that of independent
contractors, and this Agreement will not be construed to imply that either party is the agent, employee, or joint
venturer of the other. In the event that any provision of this Agreement is held to be unenforceable, the Agreement
will continue in full force and effect without such provision and will be interpreted to reflect the original intent of
the parties. This Agreement will be governed by the law of the State of California, without regard to its conflict of
laws principles. The parties consent to the personal and exclusive jurisdiction of courts located in San Francisco,
California. Neither party may assign any of its rights or obligations under this Agreement without the prior written
consent of the other, except that either party may assign any of its rights and obligations under this Agreement
without consent of the other party in connection with any merger, consolidation, reorganization, sale of all or
substantially all of its assets related to this Agreement or other similar transaction. This Agreement shall inure to the
benefit of and shall be binding on each party’s permitted assignees, transferees and successors. Wavier by either
party of a breach of any provision of this Agreement or the failure by either party to exercise any right hereunder
will not operate or be construed to be a waiver of any subsequent breach of any right or as a waiver of any other
right. Except for the payment of fees hereunder, nonperformance of either party will be excused to the extent that
performance is rendered impossible by strike, fire, flood, earthquake, governmental acts or orders or restrictions, or
any other reason when failure to perform is beyond the reasonable control of the nonperforming party.

*/

//////start code///////

/**
 * Attempts to understand what page/category/post we view and determine
 * if the kontera javascript should or should not be injected here
 * @return boolean true if javascript should be injected
 */
function kontera_should_show() {
	// get disabled categories from user's settings
	$disabled_categories = get_option('kontera_disabled_categories');

	// loop through item's categories, if we are on a disabled category return false
	$categories = get_the_category();
	foreach ($categories as $cat) {
                $cat->cat_name = preg_replace('/&#038;/','&',$cat->cat_name);
                $cat->cat_name = preg_replace('/&amp;/','&',$cat->cat_name);
		if(!is_array($disabled_categories)){
			if($cat->cat_name == $disabled_categories){
				return false;
			}
		}else if (in_array($cat->cat_name, $disabled_categories)){
			return FALSE;
		}
	}
	return TRUE;
}

function is_page_enabled() {
	// get disabled pages from user's settings
	$disabled_pages = explode(',', get_option('kontera_disabled_pages'));

	// loop through item's pages, if we are on a disabled pages return false
        global $post;
        $current_page = $post->ID;
	if (isset ($current_page) == false) {
		return true;
	}
	foreach ($disabled_pages as $page) {
		if (is_numeric($page)) {
			if ($current_page == $page) {
				return false;
			}
		}
	}
	return TRUE;
}

/**
 * This function echoes the kontera javascript for the configured user
 */
function kontera_echo_javascript() {
	if (is_young_post() || !kontera_should_show() || !is_page_enabled() || get_option('toggle_kontera_tag') != "enable" || is_in_disable_interval())
		return;

	// get the user's settings
	$publisher_id = get_option('kontera_publisher_id');
	$ad_link_color = get_option('color_value','#0000ff');

	// inject the script to the page
?>	<!-- Kontera ContentLink -->
    <script type="text/javascript">
	var dc_UnitID = 14;
	var dc_PublisherID = <?php echo $publisher_id ?>;
	var dc_AdLinkColor = '<?php echo $ad_link_color ?>';
	var dc_isBoldActive = 'no';
	var dc_open_new_win = 'yes';
	var dc_adprod='ADL';
    </script>
    <script type="text/javascript" SRC="http://kona.kontera.com/javascript/lib/KonaLibInline.js"></script>
    <!-- Kontera ContentLink --><?php

}

/**
 * Adds the Kontera Settings menu to the Options page
 */
function kontera_menu() {
	add_options_page('Kontera Settings', 'Kontera Settings', 8, __FILE__, 'kontera_options_menu');
}

/**
 * Output the options menu page, including the form that updates the user's settings
 */
function kontera_options_menu() {
?>
    <div class="wrap">
    <h2> Kontera Settings </h2>

	<form method="post" action="">
	<p class="submit">
	<input type="submit" name="Submit" value="<?php _e('Update Options »') ?>" />
	</p>
	<?php

	echo '<table border="0">';
	// define plugin parameters and descriptions
	$parameters = array (
		'kontera_publisher_id' => 'Kontera Publisher ID',
		'kontera_disabled_pages' => 'Block ContenLink from pages <BR><font size="1" color="gray"> Be sure to separate page id numbers  with commas (e.g 23, 25, 1)</font>'
	);

	$checkBoxParameters = array (
		'limit_kontera_to_content' => 'Allow Kontera to show ads inside posts',
		'allow_kontera_on_comments' => 'Allow Kontera to show ads inside comments'
	);

	$isValidPublisherId = (preg_match('/^\d+$/', $_POST['kontera_publisher_id']));
	$isValidBlockDays = (preg_match('/^\d*$/', $_POST['from_date']));
	if ($_POST['action'] == 'update' && $isValidPublisherId && $isValidBlockDays) {

		foreach ($checkBoxParameters as $param => $desc) {
			update_option($param, $_POST[$param]);
		}
		update_option('kontera_publisher_id', $_POST['kontera_publisher_id']);
		update_option('kontera_disabled_pages', $_POST['kontera_disabled_pages']);
		update_option('toggle_kontera_tag', $_POST['toggle_kontera_tag']);
		update_option('run_ads_on_full_page', $_POST['run_ads_on_full_page']);
		update_option('from_date', $_POST['from_date']);
		update_option('to_date', $_POST['to_date']);
		update_option('color_value', $_POST['color_value']);
		update_option('kontera_disabled_categories', $_POST['kontera_disabled_categories']);
	}
	if ($_POST['action'] != 'update') {
		$isValidPublisherId = $isValidBlockDays = 1;
	}

	echo "<tr><td> $parameters[kontera_publisher_id] </td> <td> <input type='text' name='kontera_publisher_id' value='" . get_option('kontera_publisher_id') . "' /> </td>", (!$isValidPublisherId) ? "<td style=' color:red'>Please enter a valid publisher id</td>" : "", "</tr>";
	echo "<tr><td> $parameters[kontera_disabled_pages] </td> <td> <input type='text' name='kontera_disabled_pages' value='" . get_option('kontera_disabled_pages') . "' /> </td></tr>";
?>

	<script src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/kontera/palette.js" type="text/javascript"></script>
	<link href="<?php echo get_option('siteurl'); ?>/wp-content/plugins/kontera/palette.css" media="screen" rel="stylesheet" type="text/css" />
	<tr>
		<td>
			<label for="s_color">Select your ContentLink&trade; color:</label>
		</td>
		<td>
			<div style='width:30' id="color_preview_wrapper">
				<img id="pal_img" src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/kontera/pal.gif" width="16" height="16" alt="Open Palette" onclick="openPalette('color_preview')"/>
			</div>
			<div  id="color_preview" onclick="openPalette('color_preview')" style="color:<?php echo get_option('color_value','#0000ff') ?>;">ContentLink&trade;</div>
		</td>
		<td>
			<input  type="hidden" id="color_value" name="color_value" on_click="openPalette('color_preview')" type="text" value="<?php echo get_option('color_value',"#0000ff") ?>" />
        </td>
	</tr>
    <script type="text/javascript">
	</script>
<?php


	echo "<tr><td> Block ads on new posts for:  <BR> <font size='1' color='gray'> do not show ads on new posts for X days </font> </td> <td> <input type='text' name='from_date' value='" . get_option('from_date', 0) . "' /> days </td>", (!$isValidBlockDays) ? "<td style=' color:red'>Please enter a valid number of days</td>" : "", "</tr>";
?>


	<tr >
		<td> Block ContenLink from categories <BR><font size="1" color="gray"> To select more than one category hold &lt;Cntr&gt; and click each <br> option that you would like selected</font> 
		</td> 
		<td>
 			<select style="height:<?php echo min(160,20*sizeof(get_categories())); ?>px;" name="kontera_disabled_categories[]" multiple="true" size="10">
 <?php
	$categories = get_categories();	
	foreach (array_values($categories) as $cat) {
		$option = '<option value="' . $cat->cat_name . '" ';
		$disabled_categories_array = get_option('kontera_disabled_categories');
		if (!$disabled_categories_array) {
			$disabled_categories_array = array ();
		}
                $cat->cat_name = preg_replace('/&#038;/','&',$cat->cat_name);
                $cat->cat_name = preg_replace('/&amp;/','&',$cat->cat_name);
		$option .= (in_array($cat->cat_name, array_values($disabled_categories_array))) ? "selected='selected'" : "";
		$option .= " >";
		$option .= $cat->cat_name;
		$option .= '</option>';
		echo $option;
	}
?>
			</select>
		</td>
	</tr>
	
	<script>
	 function isUnsignedInteger(s) {
 	        return (s.toString().search(/^[0-9]+$/) == 0);
 	}
	</script>

	<tr height=30><td><input type='checkbox' id='runFullAds' name='run_ads_on_full_page' <?php if(get_option('run_ads_on_full_page','1'))  echo "checked"; ?>    onclick='toggleCheckBoxes()' >Show ads on full page </td></tr>

	<script> 
		function toggleCheckBoxes()
		{
			if(document.getElementById('runFullAds').checked == false)
			{
				document.getElementById('limit_kontera_to_content').disabled=false;
				document.getElementById('allow_kontera_on_comments').disabled=false;
			}else{
				document.getElementById('limit_kontera_to_content').disabled=true;
				document.getElementById('allow_kontera_on_comments').disabled=true;
			}
		}
	</script>
	<?php
	foreach ($checkBoxParameters as $param => $desc) {
		echo "<tr height=30><td>&nbsp;&nbsp;&nbsp;<input type='checkbox' id='$param' name='$param' value='1' " . (get_option($param) ? 'checked' : '') . (get_option('run_ads_on_full_page') ? 'disabled' : '') . "/> $desc </td></tr>";
	}
	?>
	<tr height=20><td></td></tr>
	<?php
	$toggle_tag = get_option('toggle_kontera_tag','enable');
	if ($toggle_tag == "disable") {
		echo "<tr  height=30><td><input type='radio' name='toggle_kontera_tag' value='disable' checked> Disable Kontera Ads</td>";
		echo "<td><input type='radio' name='toggle_kontera_tag' value='enable' >Enable Kontera Ads</td></tr>";
	} else {
		echo "<tr  height=30><td><input type='radio' name='toggle_kontera_tag' id='disableAds' value='disable'> Disable Kontera Ads</td>";
		echo "<td><input type='radio' name='toggle_kontera_tag' value='enable' checked> Enable Kontera Ads</td></tr>";
	}
	echo '</table>';
	// this is needed for some wordpress thing to show which parameters are we updating
	$page_options = implode(',', array_keys($parameters));
	?>

	<!-- palette hidden div -->
        <div id="palette">
        <h2 style="padding:0pt 20px 7px 0pt;">Choose link color</h2>
	<table id="swatches" cellpadding="0" cellspacing="0">
        <script type="text/javascript">
                createRows('5','14');
        </script>
	</table>
<img src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/kontera/pal_cancel.gif" border="0" width="48" height="15" style="float:left; padding: 5px 0 0 8px;"    onclick="pal_reset()" />
<img src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/kontera/pal_ok.gif" border="0" width="48" height="15" style="float:right;  padding: 5px 8px 0 0;" onclick="setVal()"/>

</div>

	
	<input type="hidden" name="page_options" value="<?php echo $page_options ?>" />
	<input type="hidden" name="action" value="update" />
	<BR>	
	<p class="submit">
	<input type="submit" name="Submit" value="<?php _e('Update Options »') ?>" />
	</p>
	</form>	
    </div>
    <?php

}

function is_young_post() {
	global $post;
	$disable_new_days = get_option('from_date');
	$new_post_date = time() - $disable_new_days * 86400;
	return mysql2date('U', $post->post_date) > $new_post_date;
}

function add_zone_tag($text) {
	return '<div class="KonaBody">' . $text . '</div>';
}

if (get_option('limit_kontera_to_content')) {
	add_filter('the_content', 'add_zone_tag');
}

if (get_option('allow_kontera_on_comments')) {
	add_filter('comment_text', 'add_zone_tag');
}

function is_in_disable_interval() {
	$to_date = get_option('to_date');
	$from_date = get_option('from_date');
	if (!strtotime($to_date) || !strtotime($from_date)) {
		return false;
	}
	$curtime = time();
	if ($curtime < strtotime($from_date))
		return false;
	if ($curtime > strtotime($to_date))
		return false;
	return true;
}
//----------------------------------------

// default settings and parameters

add_option('kontera_publisher_id', '1');
add_option('kontera_adlinkcolor', '0000ff');
add_option('kontera_disabled_categories', '');
add_option('kontera_disabled_pages', '');

add_action('admin_menu', 'kontera_menu');
add_action('wp_footer', 'kontera_echo_javascript');
?>
