<script type="text/javascript">
function confirm_reset() {
  var answer = confirm("<?php _e('All of your custom messages will also be reset.  Are you sure you want to reset all settings?', $this->name); ?>");
  if(answer)
    return true;
  else
    return false;
}

jQuery(document).ready(function($){
  $("#enable_related_post").click(function(e){
    if($(this).is(':checked')){
      $("#wpgb_related_post_options").slideDown();
      $(this).attr("checked",true);
    }
    else{
      $("#wpgb_related_post_options").slideUp();
      $(this).attr("checked",false);
    }
  });

  $("#wpgb_options_toggle_advanced").click(function(e){
    e.preventDefault();
    state = $(this).attr("state");
    if(state == "visible"){
      $("#wpgb_advanced_options").slideUp();
      $("#wpgb_options_reset").fadeOut();
      $(this).attr("state", "hidden");
      $(this).attr("value", "Show Advanced Options" + String.fromCharCode(187));
      $.ajax({
        type    : "POST",
        url     : "admin-ajax.php",
        data    : { action : "wpgb", _ajax_nonce: "<?php echo $this->get_nonce(); ?>", wpgb_action : "hide_advanced_options" },
        success : function(resp){
          // do nothing visually
        },
        error   : function(resp){
          alert("Error:" + resp);
        }
      });
    }
    else{
      $("#wpgb_advanced_options").slideDown();
      $("#wpgb_options_reset").fadeIn();
      $(this).attr("state", "visible");
      $(this).attr("value", "Hide Advanced Options" + String.fromCharCode(187));
      $.ajax({
        type    : "POST",
        url     : "admin-ajax.php",
        data    : { action : "wpgb", _ajax_nonce: "<?php echo $this->get_nonce(); ?>", wpgb_action : "show_advanced_options" },
        success : function(resp){
          // do nothing visually
        },
        error   : function(resp){
          alert("Error:" + resp);
        }
      });
    }
  });
});
</script>
<?php
  $wpgb_options = get_option($this->name);

  if ($wpgb_options['show_link']) {
    $show_link_check1 = 'checked';
    $show_link_check2 = '';
  }
  else {
    $show_link_check1 = '';
    $show_link_check2 = 'checked';
  }

  if ($wpgb_options['allow_self_refer'])
    $allow_self_refer_check = 'checked';
  else
    $allow_self_refer_check = '';

  if ($wpgb_options['open_related'])
    $open_related_check = 'checked';
  else
    $open_related_check = '';

  if ($wpgb_options['show_post'])
    $show_post_check = 'checked';
  else
    $show_post_check = '';

  if ($wpgb_options['show_page'])
    $show_page_check = 'checked';
  else
    $show_page_check = '';

  if ($wpgb_options['can_close'])
    $can_close_check = 'checked';
  else
    $can_close_check = '';
    
  if ($wpgb_options['show_related']) {
    $show_related_check = 'checked';
    $show_related_style = 'block';
  }
  else {
    $show_related_check = '';
    $show_related_style = 'none';
  }
    
  if ($wpgb_options['show_related_excerpt'])
    $show_related_excerpt_check = 'checked';
  else
    $show_related_excerpt_check = '';
    
  if ($wpgb_options['position'] == 'after') {
    $position_opt1 = '';
    $position_opt2 = 'selected';
  }
  else {
    $position_opt1 = 'selected';
    $position_opt2 = '';
  }

  if ($wpgb_options['related_position'] == 'after') {
    $related_position_opt1 = '';
    $related_position_opt2 = 'selected';
  }
  else {
    $related_position_opt1 = 'selected';
    $related_position_opt2 = '';
  }

  if ($wpgb_options['show_advanced_options']) {
    $advanced_style = 'style="display:inline"';
    $advanced_toggle_text = __('Hide', $this->name);
    $advanced_toggle_state = 'visible';
  }
  else {
    $advanced_style = 'style="display:none"';
    $advanced_toggle_text = __('Show', $this->name);
    $advanced_toggle_state = 'hidden';
  }

  if ($wpgb_options['cache_compatible'])
    $cache_compatible_check = 'checked';
  else
    $cache_compatible_check = '';

  if ($wpgb_options['enable_css'])
    $enable_css_check = 'checked';
  else
    $enable_css_check = '';

  if ($wpgb_options['enable_js'])
    $enable_js_check = 'checked';
  else
    $enable_js_check = '';

  echo(
    '<form method="post">'
  );
  wp_nonce_field($this->name);
  echo(
      '<fieldset class="wpgb_fieldset wpgb_fieldset_alt">'.
        '<h2>'.__('Support this plugin!', $this->name).'</h2>'.
        '<p><label>'.
          __('Display "Powered by WP Greet Box" link at the bottom right corner of the greeting message', $this->name).' &nbsp;'.
          '<input name="wpgb_options_general[show_link]" value="on" type="radio" '.$show_link_check1.'/>'.
        '</label></p>'.
        '<p><label>'.
          __('Do not display "Powered by WP Greet Box" link.  I will <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_xclick&business=thaya.kareeson@gmail.com&currency_code=USD&amount=&return=&item_name=Donate+a+cup+of+coffee+or+two+to+support+WP+Greet+Box+plugin.">donate</a> and/or write about this plugin', $this->name).' &nbsp;'.
          '<input name="wpgb_options_general[show_link]" value="off" type="radio" '.$show_link_check2.'/>'.
        '</label></p>'.
        '<h2>'.__('General Configuration', $this->name).'</h2>'.
        '<p><label>'.
          __('Automatically show greeting message on posts', $this->name).' &nbsp;'.
          '<input name="wpgb_options_general[show_post]" type="checkbox" '.$show_post_check.'/> &nbsp;'.
          '('.__('uncheck for', $this->name).' <a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']).'&wpgb-page=documentation">'.__('manual insertion', $this->name).'</a>)'.
        '</label></p>'.
        '<p><label>'.
          __('Automatically show greeting message on pages', $this->name).' &nbsp;'.
          '<input name="wpgb_options_general[show_page]" type="checkbox" '.$show_page_check.'/> &nbsp;'.
          '('.__('uncheck for', $this->name).' <a href="'.preg_replace('/&wpgb-page=[^&]*/', '', $_SERVER['REQUEST_URI']) . '&wpgb-page=documentation">'.__('manual insertion', $this->name).'</a>)'.
        '</label></p>'.
        '<p><label>'.__('Allow users to close the greeting message', $this->name).' &nbsp;<input name="wpgb_options_general[can_close]" type="checkbox" '.$can_close_check.'/></label></p>'.
        '<p><label>'.__('Position greeting message', $this->name).' &nbsp;'.
        '<select name="wpgb_options_general[position]">'.
          '<option value="before" '.$position_opt1.'>'.__('before', $this->name).'</option>'.
          '<option value="after" '.$position_opt2.'>'.__('after', $this->name).'</option>'.
        '</select>'.
        '&nbsp '.__('the post/page.', $this->name).'</label></p>'.
        '<h2>'.__('Related Post Options', $this->name).'</h2>'.
        '<p><label>'.
          __('Detect keywords from search engines referrers and display related posts', $this->name).' &nbsp;'.
          '<input id="enable_related_post" name="wpgb_options_general[show_related]" type="checkbox" '.$show_related_check.'/> &nbsp;'.
        '</label></p>'.
        '<span id="wpgb_related_post_options" style="display:'.$show_related_style.'">'.
        '<p><label>'.
          __('Position related posts', $this->name).' <select name="wpgb_options_general[related_position]">'.
          '<option value="before" '.$related_position_opt1.'>'.__('before', $this->name).'</option>'.
          '<option value="after" '.$related_position_opt2.'>'.__('after', $this->name).'</option>'.
          '</select>'.__('the greeting message.', $this->name).
        '</label></p>'.
        '<p><label>'.
          __('Show post excerpt in related posts', $this->name).' <input name="wpgb_options_general[show_related_excerpt]" type="checkbox" '.$show_related_excerpt_check.'/>'.
        '</label></p>'.
        '<p><label>'.
          __('Expand related posts by default', $this->name).' <input name="wpgb_options_general[open_related]" type="checkbox" '.$open_related_check.'/>'.
        '</label></p>'.
        '<p><label>'.
          __('Limit related posts to ', $this->name).' <input name="wpgb_options_general[related_limit]" id="related-limit" type="text" class="wpgreetbox-focusable" size="5" value="'.attribute_escape($wpgb_options['related_limit']).'"/> '.__('posts', $this->name).
        '</label></p>'.
        '<p><label>'.__('Limit related post excerpts to', $this->name).' <input name="wpgb_options_general[related_excerpt_len]" id="related-excerpt-len" type="text" class="wpgreetbox-focusable" size="5" value="'.attribute_escape($wpgb_options['related_excerpt_len']).'"/> '.__('words', $this->name).
        '</label></p>'.
        '</span>'.
        '<div id="wpgb_advanced_options" '.$advanced_style.' >'.
          '<h2>'.__('Advanced Options', $this->name).'</h2>'.
          '<p>'.
            '<label>'.__('Enable compatibility with cache plugins', $this->name).' <input name="wpgb_options_general[cache_compatible]" id="cache-compatible" type="checkbox" '.$cache_compatible_check.' /> ('.__('If check, WP Greet Box will use Javascript to load the greeting message', $this->name).')</label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('Enable', $this->name).' css/wp-greet-box.css <input name="wpgb_options_general[enable_css]" id="enable-css" type="checkbox" '.$enable_css_check.' /> ('.__('uncheck to manually manage your own CSS', $this->name).')</label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('Enable', $this->name).' js/functions.js '.__('and', $this->name).' js/onload.js <input name="wpgb_options_general[enable_js]" id="enable-js" type="checkbox" '.$enable_js_check.' /> ('.__('uncheck to manually manage your own JS', $this->name).')</label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('Allow self referral to trigger greet box', $this->name).' <input name="wpgb_options_general[allow_self_refer]" type="checkbox" '.$allow_self_refer_check.' /></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('Your RSS feed URL. (replaces [[rss-link]] in greeting messages with this)', $this->name).'<br/>'.
            '<input name="wpgb_options_general[rss_link]" id="rss-url" type="text" class="wpgreetbox-focusable" size="60" value="'.attribute_escape($wpgb_options['rss_link']).'"/></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('Your "Subscribe via Email" URL. (replaces [[email-link]] in greeting messages this)', $this->name).'<br/>'.
            '<input name="wpgb_options_general[email_link]" id="email-url" type="text" class="wpgreetbox-focusable" size="60" value="'.attribute_escape($wpgb_options['email_link']).'"/></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display before the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[before_greet]" id="before-greet" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['before_greet']).'</textarea></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display after the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[after_greet]" id="after-greet" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['after_greet']).'</textarea></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display before the image in the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[before_icon]" id="before-icon" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['before_icon']).'</textarea></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display after the image in the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[after_icon]" id="after-icon" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['after_icon']).'</textarea></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display before the text in the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[before_text]" id="before-text" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['before_text']).'</textarea></label>'.
          '</p>'.
          '<p>'.
            '<label>'.__('HTML code to display after the text in the greeting box.', $this->name).'<br/>'.
            '<textarea name="wpgb_options_general[after_text]" id="after-text" class="wpgreetbox-focusable widefat" rows="2">'.attribute_escape($wpgb_options['after_text']).'</textarea></label>'.
          '</p>'.
        '</div>'.
        '<p class="submit">'.
        '<input type="submit" name="wpgb_options_general_submit" value="'.__('Update Options', $this->name).' &#187;" />'
  );
  if(isset($_GET['debug']) && $_GET['debug'] > 0)
    echo(
        '<input type="submit" name="wpgb_options_upgrade" value="'.__('Upgrade Options', $this->name).' &#187;"/>'
    );  
  echo(
        '<input type="submit" id="wpgb_options_reset" name="wpgb_options_reset" value="'.__('Reset ALL Options', $this->name).' &#187;" onclick="return confirm_reset()" '.$advanced_style.'/>'.
        '<input type="button" id="wpgb_options_toggle_advanced" name="wpgb_options_toggle_advanced" state="'.$advanced_toggle_state.'" value="'.$advanced_toggle_text.' '.__('Advanced Options', $this->name).' &#187;"/>'.
        '</p>'.
        '</fieldset>'.
      '</form>'
  );
?>
