<?php
/*
License:
 ==============================================================================

    Copyright 2006  Dan Kuykendall  (email : dan@kuykendall.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-107  USA
*/

	if(!function_exists('getmicrotime')) {
		function getmicrotime() {
			list($usec, $sec) = explode(" ",microtime());
			return ((float)$usec + (float)$sec);
		}
	}

	function podPress_feedSafeContent($input, $aggressive = false)
	{
		GLOBAL $podPress;
		if(!$podPress->settings['protectFeed'] && !$aggressive) {
			return $input;
		}
		$result = htmlentities($input, ENT_NOQUOTES, 'UTF-8');
		if($aggressive) {
			//$result = unhtmlentities($result);
			$result = str_replace(array('&amp;', '&lt;', '&gt;', '&'), '', $result);
		}
		return $result;
	}

	/*
	function podPress_iTunesSafeContent($content) {
		$content = podPress_feedSafeContent($content);
		$content = unhtmlentities($content);
		$content = str_replace(array('&amp;', '&lt;', '&gt;', '&'), '', $content);
		return $content;
	}

	if(!function_exists('html_entity_decode_utf8')) {
		function html_entity_decode_utf8($string) {
			static $trans_tbl;
			$string = preg_replace('~&#x([0-9a-f]+);~ei', 'code2utf(hexdec("\\1"))', $string);
			$string = preg_replace('~&#([0-9]+);~e', 'code2utf(\\1)', $string);
			if (!isset($trans_tbl)) {
				$trans_tbl = array();       
				foreach (get_html_translation_table(HTML_ENTITIES) as $val=>$key) {
					$trans_tbl[$key] = utf8_encode($val);
				}
			}
			return strtr($string, $trans_tbl);
		}
	}

	if(!function_exists('code2utf')) {
		function code2utf($num) {
			if ($num < 128) return chr($num);
			if ($num < 2048) return chr(($num >> 6) + 192) . chr(($num & 63) + 128);
			if ($num < 65536) return chr(($num >> 12) + 224) . chr((($num >> 6) & 63) + 128) . chr(($num & 63) + 128);
			if ($num < 2097152) return chr(($num >> 18) + 240) . chr((($num >> 12) & 63) + 128) . chr((($num >> 6) & 63) + 128) . chr(($num & 63) + 128);
			return '';
		}
	}

	if(!function_exists('unhtmlentities')) {
		function unhtmlentities ($string) {
			$trans_tbl1 = get_html_translation_table (HTML_ENTITIES);
			foreach ( $trans_tbl1 as $ascii => $htmlentitie ) {
				$trans_tbl2[$ascii] = '&#'.ord($ascii).';';
			}
			$trans_tbl1 = array_flip ($trans_tbl1);
			$trans_tbl2 = array_flip ($trans_tbl2);
			return strtr (strtr ($string, $trans_tbl1), $trans_tbl2);
		}
	}
 */

	function podPress_WPVersionCheck($input = '2.0.0') {
		GLOBAL $wp_version;
		if(substr($wp_version, 0, 12) == 'wordpress-mu') {
			return true;
		}
		return ((float)$input <= (float) $wp_version);
	}

	function podPress_iTunesLink() {
		GLOBAL $podPress;
		echo $podPress->iTunesLink();
	}

	function podPress_siteurl($noDomain = false) {
		if (!defined('PODPRESSSITEURL') || $noDomain) {
			$result = '';
			$urlparts = parse_url(get_settings('siteurl'));
			if(!$noDomain) {
				if(empty($urlparts['scheme'])) {
					$urlparts['scheme'] = 'http';
				}
				$result .= $urlparts['scheme'].'://'.$_SERVER['HTTP_HOST'];
				if($urlparts['port'] != '' && $urlparts['port'] != '80') {
					$result .= ':'.$urlparts['port'];
				}
			}
			if(isset($urlparts['path'])) {
				$result .= $urlparts['path'];
			}

			if(substr($result, -1, 1) != '/') {
				$result .= '/';
			}

			if($urlparts['query'] != '') {
				$result .= '?'.$urlparts['query'];
			}
			if($urlparts['fragment'] != '') {
				$result .= '#'.$urlparts['fragment'];
			}
			if($noDomain) {
				return $result.'wp-content/plugins/';
			}
			define('PODPRESSSITEURL', $result.'wp-content/plugins/');
		}
		return PODPRESSSITEURL;
	}

	function podPress_url($noDomain = false) {
		if($noDomain) {
			if (!defined('PODPRESSURL')) {
				define('PODPRESSURL', podPress_siteurl($noDomain).'podpress/');
			}
			return PODPRESSURL;
		} else {
			$result = get_settings('siteurl');
			if(substr($result, -1, 1) != '/') {
				$result .= '/';
			}
			return $result.'wp-content/plugins/podpress/';
		}
	}

	function podPress_getFileExt($str)
	{
		$pos = strrpos($str, '.');
		$pos = $pos+1;
		return substr(strtolower($str), $pos);
	}

	function podPress_getFileName($str)
	{
		if(strrpos($str, '/')) {
			$pos = strrpos($str, '/');
			$pos = $pos+1;
			return substr($str, $pos);
		} else {
			return $str;
		}
	}

	function podPress_wordspaceing($txt, $number = '5', $paddingchar = ' ') {
		$txt_array = array();
		$len = strlen($txt);
		$count=$len/$number;

		$i="0";
		while($i<=$count) {
			if($i=="0") {$ib="0";} else {$ib=($i*$number)+1;}
			$txt_array[$i]=substr($txt,$ib,$number);
			$i++;
		}

		$count_array=count($txt_array)-1; $i="0";
		while ($i<=$count_array) {
			if ($i=="0") {$txt=$txt_array[$i].$paddingchar; } else {$txt .=''.$txt_array[$i].' ';}
			$i++;
		}
		return $txt;
	}	
		
	function podPress_stringLimiter($str, $len)
	{
		if (strlen($str) > $len) {
			$len = $len-3;
			return substr($str, 0, $len).'...';
		} else {
			return $str;
		}
	}

	function podPress_StatsURL($url, $method) // valid methods are feed, player and web
	{
		$filename = podPress_getFileName($url);
		$b64 = base64_encode($url);
		$b64 = str_replace('=', '', $b64);
		return podPress_url().$method.'/'.$b64.'/'.$filename;
	}

	if(!function_exists('html_print_r')) {
		function html_print_r($v, $n = '', $ret = false) {
			if($ret) {
				ob_start();
			}	
			echo $n.'<pre>';
			print_r($v);
			echo '</pre>';
			if($ret) {
				$result = ob_get_contents();
				ob_end_clean();
				return $result;
			}
		}
	}

	if(!function_exists('comment_print_r')) {
		function comment_print_r($v, $n = '', $ret = false) {
			$result = "<!-- \n";
			$result .= html_print_r($v, $n, true);
			$result .= " -->\n";
			if($ret) {
				return $result;
			}
			echo $result;
		}
	}

	if(!function_exists('maybe_unserialize')) {
		function maybe_unserialize($original, $ss = false) {
			if($ss) {
				$original = stripslashes($original);
			}
			if ( false !== $gm = @ unserialize($original) ) {
				return $gm;
			} else {
				return $original;
			}
		}
	}

	if(!function_exists('isBase64')) {
		function isBase64($str)
		{
			$_tmp=preg_replace("/[^A-Z0-9\+\/\=]/i",'',$str);
			return (strlen($_tmp) % 4 == 0 ) ? true : false;
		}
	}

	function podPress_mimetypes($ext, $mp4_type = 'audio') {
		$ext = strtolower($ext);
		$ext_list = array (
			'jpg' => 'image/jpeg',
			'jpeg' => 'image/jpeg',
			'jpe' => 'image/jpeg',
			'gif' => 'image/gif',
			'png' => 'image/png',
			'bmp' => 'image/bmp',
			'tif' => 'image/tiff',
			'tiff' => 'image/tiff',
			'ico' => 'image/x-icon',
			'asf' => 'video/asf',
			'wmv' => 'video/wmv',
			'asx' => 'video/asf',
			'wax' => 'video/asf',
			'wmx' => 'video/asf',
			'avi' => 'video/avi',
			'qt' => 'video/quicktime',
			'mov' => 'video/quicktime',
			'm4v' => 'video/x-m4v',
			'mpeg' => 'video/mpeg',
			'mpg' => 'video/mpeg',
			'mpe' => 'video/mpeg',
			'txt' => 'text/plain',
			'c' => 'text/plain',
			'cc' => 'text/plain',
			'h' => 'text/plain',
			'rtx' => 'text/richtext',
			'css' => 'text/css',
			'htm' => 'text/html',
			'html' => 'text/html',
			'mp3' => 'audio/mpeg',
			'mp4' => $mp4_type.'/mpeg',
			'm4a' => 'audio/x-m4a',
			'aa' => 'audio/audible',
			'ra' => 'audio/x-realaudio',
			'ram' => 'audio/x-realaudio',
			'wav' => 'audio/wav',
			'ogg' => 'audio/ogg',
			'mid' => 'audio/midi',
			'midi' => 'audio/midi',
			'wma' => 'audio/wma',
			'rtf' => 'application/rtf',
			'js' => 'application/javascript',
			'pdf' => 'application/pdf',
			'doc' => 'application/msword',
			'pot' => 'application/vnd.ms-powerpoint',
			'pps' => 'application/vnd.ms-powerpoint',
			'ppt' => 'application/vnd.ms-powerpoint',
			'wri' => 'application/vnd.ms-write',
			'xla' => 'application/vnd.ms-excel',
			'xls' => 'application/vnd.ms-excel',
			'xlt' => 'application/vnd.ms-excel',
			'xlw' => 'application/vnd.ms-excel',
			'mdb' => 'application/vnd.ms-access',
			'mpp' => 'application/vnd.ms-project',
			'swf' => 'application/x-shockwave-flash',
			'class' => 'application/java',
			'tar' => 'application/x-tar',
			'zip' => 'application/zip',
			'gz' => 'application/x-gzip',
			'gzip' => 'application/x-gzip',
			'torrent' => 'application/x-bittorrent',
			'exe' => 'application/x-msdownload'
		);
		if(!isset($ext_list[$ext])) {
			return 'application/unknown';
		}
		return $ext_list[$ext];
	}
	
	/**************************************************************/
	/* Functions for supporting the backend processor */
	/**************************************************************/

	function podPress_ResolveReDirects($uriFileName)
	{
		GLOBAL $podPress;

		$tries = 0;
		while($tries < 5) {
			$tries++;
			$aURL = parse_url($uriFileName);
			if($aURL['scheme'] != 'http') {
				return;
			}
			$sHost = $aURL['host'];
			$sFilepath = (isset($aURL['path']) ? $aURL['path'] : '/') . (isset($aURL['query']) ? '?' . $aURL['query'] : '');
			$nPort = isset($aURL['port']) ? $aURL['port'] : 80;
			$fpRemote = @fsockopen($sHost, $nPort, $errno, $errstr, 30);
			// Make sure the socket is open
			if(!$fpRemote) {
				return;
			}
			// Request headers
			$sHeaders = "HEAD " . $sFilepath . " HTTP/1.1\r\n";
			$sHeaders .= "Host: ". $sHost . "\r\n";
			$sHeaders .= "Connection: Close\r\n\r\n";
			// Sending headers
			fwrite($fpRemote, $sHeaders);
			// Getting back the content
			$sRemoteHeaders = '';
			while(!feof($fpRemote)) {
				$sRemoteHeaders .= fgets($fpRemote, 128);
			}
			// Closing the socket
			fclose($fpRemote);
			// parse headers
			$crlf = "\r\n";
			$headers = array();
			$lines = explode($crlf, $sRemoteHeaders);
			foreach($lines as $line) {
				if(($pos = strpos($line, ':')) !== false) {
					$headers[strtolower(trim(substr($line, 0, $pos)))] = trim(substr($line, $pos+1));
				}
			}
     
			// redirection?
			if(isset($headers['location'])) {
				$uriFileName = $headers['location'];
			} else {
				return $uriFileName;
			}
		}
		return $uriFileName;
	}
	
	/**************************************************************/
	/* Functions for supporting the downloader */
	/**************************************************************/
	
	function podPress_StatCounter($postID, $media, $method) {
		global $wpdb;

		switch($method) {
			case 'feed':
			case 'web':
			case 'play':
				$sqlI = "INSERT INTO ".$wpdb->prefix."podpress_statcounts (postID, media, $method) VALUES ($postID, '$media', 1)";
				$sqlU = "UPDATE ".$wpdb->prefix."podpress_statcounts SET $method = $method+1, total = total+1 WHERE postID = '$postID' AND media = '$media'";
				$wpdb->hide_errors();
				$result = $wpdb->query($sqlI);
				if(!$result) {
					$wpdb->query($sqlU);
				}
				$wpdb->show_errors();
				break;
			default:
				return;
		}
	}
	
	function podPress_StatCollector($postID, $media, $method) {
		global $wpdb;

		$media	= addslashes($media);
		$method	= addslashes($method);

		$ip		= addslashes($_SERVER['REMOTE_ADDR']);
		//$cntry	= addslashes(podPress_determineCountry($ip));
		$cntry	= addslashes('');
		$lang	= addslashes(podPress_determineLanguage());
		$ref	= addslashes($_SERVER['HTTP_REFERER']);
		$url 	= parse_url($ref);
		$domain	= addslashes(eregi_replace('^www.','',$url['host']));
		//$res	= $_SERVER['REQUEST_URI'];
		$ua   = addslashes($_SERVER['HTTP_USER_AGENT']);
		$br		= podPress_parseUserAgent($_SERVER['HTTP_USER_AGENT']);
		$dt		= time();
	
		$query = "INSERT INTO ".$wpdb->prefix."podpress_stats (postID, media, method,remote_ip,country,language,domain,referer,user_agent,platform,browser,version,dt) 
				  VALUES ('$postID','$media','$method','".$ip."','$cntry','$lang','$domain','$ref','$ua','".addslashes($br['platform'])."','".addslashes($br['browser'])."','".addslashes($br['version'])."',$dt)";
		//echo '$query: '.$query."<br/>\n";
		$wpdb->query($query);
		return $wpdb->insert_id;
	}
	
	function podPress_determineCountry($ip) {
		$coinfo = @file('http://www.hostip.info/api/get.html?ip=' . $ip);
		$country_string = explode(':',$coinfo[0]);
		$country = trim($country_string[1]);

		if($country == '(Private Address) (XX)' 
		|| $country == '(Unknown Country?) (XX)' 
		|| $country == '' 
		|| !$country 
		  )return 'Indeterminable';
			
		return $country;
	}
	
	function podPress_parseUserAgent($ua) {
		$browser['platform']	= "Indeterminable";
		$browser['browser']		= "Indeterminable";
		$browser['version']		= "Indeterminable";
		$browser['majorver']	= "Indeterminable";
		$browser['minorver']	= "Indeterminable";
		
		// Test for platform
		if (eregi('Win95',$ua)) {
			$browser['platform'] = "Windows 95";
			}
		else if (eregi('Win98',$ua)) {
			$browser['platform'] = "Windows 98";
			}
		else if (eregi('Win 9x 4.90',$ua)) {
			$browser['platform'] = "Windows ME";
			}
		else if (eregi('Windows NT 5.0',$ua)) {
			$browser['platform'] = "Windows 2000";
			}
		else if (eregi('Windows NT 5.1',$ua)) {
			$browser['platform'] = "Windows XP";
			}
		else if (eregi('Windows NT 5.2',$ua)) {
			$browser['platform'] = "Windows 2003";
			}
		else if (eregi('Windows NT 6.0',$ua)) {
			$browser['platform'] = "Windows Longhorn beta";
			}
		else if (eregi('Windows',$ua)) {
			$browser['platform'] = "Windows";
			}
		else if (eregi('Mac OS X',$ua)) {
			$browser['platform'] = "Mac OS X";
			}
		else if (eregi('Macintosh',$ua)) {
			$browser['platform'] = "Mac OS Classic";
			}
		else if (eregi('Linux',$ua)) {
			$browser['platform'] = "Linux";
			}
		else if (eregi('BSD',$ua) || eregi('FreeBSD',$ua) || eregi('NetBSD',$ua)) {
		$browser['platform'] = "BSD";
			}
		else if (eregi('SunOS',$ua)) {
			$browser['platform'] = "Solaris";
			}

		// Test for browser type
		if (eregi('Mozilla/4',$ua) && !eregi('compatible',$ua)) {
			$browser['browser'] = "Netscape";
			eregi('Mozilla/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Mozilla/5',$ua) || eregi('Gecko',$ua)) {
			$browser['browser'] = "Mozilla";
			eregi('rv(:| )([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[2];
			}
		if (eregi('Safari',$ua)) {
			$browser['browser'] = "Safari";
			$browser['platform'] = "Mac OS X";
			eregi('Safari/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];

			if (eregi('412',$browser['version'])) {
				$browser['version'] 	= 2.0;
				$browser['majorver']	= 2;
				$browser['minorver']	= 0;
				}
			else if (eregi('312',$browser['version'])) {
				$browser['version'] 	= 1.3;
				$browser['majorver']	= 1;
				$browser['minorver']	= 3;
				}
			else if (eregi('125',$browser['version'])) {
				$browser['version'] 	= 1.2;
				$browser['majorver']	= 1;
				$browser['minorver']	= 2;
				}
			else if (eregi('100',$browser['version'])) {
				$browser['version'] 	= 1.1;
				$browser['majorver']	= 1;
				$browser['minorver']	= 1;
				}
			else if (eregi('85',$browser['version'])) {
				$browser['version'] 	= 1.0;
				$browser['majorver']	= 1;
				$browser['minorver']	= 0;
				}
			else if ($browser['version']<85) {
				$browser['version'] 	= "1.0 beta";
				}
			}
		if (eregi('iCab',$ua)) {
			$browser['browser'] = "iCab";
			eregi('iCab ([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Firefox',$ua)) {
			$browser['browser'] = "Firefox";
			eregi('Firefox/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Firebird',$ua)) {
			$browser['browser'] = "Firebird";
			eregi('Firebird/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Phoenix',$ua)) {
			$browser['browser'] = "Phoenix";
			eregi('Phoenix/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Camino',$ua)) {
			$browser['browser'] = "Camino";
			eregi('Camino/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Chimera',$ua)) {
			$browser['browser'] = "Chimera";
			eregi('Chimera/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Netscape',$ua)) {
			$browser['browser'] = "Netscape";
			eregi('Netscape[0-9]?/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('MSIE',$ua)) {
			$browser['browser'] = "Internet Explorer";
			eregi('MSIE ([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('MSN Explorer',$ua)) {
			$browser['browser'] = "MSN Explorer";
			eregi('MSN Explorer ([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('AOL',$ua)) {
			$browser['browser'] = "AOL";
			eregi('AOL ([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('America Online Browser',$ua)) {
			$browser['browser'] = "AOL Browser";
			eregi('America Online Browser ([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('K-Meleon',$ua)) {
			$browser['browser'] = "K-Meleon";
			eregi('K-Meleon/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Beonex',$ua)) {
			$browser['browser'] = "Beonex";
			eregi('Beonex/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Opera',$ua)) {
			$browser['browser'] = "Opera";
			eregi('Opera( |/)([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[2];
			}
		if (eregi('OmniWeb',$ua)) {
			$browser['browser'] = "OmniWeb";
			eregi('OmniWeb/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];

			if (eregi('563',$browser['version'])) {
				$browser['version'] 	= 5.1;
				$browser['majorver']	= 5;
				$browser['minorver']	= 1;
				}
			else if (eregi('558',$browser['version'])) {
				$browser['version'] 	= 5.0;
				$browser['majorver']	= 5;
				$browser['minorver']	= 0;
				}
			else if (eregi('496',$browser['version'])) {
				$browser['version'] 	= 4.5;
				$browser['majorver']	= 4;
				$browser['minorver']	= 5;
				}
			}
		if (eregi('Konqueror',$ua)) {
			$browser['platform'] = "Linux";
	
			$browser['browser'] = "Konqueror";
			eregi('Konqueror/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Galeon',$ua)) {
			$browser['browser'] = "Galeon";
			eregi('Galeon/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Epiphany',$ua)) {
			$browser['browser'] = "Epiphany";
			eregi('Epiphany/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Kazehakase',$ua)) {
			$browser['browser'] = "Kazehakase";
			eregi('Kazehakase/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('amaya',$ua)) {
			$browser['browser'] = "Amaya";
			eregi('amaya/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Crawl',$ua) || eregi('bot',$ua) || eregi('slurp',$ua) || eregi('spider',$ua)) {
			$browser['browser'] = "Crawler/Search Engine";
			}
		if (eregi('Lynx',$ua)) {
			$browser['browser'] = "Lynx";
			eregi('Lynx/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('Links',$ua)) {
			$browser['browser'] = "Links";
			eregi('\(([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		if (eregi('ELinks',$ua)) {
			$browser['browser'] = "ELinks";
			eregi('ELinks/([[:digit:]\.]+)',$ua,$b);
			$browser['version'] = $b[1];
			}
		
		// Determine browser versions
		if (($browser['browser']!='AppleWebKit' || $browser['browser']!='OmniWeb') && $browser['browser'] != "Indeterminable" && $browser['browser'] != "Crawler/Search Engine" && $browser['version'] != "Indeterminable") {
			// Make sure we have at least .0 for a minor version for Safari and OmniWeb
			$browser['version'] = (!eregi('\.',$browser['version']))?$browser['version'].".0":$browser['version'];
			
			eregi('^([0-9]*).(.*)$',$browser['version'],$v);
			$browser['majorver'] = $v[1];
			$browser['minorver'] = $v[2];
			}
		if (empty($browser['version']) || $browser['version']=='.0') {
			$browser['version']		= "Indeterminable";
			$browser['majorver']	= "Indeterminable";
			$browser['minorver']	= "Indeterminable";
			}
		
		return $browser;
	}
	
	function podPress_determineLanguage() {
		$lang_choice = "empty"; 
		if (isset($_SERVER["HTTP_ACCEPT_LANGUAGE"])) {
			// Capture up to the first delimiter (, found in Safari)
			preg_match("/([^,;]*)/",$_SERVER["HTTP_ACCEPT_LANGUAGE"],$langs);
			$lang_choice = $langs[0];
		}
		return $lang_choice;
	}
	
	function podPress_processDownloadRedirect($postID, $mediaNum, $filename, $method = '') {
		GLOBAL $podPress, $wpdb;
		$allowedMethods = array('feed', 'play', 'web');
		$realURL = false;
		$realSysPath = false;
		$statID = false;

		if(substr($filename, -20, 20) == 'podPressStatTest.txt') {
			echo 'Worked';
			exit;
		}

		if (in_array($method, $allowedMethods) && is_numeric($postID) && is_numeric($mediaNum)) {
			$mediaFiles = podPress_get_post_meta($postID, 'podPressMedia', true);
			if(isset($mediaFiles[$mediaNum])) {			
				if($mediaFiles[$mediaNum]['URI'] == urldecode($filename)) {
					$realURL = $filename;
				} elseif(podPress_getFileName($mediaFiles[$mediaNum]['URI']) == urldecode($filename)) {
					$realURL = $mediaFiles[$mediaNum]['URI'];
				} elseif(podPress_getFileName($mediaFiles[$mediaNum]['URI_torrent']) == urldecode($filename)) {
					$realURL = $mediaFiles[$mediaNum]['URI_torrent'];
				}
			}
		}			

		if(!$realURL) {
			header('X-PodPress-Location: '.get_settings('siteurl'));
			header('Location: '.get_settings('siteurl'));
			exit;
		}
		$badextensions = array('.smi', '.jpg', '.png', '.gif');
		if($filename && !in_array(strtolower(substr($filename, -4)), $badextensions)) {
			podPress_StatCounter($postID, $filename, $method);
			if($podPress->settings['statLogging'] == 'Full' || $this->settings['statLogging'] == 'FullPlus') {
				$statID = podPress_StatCollector($postID, $filename, $method);
			}
		}
		
		$realSysPath = $podPress->convertPodcastFileNameToSystemPath(str_replace('%20', ' ', $realURL));
		$realURL = $podPress->convertPodcastFileNameToValidWebPath($realURL);

		if($podPress->settings['enablePodTracStats']) {
			$realURL = str_replace(array('ftp://', 'http://', 'https://'), '', $realURL);
			$realURL = $podPress->podtrac_url.$realURL;
		} elseif ($this->settings['statLogging'] == 'FullPlus' && $realSysPath !== false) {
			status_header('200');
			$content_type = podPress_mimetypes(podPress_getFileExt($realSysPath));
			if($method == 'web') {
				header("Pragma: ");
				header("Cache-Control: ");
				header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
				header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
				header("Cache-Control: no-store, no-cache, must-revalidate"); // HTTP/1.1
				header("Cache-Control: post-check=0, pre-check=0", false);
				header('Content-Disposition: attachment; filename="'.$filename.'"');
				header("Content-Description: ".trim(htmlentities($filename)));
				header("Connection: close");
				if(substr($content_type, 0, 4) != 'text') {
					header("Content-Transfer-Encoding: binary");
				}
			} else {
				header("Connection: Keep-Alive");
			}
			header("X-ForcedBy: podPress");
			header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
			header('Content-type: '.$content_type);
			header('Content-Length: '.filesize($realSysPath));
			set_time_limit(0);
			$chunksize = 1*(1024*1024); // how many bytes per chunk
			if ($handle = fopen($realSysPath, 'rb')) {
				while (!feof($handle) && connection_status()==0) {
					echo fread($handle, $chunksize);
					ob_flush();
					flush();
				}
				fclose($handle);
			}

			if($statID !== false && connection_status()==0 && !connection_aborted()) {
				$sqlU = "UPDATE ".$wpdb->prefix."podpress_stats SET completed=1 WHERE id=".$statID;
				$wpdb->hide_errors();
				$result = $wpdb->query($sqlI);
				if(!$result) {
					$wpdb->query($sqlU);
				}
			}
			exit;
		}
		$realURL = str_replace(' ', '%20', $realURL);
		status_header('302');
		header('X-PodPress-Location: '.$realURL, true, 302);
		header('Location: '.$realURL, true, 302);
		header('Content-Length: 0');
		exit;
	}

	function podPress_remote_version_check() {
		$current = PODPRESS_VERSION;
		$latestVersionCache = podPress_get_option('podPress_versionCheck');
		if(($latestVersionCache['cached']+86400) < time() ) {
			$current = $latestVersionCache['version'];
		} elseif (class_exists(snoopy)) {
			$client = new Snoopy();
			$client->_fp_timeout = 10;
			if (@$client->fetch('http://www.mightyseek.com/podpress_downloads/versioncheck.php?url='.get_settings('siteurl').'&current='.PODPRESS_VERSION) === false) {
				return -1;
			} else {
			  $remote = $client->results;
 		  	if (!$remote || strlen($remote) > 8 ) {
					return -1;
				}
				$current = $remote;
			}
			delete_option('podPress_versionCheck');
			podPress_add_option('podPress_versionCheck', array('version'=>$current, 'cached'=> time()), 'Latest version available', 'yes'); 
		}
	
		if ($current > PODPRESS_VERSION) {
			return 1;
		} else {
			return 0;
		}
	}
	
	/**************************************************************/
	/* Functions for supporting version of WordPress before 2.0.0 */
	/**************************************************************/
	
	function podPress_add_post_meta($post_id, $key, $value, $unique = false) {
		GLOBAL $wpdb;
		if(!podPress_WPVersionCheck('2.0.0')) {
			if ( is_array($value) || is_object($value) ) {
				$value = $wpdb->escape(serialize($value));
			}
		}
		return add_post_meta($post_id, $key, $value, $unique);
	}

	function podPress_get_post_meta($post_id, $key, $single = false) {
		$result = get_post_meta($post_id, $key, $single);
		if(podPress_WPVersionCheck('2.0.0') === false) {
			$result = maybe_unserialize($result);
		}
		return $result;
	}
		
	function podPress_add_option($name, $value = '', $description = '', $autoload = 'yes') {
		GLOBAL $wpdb;
		if(!podPress_WPVersionCheck('2.0.0')) {
			if ( is_array($value) || is_object($value) ) {
				$value = serialize($value);
			}
		}
		return add_option($name, $value, $description, $autoload);
	}

	function podPress_get_option($option) {
		$option = get_option($option);
		if(!podPress_WPVersionCheck('2.0.0')) {
			$option = maybe_unserialize($option);
		}
		return $option;
	}

	function podPress_update_option($option_name, $option_value) {
		delete_option($option_name); 
		podPress_add_option($option_name, $option_value);
		return true;
	}

	/**************************************************************/
	/* Functions for supporting premiumcasting */
	/**************************************************************/	

	if(!function_exists('getallheaders')) {
		function getallheaders() {
			$headers = array();
			foreach($_SERVER as $h=>$v) {
				if(ereg('HTTP_(.+)',$h,$hp)) {
					$headers[$hp[1]]=$v;
				}
			}
 	  	return $headers;
		}
	}

	function podPress_addDigestAuth($user) {
		GLOBAL $podPress, $user_pass;
		if(!podPress_WPVersionCheck()) {
			return;
		}
		$userdata = get_userdatabylogin($user);
		$current_creds = get_usermeta($userdata->ID, 'premiumcast_creds');
		$correct_creds = md5($user . ':' . $podPress->realm . ':' . $user_pass);
		if($current_creds == $correct_creds) {
			return;
		}
		$x = update_usermeta($userdata->ID, 'premiumcast_creds', $correct_creds);
		$current_creds = get_usermeta($userdata->ID, 'premiumcast_creds');
	}

	// function to parse the http auth header
	function podPress_http_digest_parse($txt)
	{
		// protect against missing data
		$needed_parts = array('nonce'=>1, 'nc'=>1, 'cnonce'=>1, 'qop'=>1, 'username'=>1, 'uri'=>1, 'response'=>1);
		$data = array();

		if(substr($txt, 0, 6) == 'Digest') {
			$txt = substr($txt, 7);
			$attribs = explode(',', $txt);
			foreach ($attribs as $attrib) {
				$divider = strpos($attrib, '=');
				$name = trim(substr($attrib, 0, $divider));
				$val = trim(substr($attrib, $divider+1));
				if(substr($val, 0, 1) == '"' || substr($val, 0, 1) == "'") {
					$val = substr($val, 1, strlen($val)-2);
				}
				unset($needed_parts[$name]);
				$data[$name] = $val;
				//echo $name.' = '.$val."<br/>\n";
			}
		}
		if(!empty($needed_parts)) {
			return false;
		}
		return $data;

		/* this code didnt work with all browsers for some reason
		preg_match_all('@(\w+)=([\'"]?)([\?&a-zA-Z0-9=./\_-]+)\2@', $txt, $matches, PREG_SET_ORDER);
		html_print_r($matches);
		foreach ($matches as $m) {
			$data[$m[1]] = $m[3];
			unset($needed_parts[$m[1]]);
		}
		return $needed_parts ? false : $data;
		*/
	}

	function podPress_http_basic_parse($txt)
	{
		$result = array();
		list($result['username'], $result['passwd']) = explode(':', base64_decode(substr($txt, 6)));
		return $result;
	}

	function podPress_requestLogin() {
		GLOBAL $podPress;
		if(!$podPress->settings['enablePremiumContent']) {
			die('Premium Content support is disabled in podPress.');			
		}
		header('HTTP/1.0 401 Unauthorized');
		switch (PODPRESS_PREMIUM_METHOD) {
			case 'Digest':
				header('WWW-Authenticate: Digest realm="'.$podPress->realm.'", qop="auth", nonce="'.uniqid(rand()).'", opaque="'.md5($podPress->realm).'", stale=false, algorithm=MD5');
				break;
			case 'Basic':
			default:
				header('WWW-Authenticate: Basic realm="'.$podPress->realm.'"');
				break;
		}
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd">'."\n";
		echo "<HTML>\n";
		echo "  <HEAD>\n";
		echo "    <TITLE>Error</TITLE>\n";
		echo '    <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">'."\n";
		echo "  </HEAD>\n";
		echo "  <BODY>\n";
		echo "  <H1>401 Unauthorized.</H1>\n";
		echo "  The contents of this feed are only available to paying subscribers.\n";
		echo "  </BODY>\n";
		die("</HTML>\n");
	}
	
	function podPress_reloadCurrentUser() {
		global $wp, $user_login, $userdata, $user_level, $user_ID, $user_email, $user_url, $user_pass_md5, $user_identity, $current_user;
		if(defined('PODPRESS_PREMIUMLOGIN') && $GLOBALS['current_user']->ID == 0) {
			$current_user = new WP_User(PODPRESS_PREMIUMID, PODPRESS_PREMIUMLOGIN);
			$user_login = PODPRESS_PREMIUMLOGIN;
			$userdata    = get_userdatabylogin($user_login);
			$user_level  = $userdata->user_level;
			$user_ID     = $userdata->ID;
			$user_email  = $userdata->user_email;
			$user_url    = $userdata->user_url;
			$user_pass_md5 = md5($userdata->user_pass);
			$user_identity = $userdata->display_name;	
			$wp->query_posts();		
		}
	}

	if (defined('PREMIUMCAST')) {
		function get_currentuserinfo() {
			podPress_validateLogin();
		}
	}

	function podPress_validateLogin() {
		GLOBAL $user_login, $userdata, $user_level, $user_ID, $user_email, $user_url, $user_pass_md5, $user_identity, $current_user;

		if (defined('XMLRPC_REQUEST') && XMLRPC_REQUEST) {
			return false;
		}
	
		$http_headers = getallheaders();
		if (empty($http_headers['Authorization'])) {
			
			if (empty($http_headers['AUTHORIZATION'])) {
				podPress_requestLogin();
				return false;
			} else {
				$http_headers['Authorization'] = stripslashes(stripslashes($http_headers['AUTHORIZATION']));
			}
		}
		switch (PODPRESS_PREMIUM_METHOD) {
			case 'Digest':
				$data = podPress_http_digest_parse($http_headers['Authorization']);
				if (!$data) {
					die('Wrong Credentials!');
				}
				$x = get_userdatabylogin($data['username']);
				$A1 = get_usermeta($x->ID, 'premiumcast_creds');
				$A2 = md5($_SERVER['REQUEST_METHOD'].':'.$data['uri']);
				$valid_response = md5($A1.':'.$data['nonce'].':'.$data['nc'].':'.$data['cnonce'].':'.$data['qop'].':'.$A2);

				if ($data['response'] == $valid_response) {
					$user_login = $data['username'];
					$authresult = wp_login($user_login, md5($x->user_pass), true);
				}
				break;
			case 'Basic':
			default:
				$authparts = podPress_http_basic_parse($http_headers['Authorization']);
				$user_login = $authparts['username'];
				$authresult = wp_login($user_login, $authparts['passwd']);
				break;
		}
	
		if($GLOBALS['wp_object_cache']->cache['userlogins'][$user_login]->wp_capabilities['premium_subscriber'] != 1 && 
		   $GLOBALS['wp_object_cache']->cache['userlogins'][$user_login]->wp20_capabilities['premium_subscriber'] != 1) {
			$authresult = false;
	 }

		if(!$authresult) {
			podPress_requestLogin();
			return false;
			$current_user = new WP_User(0);
			return false;
		}

		$userdata    = get_userdatabylogin($user_login);
		$user_level  = $userdata->user_level;
		$user_ID     = $userdata->ID;
		$user_email  = $userdata->user_email;
		$user_url    = $userdata->user_url;
		$user_pass_md5 = md5($userdata->user_pass);
		$user_identity = $userdata->display_name;
		define('PODPRESS_PREMIUMLOGIN', $user_login);
		define('PODPRESS_PREMIUMID', $userdata->ID);

		if ( empty($current_user) ) {
			$current_user = new WP_User($user_ID);
		}
	}
