<?php
/**********************************************************************
*					Admin Page							*
*********************************************************************/
function spa_default_options() {
	$spa_settings = 	Array (
						url => str_replace("http://", "", get_bloginfo('url')),	// Blog URL
						key => '',				// Snap Shots Key
						searchbox => true,		// Search Box
						alllinks => true,		// Snap Shots on every link
						locallinks => false,	// Snap Shots on local links
						link_icon => true,		// Show Link Icon for link
						preview_trigger => 'both',	// Trigger bubble
						previewshots => false,	// Automatically display Preview Shots
						theme => 'silver',		// Snap Shots Theme
						userpreview => false,	// Let user customize theme?
						customlogo => false,	// Use Custom Logo?
						footer => true			// Add to blog theme footer?
						);
	
	return $spa_settings;
}

function spa_options() {
	
	$spa_settings = spa_read_options();

	if($_POST['spa_save']){
		$spa_settings[key] = $_POST['key'];
		if ($_POST['Theme']!='') {
			$spa_settings[theme] = $_POST['Theme'];
		} else {
			$spa_settings[theme] = 'silver';
		}

		if ($_POST['preview_trigger']) {
			$spa_settings[preview_trigger] = $_POST['preview_trigger'];
		} else {
			$spa_settings[preview_trigger] = 'both';
		}
		if ($_POST['preview_trigger'])	$spa_settings[preview_trigger] = $_POST['preview_trigger'];
		
		if ($_POST['searchbox']) {
			$spa_settings[searchbox] = true;
		} else {
			$spa_settings[searchbox] = false;
		}
		if ($_POST['alllinks']) {
			$spa_settings[alllinks] = true;
		} else {
			$spa_settings[alllinks] = false;
		}
		if ($_POST['locallinks']) {
			$spa_settings[locallinks] = true;
		} else {
			$spa_settings[locallinks] = false;
		}
		if ($_POST['previewshots']) {
			$spa_settings[previewshots] = true;
		} else {
			$spa_settings[previewshots] = false;
		}
		if ($_POST['link_icon']) {
			$spa_settings[link_icon] = true;
		} else {
			$spa_settings[link_icon] = false;
		}
		if ($_POST['userpreview']) {
			$spa_settings[userpreview] = true;
		} else {
			$spa_settings[userpreview] = false;
		}
		if ($_POST['customlogo']) {
			$spa_settings[customlogo] = true;
		} else {
			$spa_settings[customlogo] = false;
		}
		if ($_POST['Footer']) {
			$spa_settings[footer] = true;
		} else {
			$spa_settings[footer] = false;
		}
				
		update_option('ald_spa_settings', $spa_settings);
		
		echo '<div id="message" class="updated fade"><p>Options saved successfully.</p></div>';
	}
	
	if ($_POST['spa_default']){
	
		delete_option('ald_spa_settings');
		$spa_settings = spa_default_options();
		update_option('ald_spa_settings', $spa_settings);
		
		echo '<div id="message" class="updated fade"><p>Options set to Default.</p></div>';
	}
?>


<div class="wrap">
  <h2>
    <?php _e("Snap Shots&trade;"); ?>
  </h2>
  <div style="border: #ccc 1px solid; padding: 10px">
    <fieldset class="options">
    <legend>
    <h3>
      <?php _e('Support the Development'); ?>
    </h3>
    </legend>
    <p><?php _e('If you find my'); ?> <a href="http://ajaydsouza.com/wordpress/plugins/snap-preview-anywhere/">Snap Shots&trade; Plugin</a> <?php _e('useful, please do'); ?> <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_xclick&amp;business=donate@ajaydsouza.com&amp;item_name=Snap%20Shots%20Plugin%20(From%20WP-Admin)&amp;no_shipping=1&amp;return=http://ajaydsouza.com/wordpress/plugins/snap-preview-anywhere/&amp;cancel_return=http://ajaydsouza.com/wordpress/plugins/snap-preview-anywhere/&amp;cn=Note%20to%20Author&amp;tax=0&amp;currency_code=USD&amp;bn=PP-DonationsBF&amp;charset=UTF-8" title="Donate via PayPal"><?php _e('drop in your contribution'); ?></a>. (<a href="http://ajaydsouza.com/donate/" title="Some reasons why you should donate"><?php _e('Why should you?'); ?></a>)</p>
    </fieldset>
  </div>
  <form method="post" id="spa_options" name="spa_options" style="border: #ccc 1px solid; padding: 10px">
    <fieldset class="options">
    <legend>
    <h3>
      <?php _e('Options:'); ?>
    </h3>
    </legend>
	<p>
		<label for="key"><strong><?php _e('Snap Shots Key:'); ?></strong></label>
		<input type="text" name="key" id="key" value="<?php echo $spa_settings[key]; ?>" size="40" maxlength="32" />
		<?php _e('<a href="http://ajaydsouza.com/archives/2007/01/02/how-to-find-your-spa-key/">How to find your key</a>'); ?>
	</p>
	<p>
		<label><input type="checkbox" name="searchbox" id="searchbox" value="true" <?php if ($spa_settings[searchbox]) { ?> checked="checked" <?php } ?> />
		<?php _e('Display Snap searchbox below the thumbnail?'); ?></label>
	</p>
	<p>
		<label><input type="checkbox" name="alllinks" id="alllinks" value="true" <?php if ($spa_settings[alllinks]) { ?> checked="checked" <?php } ?> />
		<?php _e('Display Preview for all links? (If disabled, you will need to add <code>class="snap_shots"</code> for links you want the Snap Shots to display on.'); ?></label>
	</p>
	<p>
		<label><input type="checkbox" name="locallinks" id="locallinks" value="true" <?php if ($spa_settings[locallinks]) { ?> checked="checked" <?php } ?> />
		<?php _e('Display Preview for internal links? (Only works if preview is enabled for all links)'); ?></label>
	</p>
	<p>
		<label><input type="checkbox" name="previewshots" id="previewshots" value="true" <?php if ($spa_settings[previewshots]) { ?> checked="checked" <?php } ?> />
		<?php _e('Only display PreviewShots'); ?></label>
	</p>
	<p>
		<label><input type="checkbox" name="Footer" id="Footer" value="true" <?php if ($spa_settings[footer]) { ?> checked="checked" <?php } ?> />
		<?php _e('Automatically add the code to your footer? (You\'re theme needs to have <code>wp_footer()</code> for this to work.)'); ?></label>
	</p>
	<div id="spa_linkicon">
	<h4><?php _e('Link Icon Settings:'); ?> <a href="http://www.snap.com/about/spa_faq.php#r" target="_blank">?</a></h4>
	<p>
		<label><input type="checkbox" name="link_icon" id="link_icon" value="true" <?php if ($spa_settings[link_icon]) { ?> checked="checked" <?php } ?> />
		<?php _e('Add an Icon to indicate link has Snap Shots'); ?></label>
	</p>
	<p><strong><?php _e('Link Icon Behavior'); ?></strong></p>
	<p>
		<label>
		<input name="preview_trigger" type="radio" value="both" <?php if ($spa_settings[preview_trigger]=='both') { ?> checked="checked" <?php } ?> />
		<?php _e('Both (Snap Shots Bubble pops up when cursor is over both link and icon)'); ?></label>
		<br />
		<label>
		<input name="preview_trigger" type="radio" value="icon" <?php if ($spa_settings[preview_trigger]=='icon') { ?> checked="checked" <?php } ?> />
		<?php _e('Icon (Snap Shots Bubble pops up only when cursor is over the icon)'); ?></label>
	</p>
	</div>
	<div id="swatches">
		<h4><?php _e('Theme:'); ?></h4>
		<div class="swatch-div">
			<a id="th_silver" class="swatch color1 <?php if (($spa_settings[theme]=='')||($spa_settings[theme]=='silver')) { ?> selected <?php } ?>" onclick="return toggle_theme('silver');"><br /></a>
		</div>
		<div class="swatch-sep"></div>
		<div class="swatch-div">
			<a id="th_ice" class="swatch color2 <?php if ($spa_settings[theme]=='ice') { ?> selected <?php } ?>" onclick="return toggle_theme('ice');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_green" class="swatch color3 <?php if ($spa_settings[theme]=='green') { ?> selected <?php } ?>" onclick="return toggle_theme('green');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_linen" class="swatch color4 <?php if ($spa_settings[theme]=='linen') { ?> selected <?php } ?>" onclick="return toggle_theme('linen');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_orange" class="swatch color5 <?php if ($spa_settings[theme]=='orange') { ?> selected <?php } ?>" onclick="return toggle_theme('orange');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_pink" class="swatch color6 <?php if ($spa_settings[theme]=='pink') { ?> selected <?php } ?>" onclick="return toggle_theme('pink');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_purple" class="swatch color7 <?php if ($spa_settings[theme]=='purple') { ?> selected <?php } ?>" onclick="return toggle_theme('purple');"><br /></a>
		</div>
		<div class="swatch-div">
			<a id="th_asphalt" class="swatch color8 <?php if ($spa_settings[theme]=='asphalt') { ?> selected <?php } ?>" onclick="return toggle_theme('asphalt');"><br /></a>
		</div>
		<p style="clear:both">
			<label><input type="text" name="Theme" id="Theme" value="<?php echo $spa_settings[theme]; ?>" size="40" readonly="readonly" />
			<?php _e('Theme for the Snap Shots Bubble'); ?></label>
		</p>
	</div>
	<h3><?php _e('Advanced Settings'); ?></h3>
	<p>
		<label><input type="checkbox" name="userpreview" id="userpreview" value="true" <?php if ($spa_settings[userpreview]) { ?> checked="checked" <?php } ?> />
		<?php _e('Allow your site visitor to turn Snap Shots ON/OFF? (You need to add <?php do_action(\'echo_spa_visitor\'); ?> where you want to display the options <code>iframe</code>. <strong>This will break XHTML 1.1 validation</strong>)'); ?></label>
	</p>
	<p>
		<label><input type="checkbox" name="customlogo" id="customlogo" value="true" <?php if ($spa_settings[customlogo]) { ?> checked="checked" <?php } ?> />
		<?php _e('Custom Logo (Select this only if you have uploaded your Custom Logo on the Snap Site)'); ?></label>
	</p>
	<p>
	    <input type="submit" name="spa_save" id="spa_save" value="Save Options" style="border:#00CC00 1px solid" />
        <input name="spa_default" type="submit" id="spa_default" value="Default Options" style="border:#FF0000 1px solid" onclick="if (!confirm('Do you want to set options to Default? If you don\'t have a copy of the Key, please hit Cancel and copy it first.')) return false;" />
	</p>
    </fieldset>
  </form>
</div>
<?php

}


function spa_adminmenu() {
	if (function_exists('current_user_can')) {
		// In WordPress 2.x
		if (current_user_can('manage_options')) {
			$spa_is_admin = true;
		}
	} else {
		// In WordPress 1.x
		global $user_ID;
		if (user_can_edit_user($user_ID, 0)) {
			$spa_is_admin = true;
		}
	}

	if ((function_exists('add_options_page'))&&($spa_is_admin)) {
		add_options_page(__("Snap Shots"), __("Snap Shots"), 9, 'spa_options', 'spa_options');
		}
}

function spa_adminhead()
{
?>

<style type="text/css">
a.swatch:hover { border-bottom: #f60 1px solid; border-left: #f60 1px solid; border-right: #f60 1px solid; border-top: #f60 1px solid; }
.color1 { background: #eee; border-bottom: #888 1px solid; border-left: #888 1px solid; border-right: #888 1px solid; border-top: #888 1px solid; }
.color2 { background: #def; border-bottom: #578 1px solid; border-left: #578 1px solid; border-right: #578 1px solid; border-top: #578 1px solid; }
.color3 { background: #deb; border-bottom: #684 1px solid; border-left: #684 1px solid; border-right: #684 1px solid; border-top: #684 1px solid; }
.color4 { background: #e4dbd0; border-bottom: #876 1px solid; border-left: #876 1px solid; border-right: #876 1px solid; border-top: #876 1px solid; }
.color5 { background: #fea; border-bottom: #b50 1px solid; border-left: #b50 1px solid; border-right: #b50 1px solid; border-top: #b50 1px solid; }
.color6 { background: #fde; border-bottom: #967 1px solid; border-left: #967 1px solid; border-right: #967 1px solid; border-top: #967 1px solid; }
.color7 { background: #dde; border-bottom: #668 1px solid; border-left: #668 1px solid; border-right: #668 1px solid; border-top: #668 1px solid; }
.color8 { background: #444; border-bottom: #222 1px solid; border-left: #222 1px solid; border-right: #222 1px solid; border-top: #222 1px solid; }
.swatch { float: left; height: 30px; width: 30px; cursor: pointer; }
.swatch-div { float: left; padding-bottom: 8px; padding-left: 8px; padding-right: 8px; padding-top: 8px; }
.swatch-sep { border-left: #bba 1px dotted; float: left; height: 32px; margin: 7px 7px 15px; width: 1px; }
.selected { border-bottom: #bba 1px solid; border-left: #bba 1px solid; border-right: #bba 1px solid; border-top: #bba 1px solid; padding-bottom: 7px; padding-left: 7px; padding-right: 7px; padding-top: 7px; }
</style>

<?php
}
function spa_adminfoot()
{
?>
<script type="text/javascript"><!--
function toggle_theme(new_th) {
	var spa_options_form = document.spa_options;
	var ThemeValue = spa_options_form.Theme.value;
	if (ThemeValue == '') ThemeValue = 'silver';
	var el = document.getElementById("th_"+ThemeValue);
	el.className = el.className.replace(/ selected/g,"");
	el = document.getElementById("th_"+new_th);
	el.className += " selected";
	spa_options_form.Theme.value = new_th;
	return false;
}
-->
</script>

<?php
}

add_action('admin_menu', 'spa_adminmenu');
add_action('admin_head', 'spa_adminhead');
add_action('admin_footer', 'spa_adminfoot');

?>