<?php
/*
Plugin Name: diggZ-Et
Plugin URI: http://blog.rswr.net/2008/05/23/wordpress-plugin-diggz-et/
Description: Automatically displays a "digg" button for each post. Full <a href="options-general.php?page=diggZ-Et.php">admin options</a> available.
Version: 1.2.2
Author: Ryan Christenson (The RSWR Network)
Author URI: http://www.rswr.net/
*/

/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if (!class_exists("diggZEt")) {
	class diggZEt {
		var $adminOptionsName = "diggZEtAdminOptions";
		function diggZEt() { //constructor
		}

		//Returns an array of admin options
		function getAdminOptions() {
			$dZEtAdminOptions = array('home' => 'true', 'post' => 'true', 'page' => 'true', 'tag' => 'true', 'arch' => 'true', 'srch' => 'true', 'promote' => 'true', 'bg' => 'true', 'display1' => 'true', 'skin' => 'true', 'win' => 'true', 'body' => 'true', 'media' => 'true', 'topic' => 'true');
			$dZEtOptions = get_option($this->adminOptionsName);
			if (!empty($dZEtOptions)) {
				foreach ($dZEtOptions as $key => $option)
				$dZEtAdminOptions[$key] = $option;
			}
			update_option($this->adminOptionsName, $dZEtAdminOptions);
			return $dZEtAdminOptions;
		}
		function init() {
			$this->getAdminOptions();
		}

		//Prints out the admin page
		function printAdminPage() {
			$dZEtOptions = $this->getAdminOptions();
			if (isset($_POST['update_diggZEtSettings'])) {
			
				// Save Settings
				if($_POST['home'] == "on") update_option('dZEt_home', "checked=on");
  				else update_option('dZEt_home', "");
  				if($_POST['post'] == "on") update_option('dZEt_post', "checked=on");
  				else update_option('dZEt_post', "");
  				if($_POST['page'] == "on") update_option('dZEt_page', "checked=on");
  				else update_option('dZEt_page', "");
  				if($_POST['tag'] == "on") update_option('dZEt_tag', "checked=on");
  				else update_option('dZEt_tag', "");
  				if($_POST['arch'] == "on") update_option('dZEt_arch', "checked=on");
  				else update_option('dZEt_arch', "");
  				if($_POST['srch'] == "on") update_option('dZEt_srch', "checked=on");
  				else update_option('dZEt_srch', "");
  				if($_POST['promote'] == "on") update_option('dZEt_promote', "checked=on");
  				else update_option('dZEt_promote', "");
  				$dz_bg = $_POST['bg'];
  				$dz_display1 = $_POST['display1'];
  				$dz_skin = $_POST['skin'];
  				$dz_win = $_POST['win'];
  				$dz_body = $_POST['body'];
  				$dz_media = $_POST['media'];
  				$dz_topic = $_POST['topic'];

				// Update Settings
				update_option('dZEt_bg', $dz_bg);
				update_option('dZEt_display1', $dz_display1);
				update_option('dZEt_skin', $dz_skin);
				update_option('dZEt_win', $dz_win);
				update_option('dZEt_body', $dz_body);
				update_option('dZEt_media', $dz_media);
				update_option('dZEt_topic', $dz_topic);

				// Update Admin
				update_option($this->adminOptionsName, $dZEtOptions);
?>
<div class="updated"><p><span class="tblBold"><?php _e("diggZ-Et Options Updated!", "diggZEt");?></span></p></div>
<?php
			} else {
				// Retrieve Options
				$dz_bg = get_option('dZEt_bg');
				$dz_display1 = get_option('dZEt_display1');
				$dz_skin = get_option('dZEt_skin');
				$dz_win = get_option('dZEt_win');
				$dz_body = get_option('dZEt_body');
				$dz_media = get_option('dZEt_media');
				$dz_topic = get_option('dZEt_topic');
			}
?>
<div class="wrap">
<h2><?php _e('diggZ-Et 1.2.2','diggZEt'); ?></h2>
<style type="text/css">
		
.tblPad td{padding:10px;text-align:left; vertical-align:top;}
.tblPad th{text-align:left; vertical-align:top;}
.tblRed{color:red;font-weight:700;}
.tblBold{font-weight:700;}

</style>
<form class="form-table" method="post" action="<?php _e($_SERVER["REQUEST_URI"]); ?>">
<?php //Display Settings ?>
  <div class="postbox" id="poststuff">
    <div class="postbox">
      <h3 class="hndle"><span><?php _e('Display Settings','diggZEt'); ?></span></h3>
      <div class="inside">
<table width="100%">
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Hide Buttons On...</span>
</td><td>
<span class="tblBold">
<input type="checkbox" name="home" <?php _e(get_option('dZEt_home')); ?> /> Home Page (Recommended to speed up your Home Page's load time.)<br />
<input type="checkbox" name="post" <?php _e(get_option('dZEt_post')); ?> /> Posts<br />
<input type="checkbox" name="page" <?php _e(get_option('dZEt_page')); ?> /> Pages<br />
<input type="checkbox" name="tag" <?php _e(get_option('dZEt_tag')); ?> /> Tag Pages<br />
<input type="checkbox" name="arch" <?php _e(get_option('dZEt_arch')); ?> /> Archives (This is all Category, Author and Date based pages)<br />
<input type="checkbox" name="srch" <?php _e(get_option('dZEt_srch')); ?> /> Search Page Results<br />
<span style="color:red;">Single Page or Post</span>
<br />Note: Add the following html snippet to any page or post you would like to the hide the digg button on.
<br />&lt;!--diggZ=none--&gt;
</span>
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Button Position</span>
</td><td>
<select id="display1" name="display1">
	<option value="" <?php _e($dz_display1=="" ? "selected" : ""); ?>>Top Right</option>
	<option value="left" <?php _e($dz_display1=="left" ? "selected" : ""); ?>>Top Left</option>
	<option value="bottomL" <?php _e($dz_display1=="bottomL" ? "selected" : ""); ?>>Bottom Left</option>
	<option value="bottomR" <?php _e($dz_display1=="bottomR" ? "selected" : ""); ?>>Bottom Right</option>
</select>
</td></tr>
</table>
      </div>
    </div>
  </div>
<?php //Button Settings ?>
  <div class="postbox" id="poststuff">
    <div class="postbox">
      <h3 class="hndle"><span><?php _e('Button Settings','diggZEt'); ?></span></h3>
      <div class="inside">
<table width="100%" class="tblPad">
<tr>
<th scope="row">
<span class="tblBold">Background Color</span>
</td><td colspan="2">
<input type="text" name="bg" size="10" maxlength="7" value="<?php if ($dz_bg == "") {_e("#FFFFFF");} else {_e($dz_bg);} ?>" />
<br /><span class="tblRed">Use Hex Format Only (EG. #FFFFFF)</span>
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Skin Type</span>
</td><td>
<select id="skin" name="skin">
	<option value="" <?php _e($dz_skin=="" ? "selected" : ""); ?>>Default</option>
	<option value="compact" <?php _e($dz_skin=="compact" ? "selected" : ""); ?>>Compact</option>
	<option value="icon" <?php _e($dz_skin=="icon" ? "selected" : ""); ?>>Icon</option>
</select>
</td>
<td>
<img src="<?php echo diggZEt_Url(); ?>digg-examples.png" width="320px" height="120px" />
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Browser Window</span>
</td><td colspan="2">
<select id="win" name="win">
	<option value="" <?php _e($dz_win=="" ? "selected" : ""); ?>>Default Window</option>
	<option value="new" <?php _e($dz_win=="new" ? "selected" : ""); ?>>New Window</option>
</select>
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Summary</span>
</td><td colspan="2">
<select id="body" name="body">
	<option value="" <?php _e($dz_body=="" ? "selected" : ""); ?>>Manual (Blank Summary)</option>
	<option value="150" <?php _e($dz_body=="150" ? "selected" : ""); ?>>150 Charachter Summary</option>
	<option value="250" <?php _e($dz_body=="250" ? "selected" : ""); ?>>250 Charachter Summary</option>
	<option value="350" <?php _e($dz_body=="350" ? "selected" : ""); ?>>350 Charachter Summary</option>
</select>
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Media</span>
</td><td colspan="2">
<select id="media" name="media">
	<option value="news" <?php _e($dz_media=="news" ? "selected" : ""); ?>>News</option>
	<option value="video" <?php _e($dz_media=="video" ? "selected" : ""); ?>>Video</option>
	<option value="image" <?php _e($dz_media=="image" ? "selected" : ""); ?>>Image</option>
</select>
<br /><span class="tblRed">The default type of media being submitted.</span>
<span class="tblBold">
<br />Note: If you need to use multiple types of media, add one of the following html snippets to your page or post.
<br /> &lt;!--diggZM=news--&gt;
<br /> &lt;!--diggZM=image--&gt;
<br /> &lt;!--diggZM=video--&gt;
</span>
</td></tr>
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Topic</span>
</td><td colspan="2">
<select id="topic" name="topic">
	<option value="" <?php _e($dz_topic=="" ? "selected" : ""); ?>>Blank</option>
	<option value="apple" <?php _e($dz_topic=="apple" ? "selected" : ""); ?>>Apple</option>
	<option value="arts_culture" <?php _e($dz_topic=="arts_culture" ? "selected" : ""); ?>>Arts Culture</option>
	<option value="autos" <?php _e($dz_topic=="autos" ? "selected" : ""); ?>>Autos</option>
	<option value="baseball" <?php _e($dz_topic=="baseball" ? "selected" : ""); ?>>Baseball</option>
	<option value="basketball" <?php _e($dz_topic=="basketball" ? "selected" : ""); ?>>Basketball</option>
	<option value="business_finance" <?php _e($dz_topic=="business_finance" ? "selected" : ""); ?>>Business Finance</option>
	<option value="celebrity" <?php _e($dz_topic=="celebrity" ? "selected" : ""); ?>>Celebrity</option>
	<option value="comedy" <?php _e($dz_topic=="comedy" ? "selected" : ""); ?>>Comedy</option>
	<option value="comics_animation" <?php _e($dz_topic=="comics_animation" ? "selected" : ""); ?>>Comics Animation</option>
	<option value="design" <?php _e($dz_topic=="design" ? "selected" : ""); ?>>Design</option>
	<option value="educational" <?php _e($dz_topic=="educational" ? "selected" : ""); ?>>Educational</option>
	<option value="environment" <?php _e($dz_topic=="environment" ? "selected" : ""); ?>>Environment</option>
	<option value="extreme_sports" <?php _e($dz_topic=="extreme_sports" ? "selected" : ""); ?>>Extreme Sports</option>
	<option value="food_drink" <?php _e($dz_topic=="food_drink" ? "selected" : ""); ?>>Food Drink</option>
	<option value="football" <?php _e($dz_topic=="football" ? "selected" : ""); ?>>Football</option>
	<option value="gadgets" <?php _e($dz_topic=="gadgets" ? "selected" : ""); ?>>Gadgets</option>
	<option value="gaming_news" <?php _e($dz_topic=="gaming_news" ? "selected" : ""); ?>>Gaming News</option>
	<option value="general_sciences" <?php _e($dz_topic=="general_sciences" ? "selected" : ""); ?>>General Sciences</option>
	<option value="golf" <?php _e($dz_topic=="golf" ? "selected" : ""); ?>>Golf</option>
	<option value="hardware" <?php _e($dz_topic=="hardware" ? "selected" : ""); ?>>Hardware</option>
	<option value="health" <?php _e($dz_topic=="health" ? "selected" : ""); ?>>Health</option>
	<option value="hockey" <?php _e($dz_topic=="hockey" ? "selected" : ""); ?>>Hockey</option>
	<option value="linux_unix" <?php _e($dz_topic=="linux_unix" ? "selected" : ""); ?>>Linux Unix</option>
	<option value="microsoft" <?php _e($dz_topic=="microsoft" ? "selected" : ""); ?>>Microsoft</option>
	<option value="mods" <?php _e($dz_topic=="mods" ? "selected" : ""); ?>>Mods</option>
	<option value="motorsport" <?php _e($dz_topic=="motorsport" ? "selected" : ""); ?>>Motorsport</option>
	<option value="movies" <?php _e($dz_topic=="movies" ? "selected" : ""); ?>>Movies</option>
	<option value="music" <?php _e($dz_topic=="music" ? "selected" : ""); ?>>Music</option>
	<option value="nintendo" <?php _e($dz_topic=="nintendo" ? "selected" : ""); ?>>Nintendo</option>
	<option value="odd_stuff" <?php _e($dz_topic=="odd_stuff" ? "selected" : ""); ?>>Odd Stuff</option>
	<option value="olympics" <?php _e($dz_topic=="olympics" ? "selected" : ""); ?>>Olympics</option>
	<option value="other_sports" <?php _e($dz_topic=="other_sports" ? "selected" : ""); ?>>Other Sports</option>
	<option value="pc_games" <?php _e($dz_topic=="pc_games" ? "selected" : ""); ?>>PC Games</option>
	<option value="people" <?php _e($dz_topic=="people" ? "selected" : ""); ?>>People</option>
	<option value="pets_animals" <?php _e($dz_topic=="pets_animals" ? "selected" : ""); ?>>Pets Animals</option>
	<option value="playable_web_games" <?php _e($dz_topic=="playable_web_games" ? "selected" : ""); ?>>Playable Web Games</option>
	<option value="playstation" <?php _e($dz_topic=="playstation" ? "selected" : ""); ?>>Playstation</option>
	<option value="political_opinion" <?php _e($dz_topic=="political_opinion" ? "selected" : ""); ?>>Political Opinion</option>
	<option value="politics" <?php _e($dz_topic=="politics" ? "selected" : ""); ?>>Politics</option>
	<option value="programming" <?php _e($dz_topic=="programming" ? "selected" : ""); ?>>Programming</option>
	<option value="security" <?php _e($dz_topic=="security" ? "selected" : ""); ?>>Security</option>
	<option value="soccer" <?php _e($dz_topic=="soccer" ? "selected" : ""); ?>>Soccer</option>
	<option value="software" <?php _e($dz_topic=="software" ? "selected" : ""); ?>>Software</option>
	<option value="space" <?php _e($dz_topic=="space" ? "selected" : ""); ?>>Space</option>
	<option value="tech_news" <?php _e($dz_topic=="tech_news" ? "selected" : ""); ?>>Tech News</option>
	<option value="television" <?php _e($dz_topic=="television" ? "selected" : ""); ?>>Television</option>
	<option value="tennis" <?php _e($dz_topic=="tennis" ? "selected" : ""); ?>>Tennis</option>
	<option value="travel_places" <?php _e($dz_topic=="travel_places" ? "selected" : ""); ?>>Travel Places</option>
	<option value="world_news" <?php _e($dz_topic=="world_news" ? "selected" : ""); ?>>World News</option>
	<option value="xbox" <?php _e($dz_topic=="xbox" ? "selected" : ""); ?>>Xbox</option>
</select>
<br /><span class="tblRed">Leave this set to "Blank" if you want the poster to choose the topic.</span>
</td></tr>
</table>
      </div>
    </div>
  </div>
<?php //Other Settings ?>
  <div class="postbox" id="poststuff">
    <div class="postbox">
      <h3 class="hndle"><span><?php _e('Other Settings','diggZEt'); ?></span></h3>
      <div class="inside">
<table width="100%">
<tr>
<th scope="row" style="text-align:left; vertical-align:top;">
<span class="tblBold">Help promote diggZ-Et?</span>
</td><td>
<input type="checkbox" name="promote" <?php _e(get_option('dZEt_promote')); ?> />  <span class="tblBold">Place a support link at the bottom of each post/page that uses a digg button. Thanks for your support!</span>
</td></tr>
</table>
      </div>
    </div>
  </div>
<?php //More Plugins ?>
  <div class="postbox" id="poststuff">
    <div class="postbox">
      <h3 class="hndle"><span><?php _e('Like this plugin?','diggZEt'); ?> Try another Social Bookmarking Plugin by <a href="http://www.rswr.net/">The RSWR Network</a></span></h3>
      <div class="inside">
      <ul>
<li><a href="http://blog.rswr.net/2008/11/13/yahoo-buzz-wordpress-plugin/" target="blank">buzzZ-Et (Yahoo! Buzz Buttons)</a></li>
<li><a href="http://blog.rswr.net/2008/07/28/dzonez-et-wordpress-plugin/" target="blank">dzoneZ-Et (dZone Buttons)</a></li>
<li><a href="http://blog.rswr.net/2008/07/29/reddz-et-wordpress-plugin/" target="blank">reddZ-Et (reddit Buttons)</a></li>
      </ul>
      </div>
    </div>
  </div>
	<input type="submit" name="update_diggZEtSettings" value="<?php _e('Update Settings', 'diggZEt') ?>" class="button-primary action" /><br /><br />
</form>
</div>
<?php
		}
	}
}

// Get Plugin URL
function diggZEt_Url() {
	$path = dirname(__FILE__);
	$path = str_replace("\\","/",$path);
	$path = trailingslashit(get_bloginfo('wpurl')) . trailingslashit(substr($path,strpos($path,"wp-content/")));
	return $path;
}

//Initialize the admin panel
if (!function_exists("diggZEt_ap")) {
	function diggZEt_ap() {
		global $dZEt_init;
		if (!isset($dZEt_init)) {
			return;
		}
		if (function_exists('add_options_page')) {
			add_options_page('diggZ-Et', 'diggZ-Et', 9, basename(__FILE__), array(&$dZEt_init, 'printAdminPage'));
		}
	}
}

// Truncate the Summary
if (!function_exists("diggZEt_trunk")) {
	function diggZEt_trunc($trunc, $tnum) {
		if (strlen($trunc) > 0 && strlen($trunc) > $tnum) {
			$k = 0;
			while ($k >= 0 && $k < strlen($trunc)) {
				$i = strpos($trunc, " ", $k);
				$j = strpos($trunc, chr(10), $k);
				if ($i === FALSE && $j === FALSE) {
					return $trunc;
				} else {
					if ($i > 0 && $j > 0) {
						if ($i < $j) {
							$k = $i;
						} else {
							$k = $j;
						}
					} elseif ($i > 0) {
						$k = $i;
					} elseif ($j > 0) {
						$k = $j;
					}

					if ($k >= $tnum) {
						return substr($trunc, 0, $k) . "...";
					} else {
						$k++;
					}
				}
			}
		} else {
			return $trunc;
		}
	}
}

// Create Button
if (!function_exists("diggZEt_But")) {
	function diggZEt_But($content) {
		// Retrieve Options
		$dz_bg = get_option('dZEt_bg');
		$dz_display1 = get_option('dZEt_display1');
		$dz_skin = get_option('dZEt_skin');
		$dz_win = get_option('dZEt_win');
		$dz_body = get_option('dZEt_body');
		$dz_media = get_option('dZEt_media');
		$dz_topic = get_option('dZEt_topic');
?>
<?php
// Display Top Right
if($dz_display1 == "") {
echo '<div style="float: right; width: 42px; padding-right: 10px; margin: 0 0 0 10px;">';
}

// Display Top Left
if($dz_display1 == "left") {
	if($dz_skin == "") {
echo '<div style="float: left; width: 42px; padding-right: 10px; margin: 0 10px 0 0;">';
	}
	elseif($dz_skin == "compact") {
echo '<div style="float: left; width: 42px; padding-right: 45px; margin: 0 45px 0 0;">';
	}
	elseif($dz_skin == "icon") {
echo '<div style="float: left; width: 16px; padding-right: 10px; margin: 0 10px 0 0;">';
	}
}

// Display Bottom Left
if($dz_display1 == "bottomL") {
	if($dz_skin == "") {
echo '<div style="position:relative; width: 100%; padding: 0 0 100px 0;">';
echo '<div style="position: absolute; bottom: 10px; width: 42px;">';
	}
	elseif($dz_skin == "compact" || $dz_skin == "icon") {
echo '<div style="position:relative; width: 100%; padding: 0 0 35px 0;">';
echo '<div style="position: absolute; bottom: 10px; width: 42px;">';
	}
}

// Display Bottom Right
if($dz_display1 == "bottomR") {
	if($dz_skin == "") {
echo '<div style="position:relative; width: 100%; padding: 0 0 100px 0;">';
echo '<div style="position: absolute; bottom: 10px; right:10px; width: 42px;">';
	}
	elseif($dz_skin == "compact") {
echo '<div style="position:relative; width: 100%; padding: 0 0 35px 0;">';
echo '<div style="position: absolute; bottom: 10px; right:50px; width: 42px;">';
	}
	elseif($dz_skin == "icon") {
echo '<div style="position:relative; width: 100%; padding: 0 0 30px 0;">';
echo '<div style="position: absolute; bottom: 10px; right:0; width: 42px;">';
	}
}
?>
<script type="text/javascript">
<?php
$dz_old = array('/\n/', '/\\[[^\\]]*\\]/');
$dz_new = array('', '');
?>
<!--
digg_url = '<?php the_permalink(); ?>';
digg_bgcolor = '<?php _e($dz_bg); ?>';
digg_skin = '<?php _e($dz_skin); ?>';
digg_window = '<?php _e($dz_win); ?>';
digg_title = '<?php the_title(); ?>';
digg_bodytext = '<?php if($dz_body != "") _e(diggZEt_trunc(strip_tags(preg_replace($dz_old, $dz_new, $content)),$dz_body)); ?>';
digg_media = '<?php if (strpos($content, "diggZM=video") == TRUE) {_e("video");} elseif (strpos($content, "diggZM=image") == TRUE) {_e("image");} elseif (strpos($content, "diggZM=news") == TRUE) {_e("news");} else {_e($dz_media);}; ?>';
digg_topic = '<?php _e($dz_topic); ?>';
//-->
</script>
<script src="http://digg.com/tools/diggthis.js" type="text/javascript"></script>
</div>
<?php
	}
}

// Add Button
if (!function_exists("diggZEt_AddBut")) {
	function diggZEt_AddBut($content) {
		$dz_display1 = get_option('dZEt_display1');
		//error_reporting(E_ALL);
		if(is_home() && get_option('dZEt_home') == "checked=on") return $content;
		if(is_single() && get_option('dZEt_post') == "checked=on") return $content;
		if(is_page() && get_option('dZEt_page') == "checked=on") return $content;
		if(is_tag() && get_option('dZEt_tag') == "checked=on") return $content;
		if(is_archive() && get_option('dZEt_arch') == "checked=on") return $content;
		if(is_search() && get_option('dZEt_srch') == "checked=on") return $content;
		if (strpos($content, "diggZ=none") == TRUE) return $content;
		if($dz_display1 == "bottomL" || $dz_display1 == "bottomR") {
			$content = diggZEt_But($content).$content;
			if(is_page() || is_single()) {
				if (get_option('dZEt_promote') == "checked=on") {
					$content .= "<p>Digg buttons brought to you by <a href='http://blog.rswr.net/2008/05/23/wordpress-plugin-diggz-et/'>diggZ-ET (WordPress Plugin)</a></p></div>";
				} else {
					$content .= '</div>';
				}
			} else {
				$content .= '</div>';
			}
			return $content;
		}
		else {
			$content = diggZEt_But($content).$content;
			if(is_page() || is_single()) {
				if (get_option('dZEt_promote') == "checked=on") {
					$content .= "<p>Digg buttons brought to you by <a href='http://blog.rswr.net/2008/05/23/wordpress-plugin-diggz-et/'>diggZ-ET (WordPress Plugin)</a></p>";
				}
			}
			return $content;
		}
	}
}

// Initialize Class
if (class_exists("diggZEt")) {
	$dZEt_init = new diggZEt();
}

//Actions and Filters
if (isset($dZEt_init)) {
	//Actions
	add_action('diggZ-Et/diggZ-Et.php', array(&$dZEt_init, 'init'));
	add_action('admin_menu', 'diggZEt_ap');
	//Filters
	add_filter('the_content', 'diggZEt_AddBut');
}

?>
